/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class MultiFactorAuthenticationTransition {
    @Nonnull
    private Map<String, Function<ProfileRequestContext, String>> nextFlowStrategyMap = new HashMap<String, Function<ProfileRequestContext, String>>();

    @Nonnull
    public Function<ProfileRequestContext, String> getNextFlowStrategy(@Nonnull @NotEmpty String event) {
        Function<ProfileRequestContext, String> result = this.nextFlowStrategyMap.get(event);
        if (result != null) {
            return result;
        }
        return FunctionSupport.constant(null);
    }

    @Nonnull
    @Live
    Map<String, Function<ProfileRequestContext, String>> getNextFlowStrategyMap() {
        return this.nextFlowStrategyMap;
    }

    public void setNextFlowStrategyMap(@Nonnull Map<String, Object> map) {
        Constraint.isNotNull(map, (String)"Transition strategy map cannot be null");
        this.nextFlowStrategyMap.clear();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String trimmed = StringSupport.trimOrNull((String)entry.getKey());
            if (trimmed == null) continue;
            if (entry.getValue() instanceof String) {
                String flowId = StringSupport.trimOrNull((String)((String)entry.getValue()));
                if (flowId == null) continue;
                this.nextFlowStrategyMap.put(trimmed, FunctionSupport.constant((Object)flowId));
                continue;
            }
            if (entry.getValue() instanceof Function) {
                this.nextFlowStrategyMap.put(trimmed, (Function)entry.getValue());
                continue;
            }
            if (entry.getValue() == null) continue;
            LoggerFactory.getLogger(MultiFactorAuthenticationTransition.class).warn("Ignoring mapping from {} to unsupported object of type {}", (Object)trimmed, entry.getValue().getClass());
        }
    }

    public void setNextFlow(@Nullable @NotEmpty String flowId) {
        this.setNextFlowStrategyMap(CollectionSupport.singletonMap((Object)"proceed", (Object)flowId));
    }

    public void setNextFlowStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        Constraint.isNotNull(strategy, (String)"Flow strategy function cannot be null");
        this.setNextFlowStrategyMap(CollectionSupport.singletonMap((Object)"proceed", strategy));
    }
}

