/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.app.event.EventHandler;
import org.apache.velocity.app.event.ReferenceInsertionEventHandler;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;
import org.ldaptive.FilterTemplate;
import org.ldaptive.auth.SearchDnResolver;
import org.ldaptive.auth.User;

public abstract class AbstractTemplateSearchDnResolver
extends SearchDnResolver {
    @Nonnull
    private final Template template;
    private final ReferenceInsertionEventHandler eventHandler = new EscapingReferenceInsertionEventHandler();

    public AbstractTemplateSearchDnResolver(@Nonnull VelocityEngine engine, @Nonnull @NotEmpty String filter) throws VelocityException {
        this.template = Template.fromTemplate((VelocityEngine)engine, (String)filter, (Charset)StandardCharsets.UTF_8);
        this.setUserFilter(filter);
    }

    @Nonnull
    public Template getTemplate() {
        return this.template;
    }

    @Nonnull
    protected FilterTemplate createFilterTemplate(User user) {
        FilterTemplate filter = new FilterTemplate();
        if (user != null && user.getContext() != null) {
            VelocityContext context = (VelocityContext)user.getContext();
            EventCartridge cartridge = new EventCartridge();
            cartridge.addEventHandler((EventHandler)this.eventHandler);
            cartridge.attachToContext((Context)context);
            String result = this.template.merge((Context)context);
            if (result != null && !"".equals(result)) {
                filter.setFilter(result.trim());
            } else {
                this.logger.error("Invalid template filter produced from {}, cannot be null or empty.", (Object)this.template);
            }
            if (this.getUserFilterParameters() != null) {
                filter.setParameters(this.getUserFilterParameters());
            }
            if (user.getIdentifier() != null && !"".equals(user.getIdentifier())) {
                filter.setParameter("user", (Object)user.getIdentifier());
            }
        } else {
            this.logger.warn("Search filter cannot be created, user input was empty or null");
        }
        return filter;
    }

    protected static class EscapingReferenceInsertionEventHandler
    implements ReferenceInsertionEventHandler {
        protected EscapingReferenceInsertionEventHandler() {
        }

        @Nullable
        public Object referenceInsert(Context context, String reference, Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Object[]) {
                ArrayList<Object> encodedValues = new ArrayList<Object>();
                for (Object o : (Object[])value) {
                    encodedValues.add(this.encode(o));
                }
                return encodedValues.toArray();
            }
            if (value instanceof Collection) {
                ArrayList<Object> encodedValues = new ArrayList<Object>();
                for (Object o : (Collection)value) {
                    encodedValues.add(this.encode(o));
                }
                return encodedValues;
            }
            return this.encode(value);
        }

        @Nullable
        private Object encode(@Nullable Object value) {
            if (value instanceof String) {
                return FilterTemplate.encodeValue((String)((String)value));
            }
            if (value instanceof byte[]) {
                return FilterTemplate.encodeValue((byte[])((byte[])value));
            }
            return value;
        }
    }
}

