/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.SubjectCanonicalizationFlowDescriptor;
import net.shibboleth.idp.authn.SubjectCanonicalizer;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;

public abstract class AbstractSubjectCanonicalizer
extends SubjectCanonicalizationFlowDescriptor
implements SubjectCanonicalizer {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractSubjectCanonicalizer.class);
    @NonnullAfterInit
    private String logPrefix;
    @Nonnull
    private List<Pair<Pattern, String>> transforms = CollectionSupport.emptyList();
    private boolean uppercase = false;
    private boolean lowercase = false;
    private boolean trim = false;

    public void setTransforms(@Nullable Collection<Pair<String, String>> newTransforms) {
        this.checkSetterPreconditions();
        if (newTransforms != null) {
            this.transforms = new ArrayList<Pair<Pattern, String>>();
            for (Pair<String, String> p : newTransforms) {
                Pattern pattern = Pattern.compile(StringSupport.trimOrNull((String)((String)p.getFirst())));
                this.transforms.add((Pair<Pattern, String>)new Pair((Object)pattern, (Object)((String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)((String)p.getSecond())), (String)"Replacement expression cannot be null"))));
            }
        } else {
            this.transforms = CollectionSupport.emptyList();
        }
    }

    public void setUppercase(boolean flag) {
        this.checkSetterPreconditions();
        this.uppercase = flag;
    }

    public void setLowercase(boolean flag) {
        this.checkSetterPreconditions();
        this.lowercase = flag;
    }

    public void setTrim(boolean flag) {
        this.checkSetterPreconditions();
        this.trim = flag;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.logPrefix = "SubjectCanonicalizer " + this.ensureId() + ":";
    }

    @Override
    @Nullable
    public String apply(@Nullable SubjectCanonicalizationContext c14nContext) {
        this.checkComponentActive();
        if (c14nContext == null) {
            return "InvalidSubjectCanonicalizationContext";
        }
        if (c14nContext.getSubject() == null) {
            this.log.error("{} No Subject found in context", (Object)this.getLogPrefix());
            return "InvalidSubjectCanonicalizationContext";
        }
        return this.doApply(c14nContext);
    }

    @Nullable
    protected abstract String doApply(@Nonnull SubjectCanonicalizationContext var1);

    @Nonnull
    @NotEmpty
    protected String applyTransforms(@Nonnull @NotEmpty String input) {
        String s = input;
        if (this.trim) {
            this.log.debug("{} trimming whitespace of input string '{}'", (Object)this.getLogPrefix(), (Object)s);
            s = s.trim();
        }
        if (this.lowercase) {
            this.log.debug("{} converting input string '{}' to lowercase", (Object)this.getLogPrefix(), (Object)s);
            s = s.toLowerCase();
        } else if (this.uppercase) {
            this.log.debug("{} converting input string '{}' to uppercase", (Object)this.getLogPrefix(), (Object)s);
            s = s.toUpperCase();
        }
        for (Pair<Pattern, String> p : this.transforms) {
            Pattern pattern = (Pattern)p.getFirst();
            if (pattern == null) continue;
            Matcher m = pattern.matcher(s);
            this.log.debug("{} applying replacement expression '{}' against input '{}'", new Object[]{this.getLogPrefix(), pattern.pattern(), s});
            s = m.replaceAll((String)p.getSecond());
            this.log.debug("{} result of replacement is '{}'", (Object)this.getLogPrefix(), (Object)s);
        }
        assert (s != null);
        return s;
    }

    @NonnullAfterInit
    protected String getLogPrefix() {
        return this.logPrefix;
    }
}

