/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.relyingparty.impl;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.profile.relyingparty.impl.BaseCriteriaRelyingPartyConfiigurationResolver;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.criterion.ProfileIDCriterion;
import org.opensaml.security.config.SecurityConfiguration;
import org.opensaml.xmlsec.DecryptionConfiguration;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.config.XMLSecurityConfiguration;

public class CriteriaDecryptionConfigurationResolver
extends BaseCriteriaRelyingPartyConfiigurationResolver<List<DecryptionConfiguration>> {
    @Nonnull
    public Iterable<List<DecryptionConfiguration>> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        this.checkComponentActive();
        List<DecryptionConfiguration> config = this.resolveSingle(criteria);
        if (config != null) {
            return CollectionSupport.singletonList(config);
        }
        return CollectionSupport.emptyList();
    }

    @Nullable
    public List<DecryptionConfiguration> resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        this.checkComponentActive();
        Pair<RelyingPartyConfiguration, ProfileRequestContext> rpcData = this.resolveRelyingPartyConfiguration(criteria);
        if (rpcData != null) {
            RelyingPartyConfiguration rpc = (RelyingPartyConfiguration)rpcData.getFirst();
            ProfileRequestContext prc = (ProfileRequestContext)rpcData.getSecond();
            assert (rpc != null && prc != null);
            return this.buildConfigList(rpc, prc, criteria);
        }
        return null;
    }

    @Nonnull
    private List<DecryptionConfiguration> buildConfigList(@Nonnull RelyingPartyConfiguration rpc, @Nonnull ProfileRequestContext prc, CriteriaSet criteria) {
        XMLSecurityConfiguration xsc;
        SecurityConfiguration defaultConfig;
        XMLSecurityConfiguration xsc2;
        SecurityConfiguration sc;
        ProfileConfiguration pc;
        ArrayList<DecryptionConfiguration> configs = new ArrayList<DecryptionConfiguration>();
        String profileID = null;
        ProfileIDCriterion profileIDCriterion = (ProfileIDCriterion)criteria.get(ProfileIDCriterion.class);
        if (profileIDCriterion != null) {
            profileID = profileIDCriterion.getProfileId();
        }
        if (profileID != null && (pc = rpc.getProfileConfiguration(prc, profileID)) != null && (sc = pc.getSecurityConfiguration(prc)) instanceof XMLSecurityConfiguration && (xsc2 = (XMLSecurityConfiguration)sc).getDecryptionConfiguration() != null) {
            configs.add(xsc2.getDecryptionConfiguration());
        }
        if ((defaultConfig = rpc.getSecurityConfiguration(prc)) instanceof XMLSecurityConfiguration && (xsc = (XMLSecurityConfiguration)defaultConfig).getDecryptionConfiguration() != null) {
            configs.add(xsc.getDecryptionConfiguration());
        }
        configs.add(SecurityConfigurationSupport.getGlobalDecryptionConfiguration());
        return configs;
    }
}

