/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.security.impl;

import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.primitive.TimerSupport;
import net.shibboleth.shared.resource.Resource;
import net.shibboleth.shared.security.DataSealerKeyStrategy;
import net.shibboleth.shared.security.KeyNotFoundException;
import org.slf4j.Logger;

public class BasicKeystoreKeyStrategy
extends AbstractInitializableComponent
implements DataSealerKeyStrategy {
    @Nonnull
    @NotEmpty
    public static final String CURRENT_VERSION_PROP = "CurrentVersion";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(BasicKeystoreKeyStrategy.class);
    @NonnullAfterInit
    private String keystoreType = "JCEKS";
    @NonnullAfterInit
    private Resource keystoreResource;
    @NonnullAfterInit
    private Resource keyVersionResource;
    @NonnullAfterInit
    private String keystorePassword;
    @NonnullAfterInit
    private String keyAlias;
    @NonnullAfterInit
    private String keyPassword;
    @NonnullAfterInit
    private String currentAlias;
    @NonnullAfterInit
    private SecretKey defaultKey;
    @Nonnull
    private Duration updateInterval = Duration.ofMinutes(15L);
    private Timer updateTaskTimer;
    private Timer internalTaskTimer;
    private TimerTask updateTask;

    public void setKeystoreType(@Nonnull @NotEmpty String type) {
        this.checkSetterPreconditions();
        this.keystoreType = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)type), (String)"Keystore type cannot be null or empty");
    }

    public void setKeystoreResource(@Nonnull @NotEmpty Resource resource) {
        this.checkSetterPreconditions();
        this.keystoreResource = (Resource)Constraint.isNotNull((Object)resource, (String)"Keystore resource cannot be null");
    }

    public void setKeyVersionResource(@Nonnull @NotEmpty Resource resource) {
        this.checkSetterPreconditions();
        this.keyVersionResource = (Resource)Constraint.isNotNull((Object)resource, (String)"Key version resource cannot be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeystorePassword(@Nullable String password) {
        BasicKeystoreKeyStrategy basicKeystoreKeyStrategy = this;
        synchronized (basicKeystoreKeyStrategy) {
            if (password != null && !password.isEmpty()) {
                this.keystorePassword = password;
                if (this.isInitialized() && this.keyPassword != null) {
                    try {
                        this.updateDefaultKey();
                    }
                    catch (KeyException keyException) {}
                }
            } else {
                this.keystorePassword = null;
            }
        }
    }

    public void setKeyAlias(@Nonnull @NotEmpty String alias) {
        this.checkSetterPreconditions();
        this.keyAlias = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)alias), (String)"Key alias base cannot be null or empty");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeyPassword(@Nullable String password) {
        BasicKeystoreKeyStrategy basicKeystoreKeyStrategy = this;
        synchronized (basicKeystoreKeyStrategy) {
            if (password != null && !password.isEmpty()) {
                this.keyPassword = password;
                if (this.isInitialized() && this.keystorePassword != null) {
                    try {
                        this.updateDefaultKey();
                    }
                    catch (KeyException keyException) {}
                }
            } else {
                this.keyPassword = null;
            }
        }
    }

    public void setUpdateInterval(@Nonnull Duration interval) {
        this.checkSetterPreconditions();
        Constraint.isNotNull((Object)interval, (String)"Interval cannot be null");
        Constraint.isFalse((boolean)interval.isNegative(), (String)"Interval cannot be negative");
        this.updateInterval = interval;
    }

    public void setUpdateTaskTimer(@Nullable Timer timer) {
        this.checkSetterPreconditions();
        this.updateTaskTimer = timer;
    }

    public void doInitialize() throws ComponentInitializationException {
        try {
            try {
                Constraint.isNotNull((Object)this.keystoreType, (String)"Keystore type cannot be null");
                Constraint.isNotNull((Object)this.keystoreResource, (String)"Keystore resource cannot be null");
                Constraint.isNotNull((Object)this.keyVersionResource, (String)"Key version resource cannot be null");
                Constraint.isNotNull((Object)this.keyAlias, (String)"Key alias base cannot be null");
            }
            catch (ConstraintViolationException e) {
                throw new ComponentInitializationException((Exception)((Object)e));
            }
            this.updateDefaultKey();
        }
        catch (KeyException e) {
            this.log.error("Error loading default key from base name '{}' {}", (Object)this.keyAlias, (Object)e.getMessage());
            throw new ComponentInitializationException("Exception loading the default key", (Exception)e);
        }
        if (!this.updateInterval.isZero()) {
            this.updateTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        BasicKeystoreKeyStrategy.this.updateDefaultKey();
                    }
                    catch (KeyException keyException) {
                        // empty catch block
                    }
                }
            };
            this.internalTaskTimer = this.updateTaskTimer == null ? new Timer(TimerSupport.getTimerName((Object)this), true) : this.updateTaskTimer;
            this.internalTaskTimer.schedule(this.updateTask, this.updateInterval.toMillis(), this.updateInterval.toMillis());
        }
    }

    protected void doDestroy() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
            this.updateTask = null;
            if (this.updateTaskTimer == null) {
                this.internalTaskTimer.cancel();
            }
            this.internalTaskTimer = null;
        }
        super.doDestroy();
    }

    @Override
    @Nonnull
    public Pair<String, SecretKey> getDefaultKey() throws KeyException {
        DataSealerKeyStrategy.NamedKey keyrec = this.getDefaultKeyRecord();
        return new Pair((Object)keyrec.name(), (Object)keyrec.key());
    }

    @Override
    @Nonnull
    public DataSealerKeyStrategy.NamedKey getDefaultKeyRecord() throws KeyException {
        this.checkComponentActive();
        BasicKeystoreKeyStrategy basicKeystoreKeyStrategy = this;
        synchronized (basicKeystoreKeyStrategy) {
            if (this.defaultKey != null) {
                return new DataSealerKeyStrategy.NamedKey(this.currentAlias, this.defaultKey);
            }
            throw new KeyException("Passwords not supplied, keystore is locked");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public SecretKey getKey(@Nonnull @NotEmpty String name) throws KeyException {
        SecretKey secretKey;
        block16: {
            BasicKeystoreKeyStrategy basicKeystoreKeyStrategy = this;
            synchronized (basicKeystoreKeyStrategy) {
                if (this.defaultKey != null && name.equals(this.currentAlias)) {
                    assert (this.defaultKey != null);
                    return this.defaultKey;
                }
                if (this.keystorePassword == null || this.keyPassword == null) {
                    throw new KeyException("Passwords not supplied, keystore is locked");
                }
            }
            KeyStore ks = KeyStore.getInstance(this.keystoreType);
            InputStream ksResourceStream = this.keystoreResource.getInputStream();
            try {
                ks.load(ksResourceStream, this.keystorePassword.toCharArray());
                Key loadedKey = ks.getKey(name, this.keyPassword.toCharArray());
                if (loadedKey == null) {
                    this.log.info("Key '{}' not found", (Object)name);
                    throw new KeyNotFoundException("Key was not present in keystore");
                }
                if (!(loadedKey instanceof SecretKey)) {
                    this.log.error("Key '{}' is not a symmetric key", (Object)name);
                    throw new KeyException("Key was of incorrect type");
                }
                secretKey = (SecretKey)loadedKey;
                if (ksResourceStream == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (ksResourceStream != null) {
                        try {
                            ksResourceStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                    this.log.error("Error loading key named '{}': {}", (Object)name, (Object)e.getMessage());
                    throw new KeyException(e);
                }
            }
            ksResourceStream.close();
        }
        return secretKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDefaultKey() throws KeyException {
        BasicKeystoreKeyStrategy basicKeystoreKeyStrategy = this;
        synchronized (basicKeystoreKeyStrategy) {
            if (this.keystorePassword == null || this.keyPassword == null) {
                this.log.info("Passwords not supplied, keystore left locked");
                return;
            }
            if (this.defaultKey == null) {
                try {
                    long lastModified = this.keyVersionResource.lastModified();
                    if (lastModified < Instant.now().minus(30L, ChronoUnit.DAYS).toEpochMilli()) {
                        this.log.warn("Keystore version resource unmodified in 30 days, consider rotating data sealer key");
                    }
                }
                catch (IOException e) {
                    this.log.debug("Unable to obtain keystore version resource modification time");
                }
            }
            try (InputStream is = this.keyVersionResource.getInputStream();){
                Properties props = new Properties();
                props.load(is);
                StringBuilder builder = new StringBuilder(this.keyAlias);
                builder.append(props.getProperty(CURRENT_VERSION_PROP, ""));
                String newAlias = builder.toString();
                if (this.currentAlias == null) {
                    this.log.info("Loading initial default key: {}", (Object)newAlias);
                } else if (!this.currentAlias.equals(newAlias)) {
                    this.log.info("Updating default key from {} to {}", (Object)this.currentAlias, (Object)newAlias);
                } else {
                    this.log.debug("Default key version has not changed, still {}", (Object)this.currentAlias);
                    return;
                }
                this.defaultKey = this.getKey(newAlias);
                this.currentAlias = newAlias;
                this.log.info("Default key updated to {}", (Object)this.currentAlias);
            }
            catch (IOException e) {
                this.log.error("IOException updating key version: {}", (Object)e.getMessage());
                throw new KeyException(e);
            }
        }
    }
}

