/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.saml.profile.config.navigate;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.navigate.AbstractRelyingPartyLookupFunction;
import net.shibboleth.saml.profile.config.SAMLAssertionProducingProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class AudienceRestrictionsLookupFunction
extends AbstractRelyingPartyLookupFunction<Collection<String>> {
    @Nullable
    @NotLive
    @Unmodifiable
    public Collection<String> apply(@Nullable ProfileRequestContext input) {
        RelyingPartyContext rpc = (RelyingPartyContext)this.getRelyingPartyContextLookupStrategy().apply(input);
        if (rpc != null) {
            SAMLAssertionProducingProfileConfiguration downcast;
            Set<String> additional;
            String id = rpc.getRelyingPartyId();
            ProfileConfiguration profileConfiguration = rpc.getProfileConfig();
            if (profileConfiguration instanceof SAMLAssertionProducingProfileConfiguration && !(additional = (downcast = (SAMLAssertionProducingProfileConfiguration)profileConfiguration).getAssertionAudiences(input)).isEmpty()) {
                ImmutableList.Builder builder = ImmutableList.builder();
                if (id != null) {
                    builder.add((Object)rpc.getRelyingPartyId());
                }
                builder.addAll(additional);
                return builder.build();
            }
            if (id != null) {
                return CollectionSupport.singletonList((Object)id);
            }
        }
        return CollectionSupport.emptyList();
    }
}

