/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.saml.profile.config.logic;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.logic.AbstractRelyingPartyPredicate;
import net.shibboleth.saml.profile.config.SAMLProfileConfiguration;
import net.shibboleth.saml.profile.context.navigate.SAMLMetadataContextLookupFunction;
import net.shibboleth.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;

public class SignRequestsPredicate
extends AbstractRelyingPartyPredicate {
    private boolean honorMetadata;
    @Nonnull
    private Function<ProfileRequestContext, SAMLMetadataContext> metadataContextLookupStrategy = new SAMLMetadataContextLookupFunction();

    public void setHonorMetadata(boolean flag) {
        this.honorMetadata = flag;
    }

    public void setMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLMetadataContext> strategy) {
        this.metadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLMetadataContext lookup strategy cannot be null");
    }

    public boolean test(@Nullable ProfileRequestContext input) {
        IDPSSODescriptor idp;
        Boolean flag;
        RoleDescriptor role;
        SAMLMetadataContext metadataCtx;
        ProfileConfiguration pc;
        boolean sso = false;
        RelyingPartyContext rpc = this.getRelyingPartyContext(input);
        if (rpc != null && (pc = rpc.getProfileConfig()) instanceof SAMLProfileConfiguration) {
            SAMLProfileConfiguration samlpc = (SAMLProfileConfiguration)pc;
            if (samlpc.isSignRequests(input)) {
                return true;
            }
            if (samlpc instanceof BrowserSSOProfileConfiguration) {
                sso = true;
            }
        }
        return this.honorMetadata && sso && (metadataCtx = this.metadataContextLookupStrategy.apply(input)) != null && (role = metadataCtx.getRoleDescriptor()) instanceof IDPSSODescriptor && (flag = (idp = (IDPSSODescriptor)role).getWantAuthnRequestsSigned()) != null && flag != false;
    }
}

