/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.velocity;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.util.ExtProperties;
import org.slf4j.Logger;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;

public class SpringResourceLoader
extends org.apache.velocity.runtime.resource.loader.ResourceLoader {
    @Nonnull
    @NotEmpty
    public static final String NAME = "spring";
    @Nonnull
    @NotEmpty
    public static final String SPRING_RESOURCE_LOADER_CLASS = "resource.loader.spring.class";
    @Nonnull
    @NotEmpty
    public static final String SPRING_RESOURCE_LOADER_CACHE = "resource.loader.spring.cache";
    @Nonnull
    @NotEmpty
    public static final String SPRING_RESOURCE_LOADER = "spring.resource.loader";
    @Nonnull
    @NotEmpty
    public static final String SPRING_RESOURCE_LOADER_PATH = "spring.resource.loader.path";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SpringResourceLoader.class);
    @Nullable
    private ResourceLoader resourceLoader;
    @Nonnull
    private String[] resourceLoaderPaths = new String[0];

    public void init(ExtProperties configuration) {
        this.resourceLoader = (ResourceLoader)this.rsvc.getApplicationAttribute((Object)SPRING_RESOURCE_LOADER);
        String resourceLoaderPath = (String)this.rsvc.getApplicationAttribute((Object)SPRING_RESOURCE_LOADER_PATH);
        if (this.resourceLoader == null) {
            throw new IllegalArgumentException("'resourceLoader' application attribute must be present for SpringResourceLoader");
        }
        if (resourceLoaderPath == null) {
            throw new IllegalArgumentException("'resourceLoaderPath' application attribute must be present for SpringResourceLoader");
        }
        this.resourceLoaderPaths = StringUtils.commaDelimitedListToStringArray((String)resourceLoaderPath);
        for (int i = 0; i < this.resourceLoaderPaths.length; ++i) {
            String path = this.resourceLoaderPaths[i];
            if (path.endsWith("/")) continue;
            this.resourceLoaderPaths[i] = path + "/";
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("SpringResourceLoader for Velocity: using resource loader {} and resource loader paths {}", (Object)this.resourceLoader, Arrays.asList(this.resourceLoaderPaths));
        }
    }

    public Reader getResourceReader(String source, String encoding) throws ResourceNotFoundException {
        this.log.debug("Looking for Velocity resource with name '{}'", (Object)source);
        for (String resourceLoaderPath : this.resourceLoaderPaths) {
            org.springframework.core.io.Resource resource = this.resourceLoader != null ? this.resourceLoader.getResource(resourceLoaderPath + source) : null;
            try {
                if (resource == null) continue;
                return new InputStreamReader(resource.getInputStream(), encoding);
            }
            catch (IOException ex) {
                this.log.debug("Could not find Velocity resource: {}", (Object)resource);
            }
        }
        throw new ResourceNotFoundException("Could not find resource [" + source + "] in Spring resource loader path");
    }

    public boolean isSourceModified(Resource resource) {
        return false;
    }

    public long getLastModified(Resource resource) {
        return 0L;
    }
}

