/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import com.google.common.base.MoreObjects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.FlowDescriptor;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class SubjectCanonicalizationFlowDescriptor
extends AbstractIdentifiableInitializableComponent
implements FlowDescriptor,
Predicate<ProfileRequestContext> {
    @Nonnull
    private Predicate<ProfileRequestContext> activationCondition = PredicateSupport.alwaysTrue();

    public void setActivationCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.checkSetterPreconditions();
        this.activationCondition = (Predicate)Constraint.isNotNull(condition, (String)"Activation condition predicate cannot be null");
    }

    @Override
    public boolean test(ProfileRequestContext input) {
        return this.activationCondition.test(input);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof SubjectCanonicalizationFlowDescriptor) {
            return this.getId().equals(((SubjectCanonicalizationFlowDescriptor)obj).getId());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("flowId", (Object)this.getId()).toString();
    }
}

