/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.security.Principal;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.principal.PrincipalServiceManager;
import net.shibboleth.idp.authn.principal.PrincipalSupportingComponent;
import net.shibboleth.idp.profile.FlowDescriptor;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageSerializer;
import org.springframework.core.Ordered;

public class AuthenticationFlowDescriptor
extends AbstractIdentifiableInitializableComponent
implements FlowDescriptor,
PrincipalSupportingComponent,
Predicate<ProfileRequestContext>,
StorageSerializer<AuthenticationResult>,
Ordered {
    @Nonnull
    @NotEmpty
    public static final String FLOW_ID_PREFIX = "authn/";
    @Nonnull
    public static final Duration STORAGE_EXPIRATION_OFFSET;
    private int order = Integer.MAX_VALUE;
    private boolean supportsNonBrowser = true;
    private boolean supportsPassive;
    private boolean supportsForced;
    private boolean proxyRestrictionsEnforced = true;
    private boolean proxyScopingEnforced;
    private boolean discoveryRequired;
    @Nonnull
    private Predicate<ProfileRequestContext> reuseCondition = new ProxyCountPredicate();
    @Nullable
    private BiPredicate<ProfileRequestContext, AuthenticationResult> revocationCondition;
    @Nullable
    private Duration lifetime;
    @Nonnull
    private Duration inactivityTimeout;
    @Nonnull
    private Set<String> stringBasedPrincipals;
    @Nonnull
    private Subject supportedPrincipals = new Subject();
    @Nonnull
    private Predicate<ProfileRequestContext> activationCondition = PredicateSupport.alwaysTrue();
    @Nullable
    private StorageSerializer<AuthenticationResult> resultSerializer;
    @Nonnull
    private Map<Principal, Integer> principalWeightMap;
    @Nullable
    private PrincipalServiceManager principalServiceManager;
    @Nullable
    private BiConsumer<ProfileRequestContext, Subject> subjectDecorator;

    public AuthenticationFlowDescriptor() {
        Duration thirtyMins = Duration.ofMinutes(30L);
        assert (thirtyMins != null);
        this.inactivityTimeout = thirtyMins;
        this.principalWeightMap = CollectionSupport.emptyMap();
        this.stringBasedPrincipals = CollectionSupport.emptySet();
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int priority) {
        this.order = priority;
    }

    public boolean isNonBrowserSupported() {
        return this.supportsNonBrowser;
    }

    public void setNonBrowserSupported(boolean isSupported) {
        this.checkSetterPreconditions();
        this.supportsNonBrowser = isSupported;
    }

    public boolean isPassiveAuthenticationSupported() {
        return this.supportsPassive;
    }

    public void setPassiveAuthenticationSupported(boolean isSupported) {
        this.checkSetterPreconditions();
        this.supportsPassive = isSupported;
    }

    public boolean isForcedAuthenticationSupported() {
        return this.supportsForced;
    }

    public void setForcedAuthenticationSupported(boolean isSupported) {
        this.checkSetterPreconditions();
        this.supportsForced = isSupported;
    }

    public boolean isProxyRestrictionsEnforced() {
        return this.proxyRestrictionsEnforced;
    }

    public void setProxyRestrictionsEnforced(boolean flag) {
        this.proxyRestrictionsEnforced = flag;
    }

    public boolean isProxyScopingEnforced() {
        return this.proxyScopingEnforced;
    }

    public void setProxyScopingEnforced(boolean flag) {
        this.proxyScopingEnforced = flag;
    }

    public boolean isDiscoveryRequired() {
        return this.discoveryRequired;
    }

    public void setDiscoveryRequired(boolean flag) {
        this.discoveryRequired = flag;
    }

    @Nonnull
    public Predicate<ProfileRequestContext> getReuseCondition() {
        return this.reuseCondition;
    }

    public void setReuseCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.checkSetterPreconditions();
        this.reuseCondition = PredicateSupport.and((Predicate)new ProxyCountPredicate(), (Predicate)((Predicate)Constraint.isNotNull(condition, (String)"Predicate cannot be null")));
    }

    @Nullable
    public BiPredicate<ProfileRequestContext, AuthenticationResult> getRevocationCondition() {
        return this.revocationCondition;
    }

    public void setRevocationCondition(@Nullable BiPredicate<ProfileRequestContext, AuthenticationResult> condition) {
        this.checkSetterPreconditions();
        this.revocationCondition = condition;
    }

    @Nullable
    public BiConsumer<ProfileRequestContext, Subject> getSubjectDecorator() {
        return this.subjectDecorator;
    }

    public void setSubjectDecorator(@Nullable BiConsumer<ProfileRequestContext, Subject> decorator) {
        this.checkSetterPreconditions();
        this.subjectDecorator = decorator;
    }

    @Nullable
    public Duration getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(@Nullable Duration flowLifetime) {
        this.checkSetterPreconditions();
        Constraint.isFalse((flowLifetime != null && (flowLifetime.isNegative() || flowLifetime.isZero()) ? 1 : 0) != 0, (String)"Lifetime must be null or greater than 0");
        this.lifetime = flowLifetime;
    }

    @Nonnull
    public Duration getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    public void setInactivityTimeout(@Nonnull Duration timeout) {
        this.checkSetterPreconditions();
        Constraint.isNotNull((Object)timeout, (String)"Inactivity timeout cannot be null");
        Constraint.isFalse((timeout.isNegative() || timeout.isZero() ? 1 : 0) != 0, (String)"Inactivity timeout must be greater than 0");
        this.inactivityTimeout = timeout;
    }

    public boolean isResultActive(@Nonnull AuthenticationResult result) {
        Constraint.isNotNull((Object)result, (String)"AuthenticationResult cannot be null");
        Constraint.isTrue((boolean)result.getAuthenticationFlowId().equals(this.getId()), (String)"AuthenticationResult was not produced by this flow");
        Instant now = Instant.now();
        if (this.getLifetime() != null && now.isAfter(result.getAuthenticationInstant().plus(this.getLifetime()))) {
            return false;
        }
        return !now.isAfter(result.getLastActivityInstant().plus(this.getInactivityTimeout()));
    }

    @Override
    @Nonnull
    @Unmodifiable
    public <T extends Principal> Set<T> getSupportedPrincipals(@Nonnull Class<T> c) {
        Set<T> result = this.supportedPrincipals.getPrincipals(c);
        assert (result != null);
        return result;
    }

    @Nonnull
    public Collection<Principal> getSupportedPrincipals() {
        Set<Principal> result = this.supportedPrincipals.getPrincipals();
        assert (result != null);
        return result;
    }

    public void setSupportedPrincipals(@Nonnull Collection<Principal> principals) {
        this.checkSetterPreconditions();
        Constraint.isNotNull(principals, (String)"Principal collection cannot be null.");
        this.supportedPrincipals.getPrincipals().clear();
        this.supportedPrincipals.getPrincipals().addAll(Set.copyOf(principals));
    }

    public void setSupportedPrincipalsByString(@Nonnull Collection<String> principals) {
        this.checkSetterPreconditions();
        this.stringBasedPrincipals = CollectionSupport.copyToSet((Collection)StringSupport.normalizeStringCollection(principals));
    }

    public void setActivationCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.activationCondition = (Predicate)Constraint.isNotNull(condition, (String)"Activation condition predicate cannot be null");
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext input) {
        return this.activationCondition.test(input);
    }

    public void setResultSerializer(@Nonnull StorageSerializer<AuthenticationResult> serializer) {
        this.checkSetterPreconditions();
        this.resultSerializer = (StorageSerializer)Constraint.isNotNull(serializer, (String)"StorageSerializer cannot be null");
    }

    public void setPrincipalWeightMap(@Nullable Map<Principal, Integer> map) {
        this.checkSetterPreconditions();
        this.principalWeightMap = map != null ? CollectionSupport.copyToMap(map) : CollectionSupport.emptyMap();
    }

    public void setPrincipalServiceManager(@Nullable PrincipalServiceManager manager) {
        this.checkSetterPreconditions();
        this.principalServiceManager = manager;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.resultSerializer == null) {
            throw new ComponentInitializationException("AuthenticationResult serializer cannot be null");
        }
        if (!this.stringBasedPrincipals.isEmpty()) {
            if (this.principalServiceManager == null) {
                throw new ComponentInitializationException("PrincipalServiceManager cannot be null");
            }
            this.supportedPrincipals.getPrincipals().clear();
            this.stringBasedPrincipals.forEach(v -> {
                assert (this.principalServiceManager != null && v != null);
                Principal p = this.principalServiceManager.principalFromString((String)v);
                if (p != null) {
                    this.supportedPrincipals.getPrincipals().add(p);
                }
            });
        }
    }

    @Nonnull
    public AuthenticationResult newAuthenticationResult(@Nonnull Subject subject) {
        AuthenticationResult result = new AuthenticationResult(this.ensureId(), subject);
        if (this.proxyRestrictionsEnforced) {
            result.setReuseCondition(PredicateSupport.and(this.reuseCondition, (Predicate)new AuthenticationResult.ProxyRestrictionReusePredicate(result)));
        } else {
            result.setReuseCondition(this.reuseCondition);
        }
        result.setRevocationCondition(this.revocationCondition);
        return result;
    }

    @Nonnull
    @NotEmpty
    public String serialize(@Nonnull AuthenticationResult instance) throws IOException {
        this.checkComponentActive();
        assert (this.resultSerializer != null);
        return this.resultSerializer.serialize((Object)instance);
    }

    @Nonnull
    public AuthenticationResult deserialize(long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable Long expiration) throws IOException {
        this.checkComponentActive();
        assert (this.resultSerializer != null);
        AuthenticationResult result = (AuthenticationResult)this.resultSerializer.deserialize(version, context, key, value, expiration != null ? Long.valueOf(expiration - this.inactivityTimeout.toMillis() - STORAGE_EXPIRATION_OFFSET.toMillis()) : null);
        if (this.proxyRestrictionsEnforced) {
            result.setReuseCondition(PredicateSupport.and(this.reuseCondition, (Predicate)new AuthenticationResult.ProxyRestrictionReusePredicate(result)));
        } else {
            result.setReuseCondition(this.reuseCondition);
        }
        result.setRevocationCondition(this.revocationCondition);
        return result;
    }

    @Nullable
    public <T extends Principal> T getHighestWeighted(@Nonnull Collection<T> principals) {
        if (principals.isEmpty()) {
            return null;
        }
        if (this.principalWeightMap.isEmpty() || principals.size() == 1) {
            return (T)((Principal)principals.iterator().next());
        }
        Object[] principalArray = principals.toArray();
        Arrays.sort(principalArray, new WeightedComparator());
        return (T)((Principal)principalArray[principalArray.length - 1]);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof AuthenticationFlowDescriptor) {
            return this.getId().equals(((AuthenticationFlowDescriptor)obj).getId());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("flowId", (Object)this.getId()).add("supportsPassive", this.supportsPassive).add("supportsForcedAuthentication", this.supportsForced).add("lifetime", (Object)this.lifetime).add("inactivityTimeout", (Object)this.inactivityTimeout).toString();
    }

    static {
        Duration tenMinutes = Duration.ofMinutes(10L);
        assert (tenMinutes != null);
        STORAGE_EXPIRATION_OFFSET = tenMinutes;
    }

    private class ProxyCountPredicate
    implements Predicate<ProfileRequestContext> {
        private ProxyCountPredicate() {
        }

        @Override
        public boolean test(@Nullable ProfileRequestContext input) {
            AuthenticationContext authnCtx;
            return !AuthenticationFlowDescriptor.this.proxyScopingEnforced || input == null || (authnCtx = (AuthenticationContext)input.getSubcontext(AuthenticationContext.class)) == null || authnCtx.getProxyCount() == null || authnCtx.getProxyCount() != 0;
        }
    }

    private class WeightedComparator<T>
    implements Comparator<T> {
        private WeightedComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            int weight2;
            int weight1 = AuthenticationFlowDescriptor.this.principalWeightMap.containsKey(o1) ? AuthenticationFlowDescriptor.this.principalWeightMap.get(o1) : 0;
            int n = weight2 = AuthenticationFlowDescriptor.this.principalWeightMap.containsKey(o2) ? AuthenticationFlowDescriptor.this.principalWeightMap.get(o2) : 0;
            if (weight1 < weight2) {
                return -1;
            }
            if (weight1 > weight2) {
                return 1;
            }
            return 0;
        }
    }
}

