/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import net.shibboleth.idp.authn.AbstractCredentialValidator;
import net.shibboleth.idp.authn.CredentialValidator;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.idp.authn.principal.PasswordPrincipal;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public abstract class AbstractUsernamePasswordCredentialValidator
extends AbstractCredentialValidator {
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_METRIC_NAME = "net.shibboleth.idp.authn.password";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractUsernamePasswordCredentialValidator.class);
    @Nonnull
    private Function<AuthenticationContext, UsernamePasswordContext> usernamePasswordContextLookupStrategy = new ChildContextLookup(UsernamePasswordContext.class);
    private boolean savePasswordToCredentialSet;
    @Nullable
    private Pattern matchExpression;
    @Nonnull
    private List<Pair<Pattern, String>> transforms = CollectionSupport.emptyList();
    private boolean uppercase = false;
    private boolean lowercase = false;
    private boolean trim = false;

    public void setUsernamePasswordContextLookupStrategy(@Nonnull Function<AuthenticationContext, UsernamePasswordContext> strategy) {
        this.checkSetterPreconditions();
        this.usernamePasswordContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"UsernamePasswordContextLookupStrategy cannot be null");
    }

    public boolean savePasswordToCredentialSet() {
        return this.savePasswordToCredentialSet;
    }

    public void setSavePasswordToCredentialSet(boolean flag) {
        this.checkSetterPreconditions();
        this.savePasswordToCredentialSet = flag;
    }

    public void setMatchExpression(@Nullable Pattern expression) {
        this.checkSetterPreconditions();
        this.matchExpression = expression != null && !expression.pattern().isEmpty() ? expression : null;
    }

    public void setTransforms(@Nullable Collection<Pair<String, String>> newTransforms) {
        this.checkSetterPreconditions();
        if (newTransforms != null) {
            this.transforms = new ArrayList<Pair<Pattern, String>>();
            for (Pair<String, String> p : newTransforms) {
                Pattern pattern = Pattern.compile(StringSupport.trimOrNull((String)((String)p.getFirst())));
                this.transforms.add((Pair<Pattern, String>)new Pair((Object)pattern, (Object)((String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)((String)p.getSecond())), (String)"Replacement expression cannot be null"))));
            }
        } else {
            this.transforms = CollectionSupport.emptyList();
        }
    }

    public void setUppercase(boolean flag) {
        this.checkSetterPreconditions();
        this.uppercase = flag;
    }

    public void setLowercase(boolean flag) {
        this.checkSetterPreconditions();
        this.lowercase = flag;
    }

    public void setTrim(boolean flag) {
        this.checkSetterPreconditions();
        this.trim = flag;
    }

    @Override
    protected Subject doValidate(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nullable CredentialValidator.WarningHandler warningHandler, @Nullable CredentialValidator.ErrorHandler errorHandler) throws Exception {
        this.checkComponentActive();
        UsernamePasswordContext upContext = this.usernamePasswordContextLookupStrategy.apply(authenticationContext);
        if (upContext == null) {
            this.log.debug("{} No UsernamePasswordContext available", (Object)this.getLogPrefix());
            if (errorHandler != null) {
                errorHandler.handleError(profileRequestContext, authenticationContext, "NoCredentials", "NoCredentials");
            }
            throw new LoginException("NoCredentials");
        }
        String username = upContext.getUsername();
        if (username == null) {
            this.log.info("{} No username available within UsernamePasswordContext", (Object)this.getLogPrefix());
            if (errorHandler != null) {
                errorHandler.handleError(profileRequestContext, authenticationContext, "NoCredentials", "NoCredentials");
            }
            throw new LoginException("NoCredentials");
        }
        if (upContext.getPassword() == null) {
            this.log.info("{} No password available within UsernamePasswordContext", (Object)this.getLogPrefix());
            if (errorHandler != null) {
                errorHandler.handleError(profileRequestContext, authenticationContext, "InvalidCredentials", "InvalidCredentials");
            }
            throw new LoginException("InvalidCredentials");
        }
        upContext.setTransformedUsername(this.applyTransforms(username));
        if (this.matchExpression != null && !this.matchExpression.matcher(upContext.getTransformedUsername()).matches()) {
            this.log.debug("{} Username '{}' did not match expression", (Object)this.getLogPrefix(), (Object)upContext.getTransformedUsername());
            return null;
        }
        return this.doValidate(profileRequestContext, authenticationContext, upContext, warningHandler, errorHandler);
    }

    @Nullable
    protected abstract Subject doValidate(@Nonnull ProfileRequestContext var1, @Nonnull AuthenticationContext var2, @Nonnull UsernamePasswordContext var3, @Nullable CredentialValidator.WarningHandler var4, @Nullable CredentialValidator.ErrorHandler var5) throws Exception;

    @Nonnull
    protected Subject populateSubject(@Nonnull Subject subject, @Nonnull UsernamePasswordContext usernamePasswordContext) {
        String u = usernamePasswordContext.getTransformedUsername();
        assert (u != null);
        subject.getPrincipals().add(new UsernamePrincipal(u));
        if (this.savePasswordToCredentialSet) {
            String p = usernamePasswordContext.getPassword();
            assert (p != null);
            subject.getPrivateCredentials().add(new PasswordPrincipal(p));
        }
        return super.populateSubject(subject);
    }

    @Nonnull
    @NotEmpty
    protected String applyTransforms(@Nonnull @NotEmpty String input) {
        String s = input;
        if (this.trim) {
            this.log.trace("{} Trimming whitespace of input string '{}'", (Object)this.getLogPrefix(), (Object)s);
            s = s.trim();
        }
        if (this.lowercase) {
            this.log.trace("{} Converting input string '{}' to lowercase", (Object)this.getLogPrefix(), (Object)s);
            s = s.toLowerCase();
        } else if (this.uppercase) {
            this.log.trace("{} Converting input string '{}' to uppercase", (Object)this.getLogPrefix(), (Object)s);
            s = s.toUpperCase();
        }
        if (this.transforms.isEmpty()) {
            assert (s != null);
            return s;
        }
        for (Pair<Pattern, String> p : this.transforms) {
            Pattern pattern = (Pattern)p.getFirst();
            if (pattern == null) continue;
            Matcher m = pattern.matcher(s);
            this.log.trace("{} Applying replacement expression '{}' against input '{}'", new Object[]{this.getLogPrefix(), pattern.pattern(), s});
            s = m.replaceAll((String)p.getSecond());
            this.log.trace("{} Result of replacement is '{}'", (Object)this.getLogPrefix(), (Object)s);
        }
        assert (s != null);
        return s;
    }
}

