/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractAuthenticationAction
extends AbstractProfileAction {
    @Nonnull
    private Function<ProfileRequestContext, AuthenticationContext> authnCtxLookupStrategy = new ChildContextLookup(AuthenticationContext.class);
    @NonnullBeforeExec
    private AuthenticationContext authnContext;

    public void setAuthenticationContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AuthenticationContext> strategy) {
        this.checkSetterPreconditions();
        this.authnCtxLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Strategy cannot be null");
    }

    @Nonnull
    private AuthenticationContext getAuthenticationContext() {
        assert (this.isPreExecuteCalled());
        return this.authnContext;
    }

    protected final boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (super.doPreExecute(profileRequestContext)) {
            this.authnContext = this.authnCtxLookupStrategy.apply(profileRequestContext);
            AuthenticationContext ac = this.authnContext;
            if (ac == null) {
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
                return false;
            }
            return this.doPreExecute(profileRequestContext, ac);
        }
        return false;
    }

    protected final void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.doExecute(profileRequestContext, this.getAuthenticationContext());
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
    }
}

