/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.spring.trust;

import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.security.x509.X509Support;
import org.opensaml.spring.trust.AbstractBasicPKIXValidationInfoFactoryBean;
import org.slf4j.Logger;
import org.springframework.beans.FatalBeanException;

public class PKIXInlineValidationInfoFactoryBean
extends AbstractBasicPKIXValidationInfoFactoryBean {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(PKIXInlineValidationInfoFactoryBean.class);
    @Nullable
    private List<String> certificateFiles;
    @Nullable
    private List<String> crlStrings;

    public void setCertificates(@Nullable List<String> certs) {
        this.certificateFiles = certs;
    }

    public void setCRLs(@Nullable List<String> crls) {
        this.crlStrings = crls;
    }

    @Override
    @Nullable
    protected List<X509Certificate> getCertificates() {
        if (null == this.certificateFiles) {
            return null;
        }
        assert (this.certificateFiles != null);
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>(this.certificateFiles.size());
        assert (this.certificateFiles != null);
        for (String cert : this.certificateFiles) {
            try {
                certificates.add(X509Support.decodeCertificate((String)cert.trim()));
            }
            catch (CertificateException e) {
                this.log.error("{}: Could not decode provided Certificate: {}", (Object)this.getConfigDescription(), (Object)e.getMessage());
                throw new FatalBeanException("Could not decode provided Certificate", (Throwable)e);
            }
        }
        return certificates;
    }

    @Override
    @Nullable
    protected List<X509CRL> getCRLs() {
        if (null == this.crlStrings) {
            return null;
        }
        assert (this.crlStrings != null);
        ArrayList<X509CRL> crls = new ArrayList<X509CRL>(this.crlStrings.size());
        assert (this.crlStrings != null);
        for (String crl : this.crlStrings) {
            try {
                assert (crl != null);
                crls.add(X509Support.decodeCRL((String)crl));
            }
            catch (CRLException | CertificateException e) {
                this.log.error("{}: Could not decode provided CRL: {}", (Object)this.getConfigDescription(), (Object)e.getMessage());
                throw new FatalBeanException("Could not decode provided CRL", (Throwable)e);
            }
        }
        return crls;
    }
}

