/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.spring.credential;

import java.io.UnsupportedEncodingException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.spring.credential.AbstractCredentialFactoryBean;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanCreationException;

public abstract class AbstractBasicCredentialFactoryBean
extends AbstractCredentialFactoryBean<BasicCredential> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractBasicCredentialFactoryBean.class);
    @Nullable
    private String secretKeyAlgorithm;
    @Nullable
    private SecretKeyEncoding secretKeyEncoding = SecretKeyEncoding.base64;

    @Nonnull
    protected byte[] decodeSecretKey(String data) {
        Constraint.isNotNull((Object)data, (String)"SecretKey data was null");
        switch (this.getSecretKeyEncoding()) {
            case binary: {
                try {
                    return data.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new UnsupportedOperationException(e);
                }
            }
            case hex: {
                return Hex.decode((String)data);
            }
            case base64: {
                return Base64.decodeBase64((String)data);
            }
        }
        throw new IllegalArgumentException("Saw unsupported encoding: " + String.valueOf((Object)this.getSecretKeyEncoding()));
    }

    @Nonnull
    protected byte[] decodeSecretKey(byte[] data) {
        Constraint.isNotNull((Object)data, (String)"SecretKey data was null");
        switch (this.getSecretKeyEncoding()) {
            case binary: {
                return data;
            }
            case hex: {
                return Hex.decode((byte[])data);
            }
            case base64: {
                return Base64.decodeBase64((byte[])data);
            }
        }
        throw new IllegalArgumentException("Saw unsupported encoding: " + String.valueOf((Object)this.getSecretKeyEncoding()));
    }

    @Nonnull
    protected BasicCredential doCreateInstance() throws Exception {
        BasicCredential credential;
        PrivateKey privateKey = this.getPrivateKey();
        PublicKey publicKey = this.getPublicKey();
        SecretKey secretKey = this.getSecretKey();
        if (null != publicKey) {
            if (null == privateKey) {
                credential = new BasicCredential(publicKey);
            } else {
                if (!KeySupport.matchKeyPair((PublicKey)publicKey, (PrivateKey)privateKey)) {
                    this.log.error("{}: Public and private keys do not match", (Object)this.getConfigDescription());
                    throw new BeanCreationException("Public and private keys do not match");
                }
                credential = new BasicCredential(publicKey, privateKey);
            }
        } else if (null != secretKey) {
            credential = new BasicCredential(secretKey);
        } else {
            throw new BeanCreationException("Neither public key nor secret key specified");
        }
        if (null != this.getUsageType()) {
            credential.setUsageType(UsageType.valueOf((String)this.getUsageType()));
        }
        return credential;
    }

    public Class<?> getObjectType() {
        return BasicCredential.class;
    }

    @Nullable
    public String getSecretKeyAlgorithm() {
        return this.secretKeyAlgorithm;
    }

    public void setSecretKeyAlgorithm(@Nonnull String algorithm) {
        this.secretKeyAlgorithm = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)algorithm), (String)"SecretKey algorithm may not be null");
    }

    public SecretKeyEncoding getSecretKeyEncoding() {
        return this.secretKeyEncoding;
    }

    public void setSecretKeyEncoding(@Nonnull SecretKeyEncoding encoding) {
        this.secretKeyEncoding = (SecretKeyEncoding)((Object)Constraint.isNotNull((Object)((Object)encoding), (String)"SecretKey encoding may not be null"));
    }

    @Nullable
    protected abstract PublicKey getPublicKey();

    @Nullable
    protected abstract PrivateKey getPrivateKey();

    @Nullable
    protected abstract SecretKey getSecretKey();

    public static enum SecretKeyEncoding {
        binary,
        hex,
        base64;

    }
}

