/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.session.SessionManager;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class UpdateSessionWithAuthenticationResult
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(UpdateSessionWithAuthenticationResult.class);
    @NonnullAfterInit
    private SessionManager sessionManager;
    @Nonnull
    private Function<ProfileRequestContext, SessionContext> sessionContextCreationStrategy = new ChildContextLookup(SessionContext.class, true);
    @Nonnull
    private Function<ProfileRequestContext, SubjectContext> subjectContextLookupStrategy = new ChildContextLookup(SubjectContext.class);
    @NonnullBeforeExec
    private SessionContext sessionCtx;
    @NonnullBeforeExec
    private SubjectContext subjectCtx;

    public void setSessionManager(@Nonnull SessionManager manager) {
        this.checkSetterPreconditions();
        this.sessionManager = (SessionManager)Constraint.isNotNull((Object)manager, (String)"SessionManager cannot be null");
    }

    public void setSessionContextCreationStrategy(@Nonnull Function<ProfileRequestContext, SessionContext> strategy) {
        this.checkSetterPreconditions();
        this.sessionContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"SessionContext lookup/creation strategy cannot be null");
    }

    public void setSubjectContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SubjectContext> strategy) {
        this.checkSetterPreconditions();
        this.subjectContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SubjectContext lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (!PredicateSupport.isAlwaysFalse((Predicate)this.getActivationCondition()) && this.sessionManager == null) {
            throw new ComponentInitializationException("SessionManager cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (super.doPreExecute(profileRequestContext, authenticationContext) && authenticationContext.getAuthenticationResult() != null) {
            this.subjectCtx = this.subjectContextLookupStrategy.apply(profileRequestContext);
            this.sessionCtx = this.sessionContextCreationStrategy.apply(profileRequestContext);
            if (this.sessionCtx == null) {
                this.log.error("{} SessionContext creation failed", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
                return false;
            }
            return this.sessionCtx.getIdPSession() != null || this.subjectCtx != null && this.subjectCtx.getPrincipalName() != null;
        }
        return false;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        IdPSession session = this.sessionCtx.getIdPSession();
        if (session != null) {
            try {
                this.updateIdPSession(authenticationContext, session);
            }
            catch (SessionException e) {
                this.log.error("{} Error updating session {}", new Object[]{this.getLogPrefix(), session.getId(), e});
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            }
        } else {
            try {
                this.createIdPSession(authenticationContext);
            }
            catch (SessionException e) {
                String principalName = this.subjectCtx.getPrincipalName();
                this.log.error("{} Error creating session for principal {}", new Object[]{this.getLogPrefix(), principalName, e});
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            }
        }
    }

    private void updateIdPSession(@Nonnull AuthenticationContext authenticationContext, @Nonnull IdPSession session) throws SessionException {
        AuthenticationResult ar = authenticationContext.getAuthenticationResult();
        assert (ar != null);
        if (authenticationContext.getAttemptedFlow() != null) {
            if (authenticationContext.isResultCacheable()) {
                this.log.debug("{} Adding new AuthenticationResult for flow {} to existing session {}", new Object[]{this.getLogPrefix(), ar.getAuthenticationFlowId(), session.getId()});
                session.addAuthenticationResult(ar);
            }
        } else {
            this.log.debug("{} Updating activity time on reused AuthenticationResult for flow {} in existing session {}", new Object[]{this.getLogPrefix(), ar.getAuthenticationFlowId(), session.getId()});
            session.updateAuthenticationResultActivity(ar);
        }
    }

    private void createIdPSession(@Nonnull AuthenticationContext authenticationContext) throws SessionException {
        SubjectContext sbc = this.subjectCtx;
        assert (sbc != null && this.isPreExecuteCalled());
        String principalName = sbc.getPrincipalName();
        assert (principalName != null);
        this.log.debug("{} Creating new session for principal {}", (Object)this.getLogPrefix(), (Object)principalName);
        this.sessionCtx.setIdPSession(this.sessionManager.createSession(principalName));
        if (authenticationContext.isResultCacheable()) {
            AuthenticationResult ar = authenticationContext.getAuthenticationResult();
            assert (ar != null);
            IdPSession idPSession = this.sessionCtx.getIdPSession();
            assert (idPSession != null);
            idPSession.addAuthenticationResult(ar);
        }
    }
}

