/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.SPSessionSerializerRegistry;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.session.SessionManager;
import net.shibboleth.idp.session.SessionResolver;
import net.shibboleth.idp.session.criterion.HttpServletRequestCriterion;
import net.shibboleth.idp.session.criterion.SPSessionCriterion;
import net.shibboleth.idp.session.criterion.SessionIdCriterion;
import net.shibboleth.idp.session.impl.StorageBackedIdPSession;
import net.shibboleth.idp.session.impl.StorageBackedIdPSessionSerializer;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.net.CookieManager;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import net.shibboleth.shared.servlet.HttpServletSupport;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageSerializer;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.VersionMismatchException;
import org.slf4j.Logger;

public class StorageBackedSessionManager
extends AbstractIdentifiableInitializableComponent
implements SessionManager,
SessionResolver {
    @Nonnull
    @NotEmpty
    public static final String SESSION_PRIMARY_KEY = "_session";
    @Nonnull
    @NotEmpty
    protected static final String DEFAULT_COOKIE_NAME = "shib_idp_session";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StorageBackedSessionManager.class);
    @NonnullAfterInit
    private NonnullSupplier<HttpServletRequest> httpRequestSupplier;
    @Nonnull
    private Duration sessionTimeout;
    @Nonnull
    private Duration sessionSlop;
    private boolean maskStorageFailure;
    private boolean trackSPSessions;
    private boolean secondaryServiceIndex;
    @Nonnull
    private BiPredicate<String, String> consistentAddressCondition;
    @NonnullAfterInit
    private CookieManager cookieManager;
    @Nonnull
    @NotEmpty
    private String cookieName;
    @NonnullAfterInit
    private StorageService storageService;
    private long storageServiceThreshold;
    @NonnullAfterInit
    private IdentifierGenerationStrategy idGenerator;
    @Nonnull
    private final StorageBackedIdPSessionSerializer serializer;
    @Nonnull
    private final Map<String, AuthenticationFlowDescriptor> flowDescriptorMap;
    @Nullable
    private SPSessionSerializerRegistry spSessionSerializerRegistry;

    public StorageBackedSessionManager() {
        Duration oneHour = Duration.ofHours(1L);
        Duration zeroDuration = Duration.ZERO;
        assert (oneHour != null && zeroDuration != null);
        this.sessionTimeout = oneHour;
        this.sessionSlop = zeroDuration;
        this.serializer = new StorageBackedIdPSessionSerializer(this, null);
        this.flowDescriptorMap = new HashMap<String, AuthenticationFlowDescriptor>();
        this.consistentAddressCondition = DefaultConsistentAddressConditionFactory.getDefaultConsistentAddressCondition(true);
        this.cookieName = DEFAULT_COOKIE_NAME;
        this.storageServiceThreshold = 0x100000L;
    }

    public void setHttpServletRequestSupplier(@Nullable NonnullSupplier<HttpServletRequest> requestSupplier) {
        this.checkSetterPreconditions();
        this.httpRequestSupplier = requestSupplier;
    }

    @Nonnull
    public Duration getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(@Nonnull Duration timeout) {
        this.checkSetterPreconditions();
        this.sessionTimeout = (Duration)Constraint.isNotNull((Object)timeout, (String)"Timeout cannot be null");
    }

    @Nonnull
    public Duration getSessionSlop() {
        return this.sessionSlop;
    }

    public void setSessionSlop(@Nonnull Duration slop) {
        this.checkSetterPreconditions();
        this.sessionSlop = (Duration)Constraint.isNotNull((Object)slop, (String)"Slop cannot be null");
    }

    public boolean isMaskStorageFailure() {
        return this.maskStorageFailure;
    }

    public void setMaskStorageFailure(boolean flag) {
        this.checkSetterPreconditions();
        this.maskStorageFailure = flag;
    }

    public boolean isTrackSPSessions() {
        return this.trackSPSessions;
    }

    public void setTrackSPSessions(boolean flag) {
        this.checkSetterPreconditions();
        this.trackSPSessions = flag;
    }

    public boolean isSecondaryServiceIndex() {
        return this.secondaryServiceIndex;
    }

    public void setSecondaryServiceIndex(boolean flag) {
        this.checkSetterPreconditions();
        this.secondaryServiceIndex = flag;
    }

    @Nonnull
    public BiPredicate<String, String> getConsistentAddressCondition() {
        return this.consistentAddressCondition;
    }

    public void setConsistentAddress(boolean flag) {
        this.checkSetterPreconditions();
        this.consistentAddressCondition = DefaultConsistentAddressConditionFactory.getDefaultConsistentAddressCondition(flag);
    }

    public void setConsistentAddressCondition(@Nonnull BiPredicate<String, String> condition) {
        this.checkSetterPreconditions();
        this.consistentAddressCondition = (BiPredicate)Constraint.isNotNull(condition, (String)"Consistent address condition cannot be null");
    }

    public void setCookieName(@Nonnull @NotEmpty String name) {
        this.checkSetterPreconditions();
        this.cookieName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Cookie name cannot be null or empty");
    }

    public void setCookieManager(@Nonnull CookieManager manager) {
        this.checkSetterPreconditions();
        this.cookieManager = (CookieManager)Constraint.isNotNull((Object)manager, (String)"CookieManager cannot be null");
    }

    @Nonnull
    public StorageService getStorageService() {
        this.checkComponentActive();
        assert (this.storageService != null);
        return this.storageService;
    }

    public void setStorageService(@Nonnull StorageService storage) {
        this.checkSetterPreconditions();
        this.storageService = (StorageService)Constraint.isNotNull((Object)storage, (String)"StorageService cannot be null");
    }

    public boolean storageServiceMeetsThreshold() {
        this.checkComponentActive();
        return this.storageService.getCapabilities().getValueSize() >= this.storageServiceThreshold;
    }

    public void setStorageServiceThreshold(long size) {
        this.checkSetterPreconditions();
        this.storageServiceThreshold = size;
    }

    public void setIDGenerator(@Nonnull IdentifierGenerationStrategy newIDGenerator) {
        this.checkSetterPreconditions();
        this.idGenerator = (IdentifierGenerationStrategy)Constraint.isNotNull((Object)newIDGenerator, (String)"IdentifierGenerationStrategy cannot be null");
    }

    @Nonnull
    public StorageSerializer<StorageBackedIdPSession> getStorageSerializer() {
        return this.serializer;
    }

    @Nullable
    public AuthenticationFlowDescriptor getAuthenticationFlowDescriptor(@Nonnull @NotEmpty String flowId) {
        return this.flowDescriptorMap.get(flowId);
    }

    @Nullable
    private HttpServletRequest getHttpRequest() {
        NonnullSupplier<HttpServletRequest> supplier = this.httpRequestSupplier;
        if (supplier == null) {
            return null;
        }
        return (HttpServletRequest)supplier.get();
    }

    public void setAuthenticationFlowDescriptors(@Nonnull Iterable<AuthenticationFlowDescriptor> flows) {
        this.checkSetterPreconditions();
        this.flowDescriptorMap.clear();
        for (AuthenticationFlowDescriptor desc : (Iterable)Constraint.isNotNull(flows, (String)"Flow collection cannot be null")) {
            if (desc == null) continue;
            this.flowDescriptorMap.put(desc.getId(), desc);
        }
    }

    @Nullable
    public SPSessionSerializerRegistry getSPSessionSerializerRegistry() {
        return this.spSessionSerializerRegistry;
    }

    public void setSPSessionSerializerRegistry(@Nullable SPSessionSerializerRegistry registry) {
        this.checkSetterPreconditions();
        this.spSessionSerializerRegistry = registry;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.storageService == null) {
            throw new ComponentInitializationException("Initialization of StorageBackedSessionManager requires non-null StorageService");
        }
        if (this.idGenerator == null) {
            throw new ComponentInitializationException("Initialization of StorageBackedSessionManager requires non-null IdentifierGenerationStrategy");
        }
        if (this.cookieManager == null) {
            throw new ComponentInitializationException("Initialization of StorageBackedSessionManager requires non-null CookieManager");
        }
        if (this.trackSPSessions && this.spSessionSerializerRegistry == null) {
            throw new ComponentInitializationException("Tracking SPSessions requires a spSessionSerializerRegistry");
        }
        this.serializer.initialize();
    }

    @Nonnull
    public IdPSession createSession(@Nonnull @NotEmpty String principalName) throws SessionException {
        StorageBackedIdPSession newSession;
        String sessionId;
        block7: {
            this.checkComponentActive();
            HttpServletRequest httpRequest = this.getHttpRequest();
            if (httpRequest == null) {
                throw new SessionException("No HttpServletRequest available, can't bind to client address");
            }
            String remoteAddr = StringSupport.trimOrNull((String)HttpServletSupport.getRemoteAddr((ServletRequest)httpRequest));
            if (remoteAddr == null) {
                throw new SessionException("No client address to bind");
            }
            sessionId = this.idGenerator.generateIdentifier(false);
            if (sessionId.length() > this.storageService.getCapabilities().getContextSize()) {
                throw new SessionException("Session IDs are too large for StorageService, check configuration");
            }
            Instant now = Instant.now();
            assert (now != null);
            newSession = new StorageBackedIdPSession(this, sessionId, principalName, now);
            newSession.doBindToAddress(remoteAddr);
            try {
                if (!this.storageService.create(sessionId, SESSION_PRIMARY_KEY, (Object)newSession, (StorageSerializer)this.serializer, Long.valueOf(newSession.getCreationInstant().plus(this.sessionTimeout).plus(this.sessionSlop).toEpochMilli()))) {
                    throw new SessionException("A duplicate session ID was generated, unable to create session");
                }
            }
            catch (IOException e) {
                this.log.error("Exception while storing new session for principal {}", (Object)principalName, (Object)e);
                if (this.maskStorageFailure) break block7;
                throw new SessionException("Exception while storing new session", (Exception)e);
            }
        }
        this.log.debug("Created new session {} for principal {}", (Object)sessionId, (Object)principalName);
        this.cookieManager.addCookie(this.cookieName, sessionId);
        return newSession;
    }

    public void destroySession(@Nonnull @NotEmpty String sessionId, boolean unbind) throws SessionException {
        this.checkComponentActive();
        if (unbind) {
            this.cookieManager.unsetCookie(this.cookieName);
        }
        try {
            this.storageService.deleteContext(sessionId);
            this.log.debug("Destroyed session {}", (Object)sessionId);
        }
        catch (IOException e) {
            this.log.error("Exception while destroying session {}: {}", (Object)sessionId, (Object)e.getMessage());
            throw new SessionException("Exception while destroying session", (Exception)e);
        }
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Iterable<IdPSession> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        this.checkComponentActive();
        if (criteria != null) {
            HttpServletRequestCriterion requestCriterion = (HttpServletRequestCriterion)criteria.get(HttpServletRequestCriterion.class);
            if (requestCriterion != null) {
                HttpServletRequest httpRequest = this.getHttpRequest();
                if (httpRequest != null) {
                    Cookie[] cookies = httpRequest.getCookies();
                    if (cookies != null) {
                        for (Cookie cookie : cookies) {
                            IdPSession session;
                            if (!this.cookieName.equals(cookie.getName()) || (session = this.lookupBySessionId(cookie.getValue())) == null) continue;
                            return CollectionSupport.singletonList((Object)session);
                        }
                    }
                    return CollectionSupport.emptyList();
                }
                throw new ResolverException("HttpServletRequest is null");
            }
            SessionIdCriterion sessionIdCriterion = (SessionIdCriterion)criteria.get(SessionIdCriterion.class);
            if (sessionIdCriterion != null) {
                IdPSession session = this.lookupBySessionId(sessionIdCriterion.getSessionId());
                if (session != null) {
                    return CollectionSupport.singletonList((Object)session);
                }
                return CollectionSupport.emptyList();
            }
            SPSessionCriterion serviceCriterion = (SPSessionCriterion)criteria.get(SPSessionCriterion.class);
            if (serviceCriterion != null) {
                if (!this.secondaryServiceIndex) {
                    throw new ResolverException("Secondary service index is disabled (must be enabled for SAML logout)");
                }
                return this.lookupBySPSession(serviceCriterion);
            }
        }
        throw new ResolverException("No supported criterion supplied");
    }

    @Nullable
    public IdPSession resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        Iterator<IdPSession> i = this.resolve(criteria).iterator();
        if (i != null && i.hasNext()) {
            return i.next();
        }
        return null;
    }

    protected void indexBySPSession(@Nonnull IdPSession idpSession, @Nonnull SPSession spSession, int attempts) throws SessionException {
        if (attempts <= 0) {
            this.log.error("Exceeded retry attempts while adding to secondary index");
            if (!this.maskStorageFailure) {
                throw new SessionException("Exceeded retry attempts while adding to secondary index");
            }
        } else if (this.secondaryServiceIndex && this.storageServiceMeetsThreshold()) {
            StorageRecord sessionList;
            String serviceKey;
            String serviceId;
            block21: {
                serviceId = spSession.getId();
                assert (serviceId != null);
                serviceKey = spSession.getSPSessionKey();
                if (serviceKey == null) {
                    return;
                }
                this.log.debug("Maintaining secondary index for service ID {} and key {}", (Object)serviceId, (Object)serviceKey);
                int contextSize = this.storageService.getCapabilities().getContextSize();
                int keySize = this.storageService.getCapabilities().getKeySize();
                if (serviceId.length() > contextSize) {
                    serviceId = serviceId.substring(0, contextSize);
                }
                if (serviceKey.length() > keySize) {
                    serviceKey = serviceKey.substring(0, keySize);
                }
                assert (serviceId != null && serviceKey != null);
                sessionList = null;
                try {
                    sessionList = this.storageService.read(serviceId, serviceKey);
                }
                catch (IOException e) {
                    this.log.error("Exception while querying based service ID {} and key {}", new Object[]{serviceId, serviceKey, e});
                    if (this.maskStorageFailure) break block21;
                    throw new SessionException("Exception while querying based on SPSession", (Exception)e);
                }
            }
            try {
                if (sessionList != null) {
                    if (!sessionList.getValue().contains(idpSession.getId() + ",")) {
                        String updated = sessionList.getValue() + idpSession.getId() + ",";
                        if (this.storageService.updateWithVersion(sessionList.getVersion(), serviceId, serviceKey, updated, Long.valueOf(Math.max((Long)Constraint.isNotNull((Object)sessionList.getExpiration(), (String)"Session List Expiration not set"), spSession.getExpirationInstant().plus(this.sessionSlop).toEpochMilli()))) == null) {
                            this.log.debug("Secondary index record disappeared, retrying as insert");
                            this.indexBySPSession(idpSession, spSession, attempts - 1);
                        }
                    } else {
                        this.log.debug("IdP session {} already indexed against service ID {} and key {}", new Object[]{idpSession.getId(), serviceId, serviceKey});
                    }
                } else if (!this.storageService.create(serviceId, serviceKey, idpSession.getId() + ",", Long.valueOf(spSession.getExpirationInstant().plus(this.sessionSlop).toEpochMilli()))) {
                    this.log.debug("Secondary index record appeared, retrying as update");
                    this.indexBySPSession(idpSession, spSession, attempts - 1);
                }
            }
            catch (IOException e) {
                this.log.error("Exception maintaining secondary index for service ID {} and key {}", new Object[]{serviceId, serviceKey, e});
                if (!this.maskStorageFailure) {
                    throw new SessionException("Exception maintaining secondary index", (Exception)e);
                }
            }
            catch (VersionMismatchException e) {
                this.log.debug("Secondary index record was updated between read/update, retrying");
                this.indexBySPSession(idpSession, spSession, attempts - 1);
            }
        }
    }

    protected void unindexSPSession(@Nonnull IdPSession idpSession, @Nonnull SPSession spSession, int attempts) throws SessionException {
        if (attempts <= 0) {
            this.log.error("Exceeded retry attempts while removing from secondary index");
            if (!this.maskStorageFailure) {
                throw new SessionException("Exceeded retry attempts while removing from secondary index");
            }
        } else if (this.secondaryServiceIndex && this.storageServiceMeetsThreshold()) {
            StorageRecord sessionList;
            String serviceKey;
            String serviceId;
            block22: {
                serviceId = spSession.getId();
                assert (serviceId != null);
                serviceKey = spSession.getSPSessionKey();
                if (serviceKey == null) {
                    return;
                }
                this.log.debug("Removing secondary index for service ID {} and key {}", (Object)serviceId, (Object)serviceKey);
                int contextSize = this.storageService.getCapabilities().getContextSize();
                int keySize = this.storageService.getCapabilities().getKeySize();
                if (serviceId.length() > contextSize) {
                    serviceId = serviceId.substring(0, contextSize);
                }
                if (serviceKey.length() > keySize) {
                    serviceKey = serviceKey.substring(0, keySize);
                }
                assert (serviceId != null && serviceKey != null);
                sessionList = null;
                try {
                    sessionList = this.storageService.read(serviceId, serviceKey);
                }
                catch (IOException e) {
                    this.log.error("Exception while querying based service ID {} and key {}", new Object[]{serviceId, serviceKey, e});
                    if (this.maskStorageFailure) break block22;
                    throw new SessionException("Exception while querying based on SPSession", (Exception)e);
                }
            }
            try {
                if (sessionList != null) {
                    String recordValue = sessionList.getValue();
                    if (recordValue.contains(idpSession.getId() + ",")) {
                        String updated = recordValue.replace(idpSession.getId() + ",", "");
                        if (updated.length() > 0) {
                            if (this.storageService.updateWithVersion(sessionList.getVersion(), serviceId, serviceKey, updated, sessionList.getExpiration()) == null) {
                                this.log.debug("Secondary index record disappeared, nothing to do");
                            }
                        } else {
                            this.storageService.deleteWithVersion(sessionList.getVersion(), serviceId, serviceKey);
                        }
                    } else {
                        this.log.debug("IdP session {} not indexed against service ID {} and key {}", new Object[]{idpSession.getId(), serviceId, serviceKey});
                    }
                } else {
                    this.log.debug("Secondary index record not found, nothing to do");
                }
            }
            catch (IOException e) {
                this.log.error("Exception removing secondary index for service ID {} and key {}", new Object[]{serviceId, serviceKey, e});
                if (!this.maskStorageFailure) {
                    throw new SessionException("Exception maintaining secondary index", (Exception)e);
                }
            }
            catch (VersionMismatchException e) {
                this.log.debug("Secondary index record was updated between read/update/delete, retrying");
                this.unindexSPSession(idpSession, spSession, attempts - 1);
            }
        }
    }

    @Nullable
    private IdPSession lookupBySessionId(@Nullable String sessionId) throws ResolverException {
        block5: {
            if (Strings.isNullOrEmpty((String)sessionId)) {
                this.log.debug("Lookup of null/empty session ID");
                return null;
            }
            assert (sessionId != null);
            this.log.debug("Performing primary lookup on session ID {}", (Object)sessionId);
            try {
                StorageRecord sessionRecord = this.storageService.read(sessionId, SESSION_PRIMARY_KEY);
                if (sessionRecord != null) {
                    return (IdPSession)sessionRecord.getValue((StorageSerializer)this.serializer, sessionId, SESSION_PRIMARY_KEY);
                }
                this.log.debug("Primary lookup failed for session ID {}", (Object)sessionId);
            }
            catch (IOException e) {
                this.log.error("Exception while querying for session ID {}", (Object)sessionId, (Object)e);
                if (this.maskStorageFailure) break block5;
                throw new ResolverException("Exception while querying for session", (Exception)e);
            }
        }
        return null;
    }

    @Nonnull
    private Iterable<IdPSession> lookupBySPSession(@Nonnull SPSessionCriterion criterion) throws ResolverException {
        StorageRecord sessionList;
        String serviceKey;
        String serviceId;
        block15: {
            int contextSize = this.storageService.getCapabilities().getContextSize();
            int keySize = this.storageService.getCapabilities().getKeySize();
            serviceId = criterion.getServiceId();
            serviceKey = criterion.getSPSessionKey();
            this.log.debug("Performing secondary lookup on service ID {} and key {}", (Object)serviceId, (Object)serviceKey);
            if (serviceId.length() > contextSize) {
                serviceId = serviceId.substring(0, contextSize);
                assert (serviceId != null);
            }
            if (serviceKey.length() > keySize) {
                serviceKey = serviceKey.substring(0, keySize);
                assert (serviceKey != null);
            }
            sessionList = null;
            try {
                sessionList = this.storageService.read(serviceId, serviceKey);
            }
            catch (IOException e) {
                this.log.error("Exception while querying based service ID {} and key {}", new Object[]{serviceId, serviceKey, e});
                if (this.maskStorageFailure) break block15;
                throw new ResolverException("Exception while querying based on SPSession", (Exception)e);
            }
        }
        if (sessionList == null) {
            this.log.debug("Secondary lookup failed on service ID {} and key {}", (Object)serviceId, (Object)serviceKey);
            return CollectionSupport.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        StringBuilder writeBackSessionList = new StringBuilder(sessionList.getValue().length());
        for (String sessionId : sessionList.getValue().split(",")) {
            IdPSession session = this.lookupBySessionId(sessionId);
            if (session == null) continue;
            builder.add((Object)session);
            writeBackSessionList.append(sessionId);
            writeBackSessionList.append(',');
        }
        try {
            String writeBackValue = writeBackSessionList.toString();
            if (writeBackValue.length() == 0) {
                this.storageService.deleteWithVersion(sessionList.getVersion(), serviceId, serviceKey);
            } else if (!writeBackValue.equals(sessionList.getValue())) {
                this.storageService.updateWithVersion(sessionList.getVersion(), serviceId, serviceKey, writeBackValue, sessionList.getExpiration());
            }
        }
        catch (IOException e) {
            this.log.warn("Ignoring exception while updating secondary index", (Throwable)e);
        }
        catch (VersionMismatchException e) {
            this.log.debug("Ignoring version mismatch while updating secondary index");
        }
        ImmutableList result = builder.build();
        assert (result != null);
        return result;
    }

    public static class DefaultConsistentAddressConditionFactory {
        @Nonnull
        public static BiPredicate<String, String> getDefaultConsistentAddressCondition(boolean flag) {
            if (flag) {
                return (A, B) -> Objects.equals(A, B);
            }
            return (A, B) -> true;
        }
    }
}

