/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session.impl;

import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.session.SessionManager;
import net.shibboleth.idp.session.context.LogoutContext;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class DestroySessions
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DestroySessions.class);
    @NonnullAfterInit
    private SessionManager sessionManager;
    @Nonnull
    private Function<ProfileRequestContext, SessionContext> sessionContextLookupStrategy = new ChildContextLookup(SessionContext.class);
    @Nonnull
    private Function<ProfileRequestContext, LogoutContext> logoutContextLookupStrategy = new ChildContextLookup(LogoutContext.class);
    @Nullable
    private SessionContext sessionContext;
    @NonnullBeforeExec
    private LogoutContext logoutContext;

    public void setSessionManager(@Nonnull SessionManager manager) {
        this.checkSetterPreconditions();
        this.sessionManager = (SessionManager)Constraint.isNotNull((Object)manager, (String)"SessionManager cannot be null");
    }

    public void setSessionContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SessionContext> strategy) {
        this.checkSetterPreconditions();
        this.sessionContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SessionContext lookup strategy cannot be null");
    }

    public void setLogoutContextLookupStrategy(@Nonnull Function<ProfileRequestContext, LogoutContext> strategy) {
        this.checkSetterPreconditions();
        this.logoutContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"LogoutContext lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (!PredicateSupport.isAlwaysFalse((Predicate)this.getActivationCondition()) && this.sessionManager == null) {
            throw new ComponentInitializationException("SessionManager cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.logoutContext = this.logoutContextLookupStrategy.apply(profileRequestContext);
        if (this.logoutContext == null || this.logoutContext.getIdPSessions().isEmpty()) {
            this.log.debug("{} No LogoutContext or IdPSessions found, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        this.sessionContext = this.sessionContextLookupStrategy.apply(profileRequestContext);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        SessionContext sc = this.sessionContext;
        for (IdPSession session : this.logoutContext.getIdPSessions()) {
            boolean unbind;
            assert (session != null);
            IdPSession idpSession = sc != null ? sc.getIdPSession() : null;
            this.log.debug("{} Attempting destruction of session {}", (Object)this.getLogPrefix(), (Object)session.getId());
            boolean bl = unbind = idpSession != null ? idpSession.equals(session) : false;
            if (unbind) {
                assert (sc != null);
                sc.removeFromParent();
                this.sessionContext = null;
                sc = null;
            }
            try {
                String id = session.getId();
                assert (id != null);
                this.sessionManager.destroySession(id, unbind);
            }
            catch (SessionException e) {
                this.log.error("{} Error destroying session", (Object)this.getLogPrefix(), (Object)e);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            }
        }
        this.logoutContext.getIdPSessions().clear();
    }
}

