/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.context;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.NonnullSupplier;
import org.opensaml.messaging.context.BaseContext;

@NotThreadSafe
public final class AttributeContext
extends BaseContext {
    @Nonnull
    private Map<String, IdPAttribute> attributes;
    @Nonnull
    private Map<String, IdPAttribute> unfilteredAttributes = CollectionSupport.emptyMap();
    private boolean consented;

    public AttributeContext() {
        this.attributes = CollectionSupport.emptyMap();
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<String, IdPAttribute> getIdPAttributes() {
        return this.attributes;
    }

    @Nonnull
    public AttributeContext setIdPAttributes(@Nullable Collection<IdPAttribute> newAttributes) {
        this.attributes = newAttributes != null ? (Map)((NonnullSupplier)newAttributes.stream().collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableMap(IdPAttribute::getId, a -> a, CollectionSupport.warningMergeFunction((String)"AttrtibuteContext", (boolean)true))))).get() : CollectionSupport.emptyMap();
        return this;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<String, IdPAttribute> getUnfilteredIdPAttributes() {
        return this.unfilteredAttributes;
    }

    @Nonnull
    public AttributeContext setUnfilteredIdPAttributes(@Nullable Collection<IdPAttribute> newAttributes) {
        this.unfilteredAttributes = null != newAttributes ? (Map)((NonnullSupplier)newAttributes.stream().collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableMap(IdPAttribute::getId, a -> a, CollectionSupport.warningMergeFunction((String)"AttrtibuteContextUnfiltered", (boolean)true))))).get() : CollectionSupport.emptyMap();
        return this;
    }

    public boolean isConsented() {
        return this.consented;
    }

    @Nonnull
    public AttributeContext setConsented(boolean flag) {
        this.consented = flag;
        return this;
    }
}

