/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.security.factory;

import java.io.InputStream;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.cryptacular.util.CertUtil;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.io.Resource;

public class X509CertificateFactoryBean
implements FactoryBean<X509Certificate> {
    @Nullable
    private Resource resource;
    @Nullable
    private X509Certificate certificate;

    public void setResource(@Nullable Resource res) {
        this.resource = res;
    }

    public X509Certificate getObject() throws Exception {
        if (this.certificate == null) {
            if (this.resource == null) {
                throw new BeanCreationException("Certificate resource must be provided in order to use this factory.");
            }
            assert (this.resource != null);
            try (InputStream is = this.resource.getInputStream();){
                this.certificate = CertUtil.readCertificate((InputStream)is);
            }
        }
        return this.certificate;
    }

    @Nonnull
    public Class<?> getObjectType() {
        return X509Certificate.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

