/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.security.factory;

import java.io.InputStream;
import java.security.PublicKey;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.cryptacular.util.KeyPairUtil;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.io.Resource;

public class PublicKeyFactoryBean
implements FactoryBean<PublicKey> {
    @Nullable
    private Resource resource;
    @Nullable
    private PublicKey key;

    public void setResource(@Nullable Resource res) {
        this.resource = res;
    }

    public PublicKey getObject() throws Exception {
        if (this.key == null) {
            if (this.resource == null) {
                throw new BeanCreationException("Public key resource must be provided in order to use this factory.");
            }
            assert (this.resource != null);
            try (InputStream is = this.resource.getInputStream();){
                this.key = KeyPairUtil.readPublicKey((InputStream)is);
            }
        }
        return this.key;
    }

    @Nonnull
    public Class<?> getObjectType() {
        return PublicKey.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

