/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.storage.StorageSerializer;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public final class SPSessionSerializerRegistry
extends AbstractInitializableComponent {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SPSessionSerializerRegistry.class);
    @Nonnull
    private Map<Class<? extends SPSession>, StorageSerializer<? extends SPSession>> registry = new HashMap<Class<? extends SPSession>, StorageSerializer<? extends SPSession>>();

    public SPSessionSerializerRegistry() {
        this(null);
    }

    @Autowired
    public SPSessionSerializerRegistry(@Nullable Collection<Entry<?>> serializers) {
        if (serializers != null) {
            serializers.forEach(e -> this.registry.put(e.getType(), e.getSerializer()));
        }
    }

    public void setMappings(@Nonnull Map<Class<? extends SPSession>, StorageSerializer<? extends SPSession>> map) {
        this.checkSetterPreconditions();
        Constraint.isNotNull(map, (String)"Map cannot be null");
        for (Map.Entry<Class<? extends SPSession>, StorageSerializer<? extends SPSession>> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            this.registry.put(entry.getKey(), entry.getValue());
        }
    }

    @Nullable
    public <T extends SPSession> StorageSerializer<T> lookup(@Nonnull Class<T> type) {
        this.checkComponentActive();
        Constraint.isNotNull(type, (String)"SPSession type cannot be null");
        StorageSerializer<? extends SPSession> serializer = this.registry.get(type);
        if (serializer != null) {
            this.log.debug("Registry located StorageSerializer of type '{}' for SPSession type '{}'", (Object)serializer.getClass().getName(), type);
            return serializer;
        }
        this.log.debug("Registry failed to locate StorageSerializer for SPSession type '{}'", type);
        return null;
    }

    public static class Entry<T extends SPSession> {
        @Nonnull
        private final Class<T> sessionType;
        @Nullable
        private final StorageSerializer<T> serializer;

        public Entry(@Nonnull @ParameterName(name="claz") Class<T> claz, @Nullable @ParameterName(name="object") StorageSerializer<T> object) {
            this.sessionType = (Class)Constraint.isNotNull(claz, (String)"Session type cannot be null");
            this.serializer = object;
        }

        @Nonnull
        Class<T> getType() {
            return this.sessionType;
        }

        @Nullable
        StorageSerializer<T> getSerializer() {
            return this.serializer;
        }
    }
}

