/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.installablecomponent;

import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.annotation.Nonnull;
import net.shibboleth.profile.module.Module;
import net.shibboleth.profile.plugin.Plugin;
import net.shibboleth.shared.primitive.StringSupport;

public class InstallableComponentVersion
implements Comparable<InstallableComponentVersion> {
    private static final int MAX_VNO = 10000;
    private int major;
    private int minor;
    private int patch;

    public InstallableComponentVersion(String version) throws NumberFormatException {
        String versionStr = StringSupport.trimOrNull((String)version);
        if (null == versionStr) {
            throw new NumberFormatException("Empty Version not allowed");
        }
        String[] components = versionStr.split("\\.|\\+|-");
        if (components.length >= 1) {
            this.major = this.parseValue(components[0]);
        }
        if (components.length >= 2) {
            this.minor = this.parseValue(components[1]);
        }
        if (components.length >= 3) {
            this.patch = this.parseValue(components[2]);
        }
    }

    public InstallableComponentVersion(@Nonnull Plugin<? extends Module> plugin) throws NumberFormatException {
        this(plugin.getMajorVersion(), plugin.getMinorVersion(), plugin.getPatchVersion());
    }

    public InstallableComponentVersion(int maj, int min, int pat) throws NumberFormatException {
        this.major = maj;
        if (maj < 0 || maj >= 10000) {
            throw new NumberFormatException("Improbable major version number : " + maj);
        }
        this.minor = min;
        if (min < 0 || min >= 10000) {
            throw new NumberFormatException("Improbable minor version number : " + min);
        }
        this.patch = pat;
        if (pat < 0 || pat >= 10000) {
            throw new NumberFormatException("Improbable patch version number : " + pat);
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    @JsonIgnore
    public boolean isNull() {
        return this.major == 0 && this.minor == 0 && this.patch == 0;
    }

    private int parseValue(String valueAsString) throws NumberFormatException {
        int value = Integer.parseInt(valueAsString);
        if (value < 0 || value >= 10000) {
            throw new NumberFormatException("Improbable version number : " + value);
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof InstallableComponentVersion) {
            InstallableComponentVersion other = (InstallableComponentVersion)obj;
            return other.major == this.major && other.minor == this.minor && other.patch == this.patch;
        }
        return false;
    }

    public int hashCode() {
        long l = this.major * 10000 * 10000;
        l += (long)(this.minor * 10000);
        return Long.hashCode(l += (long)this.patch);
    }

    @Override
    public int compareTo(InstallableComponentVersion other) {
        if (this.major == other.major) {
            if (this.minor == other.minor) {
                return this.patch - other.patch;
            }
            return this.minor - other.minor;
        }
        return this.major - other.major;
    }

    public String toString() {
        return new StringBuffer(8).append(Integer.toString(this.major)).append('.').append(Integer.toString(this.minor)).append('.').append(Integer.toString(this.patch)).toString();
    }
}

