/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.servlet.impl;

import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.servlet.AbstractConditionalFilter;
import net.shibboleth.shared.spring.servlet.ChainableFilter;

public class DynamicResponseHeaderFilter
extends AbstractConditionalFilter
implements ChainableFilter {
    @Nonnull
    private Map<String, String> headers = CollectionSupport.emptyMap();
    @Nonnull
    private Collection<Function<Pair<HttpServletRequest, HttpServletResponse>, Boolean>> callbacks = CollectionSupport.emptyList();

    public void setHeaders(@Nullable Map<String, String> map) {
        if (map != null) {
            this.headers = new HashMap<String, String>(map.size());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String trimmedName = StringSupport.trimOrNull((String)entry.getKey());
                String trimmedValue = StringSupport.trimOrNull((String)entry.getValue());
                if (trimmedName == null || trimmedValue == null) continue;
                this.headers.put(trimmedName, trimmedValue);
            }
        } else {
            this.headers = CollectionSupport.emptyMap();
        }
    }

    public void setCallbacks(@Nullable Collection<Function<Pair<HttpServletRequest, HttpServletResponse>, Boolean>> theCallbacks) {
        this.callbacks = theCallbacks != null ? CollectionSupport.copyToList(theCallbacks) : CollectionSupport.emptyList();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    @Override
    public int getOrder() {
        return ChainableFilter.FilterOrder.NEUTRAL.getValue();
    }

    protected void runFilter(@Nonnull ServletRequest request, @Nonnull ServletResponse response, @Nonnull FilterChain chain) throws IOException, ServletException {
        if (this.headers.isEmpty() && this.callbacks.isEmpty()) {
            chain.doFilter(request, response);
            return;
        }
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("Request is not an instance of HttpServletRequest");
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException("Response is not an instance of HttpServletResponse");
        }
        chain.doFilter(request, (ServletResponse)new ResponseProxy((HttpServletRequest)request, (HttpServletResponse)response));
    }

    private class ResponseProxy
    extends HttpServletResponseWrapper {
        @Nonnull
        private final HttpServletRequest request;

        public ResponseProxy(@Nonnull HttpServletRequest req, HttpServletResponse response) {
            super(response);
            this.request = req;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            this.addHeaders();
            return super.getOutputStream();
        }

        public PrintWriter getWriter() throws IOException {
            this.addHeaders();
            return super.getWriter();
        }

        public void sendError(int sc, String msg) throws IOException {
            this.addHeaders();
            super.sendError(sc, msg);
        }

        public void sendError(int sc) throws IOException {
            this.addHeaders();
            super.sendError(sc);
        }

        public void sendRedirect(String location) throws IOException {
            this.addHeaders();
            super.sendRedirect(location);
        }

        private void addHeaders() {
            for (Map.Entry<String, String> header : DynamicResponseHeaderFilter.this.headers.entrySet()) {
                ((HttpServletResponse)this.getResponse()).addHeader(header.getKey(), header.getValue());
            }
            if (!DynamicResponseHeaderFilter.this.callbacks.isEmpty()) {
                Pair p = new Pair((Object)this.request, (Object)((HttpServletResponse)this.getResponse()));
                for (Function<Pair<HttpServletRequest, HttpServletResponse>, Boolean> callback : DynamicResponseHeaderFilter.this.callbacks) {
                    callback.apply((Pair<HttpServletRequest, HttpServletResponse>)p);
                }
            }
        }
    }
}

