/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.consent.logic.impl.CounterStorageKeyComparator;
import net.shibboleth.idp.consent.logic.impl.FlowIdLookupFunction;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorFlowDescriptor;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;

public class CounterStorageKeyFunction
extends AbstractInitializableComponent
implements Function<Pair<ProfileRequestContext, List<String>>, List<String>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CounterStorageKeyFunction.class);
    @Nonnull
    private Function<ProfileRequestContext, ProfileInterceptorContext> interceptorContextlookupStrategy = new ChildContextLookup(ProfileInterceptorContext.class);
    @Nonnull
    private Function<ProfileRequestContext, String> storageContextLookupStrategy = new FlowIdLookupFunction();

    public void setInterceptorContextLookupStrategy(@Nonnull Function<ProfileRequestContext, ProfileInterceptorContext> strategy) {
        this.checkSetterPreconditions();
        this.interceptorContextlookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Profile interceptor context lookup strategy cannot be null");
    }

    public void setStorageContextLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.storageContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Storage context lookup strategy cannot be null");
    }

    @Nonnull
    protected StorageService getStorageService(@Nonnull ProfileRequestContext profileRequestContext) {
        Constraint.isNotNull((Object)profileRequestContext, (String)"Profile request context cannot be null");
        ProfileInterceptorContext interceptorContext = this.interceptorContextlookupStrategy.apply(profileRequestContext);
        Constraint.isNotNull((Object)interceptorContext, (String)"Profile interceptor context not available from profile request context");
        ProfileInterceptorFlowDescriptor flowDescriptor = (ProfileInterceptorFlowDescriptor)Constraint.isNotNull((Object)interceptorContext.getAttemptedFlow(), (String)"Profile interceptor flow descriptor not available from profile interceptor context");
        return (StorageService)Constraint.isNotNull((Object)flowDescriptor.getStorageService(), (String)"Storage service not available from interceptor flow descriptor");
    }

    @Nonnull
    protected String getStorageContext(@Nonnull ProfileRequestContext profileRequestContext) {
        Constraint.isNotNull((Object)profileRequestContext, (String)"Profile request context cannot be null");
        return (String)Constraint.isNotNull((Object)this.storageContextLookupStrategy.apply(profileRequestContext), (String)"Storage context not available from profile request context");
    }

    @Nonnull
    protected String getCounterStorageKey(@Nonnull String storageKey) {
        Constraint.isNotNull((Object)storageKey, (String)"Storage key cannot be null");
        return Joiner.on((String)":").join((Object)storageKey, (Object)"_counter", new Object[0]);
    }

    @Nullable
    protected Long getStorageKeyCounter(@Nonnull StorageService storageService, @Nonnull String storageContext, @Nonnull String storageKey) throws IOException {
        Constraint.isNotNull((Object)storageService, (String)"Storage service cannot be null");
        Constraint.isNotNull((Object)storageContext, (String)"Storage context cannot be null");
        Constraint.isNotNull((Object)storageKey, (String)"Storage key cannot be null");
        String counterStorageKey = this.getCounterStorageKey(storageKey);
        StorageRecord storageRecord = storageService.read(storageContext, counterStorageKey);
        this.log.debug("Read storage record '{}' with context '{}' and key '{}'", new Object[]{storageRecord, storageContext, counterStorageKey});
        return storageRecord == null ? null : Long.valueOf(storageRecord.getVersion());
    }

    @Nonnull
    protected Map<String, Long> getStorageKeyCounters(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull List<String> storageKeys) {
        Constraint.isNotNull((Object)profileRequestContext, (String)"Profile request context cannot be null");
        Constraint.isNotNull(storageKeys, (String)"Storage keys cannot be null");
        StorageService storageService = this.getStorageService(profileRequestContext);
        String storageContext = this.getStorageContext(profileRequestContext);
        LinkedHashMap<String, Long> map = new LinkedHashMap<String, Long>();
        for (String storageKey : storageKeys) {
            assert (storageKey != null);
            try {
                map.put(storageKey, this.getStorageKeyCounter(storageService, storageContext, storageKey));
            }
            catch (IOException | NumberFormatException e) {
                this.log.error("Unable to retrieve counter for storage key '{}'", (Object)storageKey, (Object)e);
            }
        }
        return map;
    }

    @Override
    @Nullable
    public List<String> apply(@Nullable Pair<ProfileRequestContext, List<String>> input) {
        if (input == null) {
            return null;
        }
        ProfileRequestContext profileRequestContext = (ProfileRequestContext)input.getFirst();
        List storageKeys = (List)input.getSecond();
        if (storageKeys == null || profileRequestContext == null) {
            return null;
        }
        try {
            Map<String, Long> keyToCounterMap = this.getStorageKeyCounters(profileRequestContext, storageKeys);
            CounterStorageKeyComparator comparator = new CounterStorageKeyComparator(storageKeys, keyToCounterMap);
            Collections.sort(storageKeys, comparator);
            return storageKeys;
        }
        catch (ConstraintViolationException e) {
            this.log.warn("Unable to apply counter storage key function", (Throwable)e);
            return (List)input.getSecond();
        }
    }
}

