/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.policyrule.saml.impl;

import com.google.common.collect.Multimap;
import java.time.Instant;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributesMapContainer;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.filter.PolicyRequirementRule;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.attribute.filter.policyrule.impl.AbstractPolicyRule;
import net.shibboleth.idp.saml.xmlobject.ScopedValue;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.xml.DOMTypeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSBase64Binary;
import org.opensaml.core.xml.schema.XSBoolean;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.schema.XSDateTime;
import org.opensaml.core.xml.schema.XSInteger;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.XSURI;
import org.opensaml.saml.ext.saml2mdattr.EntityAttributes;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.slf4j.Logger;

public abstract class AbstractEntityAttributePolicyRule
extends AbstractPolicyRule {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractEntityAttributePolicyRule.class);
    @NonnullAfterInit
    @NotEmpty
    private String attrName;
    @Nullable
    @NotEmpty
    private String nameFormat;
    private boolean ignoreUnmappedEntityAttributes;

    @NonnullAfterInit
    @NotEmpty
    public String getAttributeName() {
        return this.attrName;
    }

    public void setAttributeName(@Nullable @NotEmpty String attributeName) {
        this.checkSetterPreconditions();
        this.attrName = StringSupport.trimOrNull((String)attributeName);
    }

    @Nullable
    @NotEmpty
    public String getNameFormat() {
        return this.nameFormat;
    }

    public void setNameFormat(@Nullable @NotEmpty String attributeNameFormat) {
        this.checkSetterPreconditions();
        this.nameFormat = StringSupport.trimOrNull((String)attributeNameFormat);
    }

    public boolean getIgnoreUnmappedEntityAttributes() {
        return this.ignoreUnmappedEntityAttributes;
    }

    public void setIgnoreUnmappedEntityAttributes(boolean flag) {
        this.checkSetterPreconditions();
        this.ignoreUnmappedEntityAttributes = flag;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.attrName == null) {
            throw new ComponentInitializationException(this.getLogPrefix() + " Attribute name is null");
        }
        if (this.nameFormat != null) {
            this.ignoreUnmappedEntityAttributes = false;
        }
    }

    @Nonnull
    public PolicyRequirementRule.Tristate matches(@Nonnull AttributeFilterContext filterContext) {
        Constraint.isNotNull((Object)filterContext, (String)"Context must be supplied");
        this.checkComponentActive();
        EntityDescriptor entityDescriptor = this.getEntityMetadata(filterContext);
        if (entityDescriptor == null) {
            this.log.debug("{} No metadata available for entity, returning FALSE", (Object)this.getLogPrefix());
            return PolicyRequirementRule.Tristate.FALSE;
        }
        LinkedHashSet<String> attributeValues = new LinkedHashSet<String>();
        this.getEntityAttributeValues((XMLObject)entityDescriptor, entityDescriptor.getEntityID(), attributeValues);
        XMLObject parent = entityDescriptor.getParent();
        while (parent instanceof EntitiesDescriptor) {
            this.getEntityAttributeValues(parent, ((EntitiesDescriptor)parent).getName(), attributeValues);
            parent = parent.getParent();
        }
        if (attributeValues.isEmpty()) {
            this.log.debug("{} No values found for entity attribute {} for entity {}, returning FALSE", new Object[]{this.getLogPrefix(), this.getAttributeName(), entityDescriptor.getEntityID()});
            return PolicyRequirementRule.Tristate.FALSE;
        }
        if (this.entityAttributeValueMatches(attributeValues)) {
            this.log.debug("{} Entity attribute values for {} match requirements", (Object)this.getLogPrefix(), (Object)this.getAttributeName());
            return PolicyRequirementRule.Tristate.TRUE;
        }
        this.log.debug("{} Entity attribute values for {} do not match requirements", (Object)this.getLogPrefix(), (Object)this.getAttributeName());
        return PolicyRequirementRule.Tristate.FALSE;
    }

    @Nullable
    protected abstract EntityDescriptor getEntityMetadata(@Nonnull AttributeFilterContext var1);

    protected abstract boolean entityAttributeValueMatches(@Nonnull @NotEmpty Set<String> var1);

    private void getEntityAttributeValues(@Nonnull XMLObject metadataObject, @Nullable @NotEmpty String name, @Nonnull @Live Set<String> valueAccumulator) {
        List entityAttributes;
        if (this.nameFormat == null) {
            this.getMappedEntityAttributeValues(metadataObject, valueAccumulator);
            if (this.ignoreUnmappedEntityAttributes) {
                return;
            }
        }
        List entityAttributesCollection = null;
        Extensions extensions = null;
        if (metadataObject instanceof EntityDescriptor) {
            extensions = ((EntityDescriptor)metadataObject).getExtensions();
        } else if (metadataObject instanceof EntitiesDescriptor) {
            extensions = ((EntitiesDescriptor)metadataObject).getExtensions();
        }
        if (extensions != null) {
            entityAttributesCollection = extensions.getUnknownXMLObjects(EntityAttributes.DEFAULT_ELEMENT_NAME);
        }
        if (entityAttributesCollection == null || entityAttributesCollection.isEmpty()) {
            this.log.debug("{} Metadata for {} does not contain EntityAttributes extension", (Object)this.getLogPrefix(), (Object)name);
            return;
        }
        if (entityAttributesCollection.size() > 1) {
            this.log.debug("{} Metadata for {} contains more than one EntityAttributes extension, only using the first one", (Object)this.getLogPrefix(), (Object)name);
        }
        if ((entityAttributes = ((EntityAttributes)entityAttributesCollection.get(0)).getAttributes()) == null || entityAttributes.isEmpty()) {
            this.log.debug("{} EntityAttributes extension for {} does not contain Attributes", (Object)this.getLogPrefix(), (Object)name);
            return;
        }
        for (Attribute entityAttribute : entityAttributes) {
            if (!Objects.equals(this.getAttributeName(), entityAttribute.getName()) || this.getNameFormat() != null && !Objects.equals(this.getNameFormat(), entityAttribute.getNameFormat())) continue;
            this.log.debug("{} Metadata for {} contains Attribute matching name {} and format {}", new Object[]{this.getLogPrefix(), name, this.getAttributeName(), this.getNameFormat()});
            valueAccumulator.addAll(entityAttribute.getAttributeValues().stream().map(this::getStringValue).collect(Collectors.toUnmodifiableList()));
        }
    }

    private void getMappedEntityAttributeValues(@Nonnull XMLObject metadataObject, @Nonnull @Live Set<String> valueAccumulator) {
        Multimap<String, IdPAttribute> mappedAttributes = this.getMappedRequestedAttributes(metadataObject);
        if (mappedAttributes == null || mappedAttributes.isEmpty()) {
            this.log.debug("{} No mapped entity attributes found for {}", (Object)this.getLogPrefix(), (Object)this.attrName);
            return;
        }
        this.log.debug("{} Checking for mapped entity attributes named {}", (Object)this.getLogPrefix(), (Object)this.attrName);
        int count = 0;
        for (IdPAttribute attribute : mappedAttributes.get((Object)this.attrName)) {
            for (IdPAttributeValue attributeValue : attribute.getValues()) {
                if (attributeValue instanceof StringAttributeValue) {
                    valueAccumulator.add(((StringAttributeValue)attributeValue).getValue());
                    ++count;
                    continue;
                }
                this.log.error("{} Ignoring non-string value in mapped entity attribute {}", (Object)this.getLogPrefix(), (Object)this.attrName);
            }
        }
        this.log.debug("{} Added {} values of mapped entity attribute {} for evaluation", new Object[]{this.getLogPrefix(), count, this.attrName});
    }

    @Nullable
    private Multimap<String, IdPAttribute> getMappedRequestedAttributes(@Nonnull XMLObject metadataObject) {
        AttributesMapContainer container;
        List containerList = metadataObject.getObjectMetadata().get(AttributesMapContainer.class);
        if (null == containerList || containerList.isEmpty()) {
            return null;
        }
        if (containerList.size() > 1) {
            this.log.error("{} More than one set of mapped attributes found when filtering, this shouldn't ever happen", (Object)this.getLogPrefix());
        }
        return (container = (AttributesMapContainer)containerList.get(0)) != null ? container.get() : null;
    }

    @Nullable
    private String getStringValue(@Nonnull XMLObject object) {
        String retVal = null;
        if (object instanceof XSString) {
            XSString val = (XSString)object;
            retVal = val.getValue();
        } else if (object instanceof XSURI) {
            XSURI val = (XSURI)object;
            retVal = val.getURI();
        } else if (object instanceof XSBoolean) {
            Boolean flag;
            XSBoolean val = (XSBoolean)object;
            XSBooleanValue bval = val.getValue();
            if (bval != null && (flag = bval.getValue()) != null) {
                retVal = flag != false ? "1" : "0";
            }
        } else if (object instanceof XSInteger) {
            XSInteger val = (XSInteger)object;
            Integer ival = val.getValue();
            if (ival != null) {
                retVal = ival.toString();
            }
        } else if (object instanceof XSDateTime) {
            XSDateTime val = (XSDateTime)object;
            Instant dt = val.getValue();
            retVal = dt != null ? DOMTypeSupport.instantToString((Instant)dt) : null;
        } else if (object instanceof XSBase64Binary) {
            XSBase64Binary val = (XSBase64Binary)object;
            retVal = val.getValue();
        } else if (object instanceof ScopedValue) {
            ScopedValue val = (ScopedValue)object;
            retVal = val.getValue();
        } else if (object instanceof XSAny) {
            XSAny val = (XSAny)object;
            retVal = val.getUnknownAttributes().isEmpty() && val.getUnknownXMLObjects().isEmpty() ? val.getTextContent() : null;
        }
        if (null == retVal) {
            this.log.info("Value of type {} could not be converted", (Object)object.getClass().getSimpleName());
        }
        return retVal;
    }
}

