/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.matcher.impl;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.filter.Matcher;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public abstract class AbstractMatcher
extends AbstractIdentifiableInitializableComponent
implements Matcher {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractMatcher.class);
    @Nullable
    private String logPrefix;

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.logPrefix = null;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Set<IdPAttributeValue> getMatchingValues(@Nonnull IdPAttribute attribute, @Nonnull AttributeFilterContext filterContext) {
        LinkedHashSet<IdPAttributeValue> matchedValues = new LinkedHashSet<IdPAttributeValue>();
        this.log.debug("{} Applying value comparison to all values of Attribute '{}'", (Object)this.getLogPrefix(), (Object)attribute.getId());
        for (IdPAttributeValue value : attribute.getValues()) {
            assert (value != null);
            if (!this.compareAttributeValue(value)) continue;
            matchedValues.add(value);
        }
        return CollectionSupport.copyToSet(matchedValues);
    }

    protected abstract boolean compareAttributeValue(@Nonnull IdPAttributeValue var1);

    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        String prefix = this.logPrefix;
        if (null == prefix) {
            StringBuilder builder = new StringBuilder("Attribute Filter '").append(this.getId()).append("':");
            prefix = builder.toString();
            if (null == this.logPrefix) {
                this.logPrefix = prefix;
            }
        }
        assert (prefix != null);
        return prefix;
    }
}

