/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.filter.AttributeFilter;
import net.shibboleth.idp.attribute.filter.AttributeFilterException;
import net.shibboleth.idp.attribute.filter.AttributeFilterPolicy;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterWorkContext;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.RootContextLookup;
import org.opensaml.profile.context.MetricContext;
import org.opensaml.profile.context.ProxiedRequesterContext;
import org.slf4j.Logger;

@ThreadSafe
public class AttributeFilterImpl
extends AbstractIdentifiableInitializableComponent
implements AttributeFilter {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeFilterImpl.class);
    @Nonnull
    private final List<AttributeFilterPolicy> filterPolicies;
    @Nullable
    private String logPrefix;
    @Nonnull
    private Function<AttributeFilterContext, MetricContext> metricContextLookupStrategy;

    public AttributeFilterImpl(@Nonnull @NotEmpty String engineId, @Nullable Collection<AttributeFilterPolicy> policies) {
        this.setId(engineId);
        assert (policies != null);
        this.filterPolicies = CollectionSupport.copyToList(policies);
        Function mcls = new ChildContextLookup(MetricContext.class).compose((Function)new RootContextLookup());
        assert (mcls != null);
        this.metricContextLookupStrategy = mcls;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public List<AttributeFilterPolicy> getFilterPolicies() {
        return this.filterPolicies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterAttributes(@Nonnull AttributeFilterContext filterContext) throws AttributeFilterException {
        this.checkComponentActive();
        Constraint.isNotNull((Object)filterContext, (String)"Attribute filter context cannot be null");
        boolean timerStarted = this.startTimer(filterContext);
        try {
            Map prefilteredAttributes = filterContext.getPrefilteredIdPAttributes();
            filterContext.ensureSubcontext(AttributeFilterWorkContext.class);
            this.log.debug("{} Beginning process of filtering the following {} attributes: {}", new Object[]{this.getLogPrefix(), prefilteredAttributes.size(), prefilteredAttributes.keySet()});
            this.logContext(filterContext);
            List<AttributeFilterPolicy> policies = this.getFilterPolicies();
            for (AttributeFilterPolicy attributeFilterPolicy : policies) {
                attributeFilterPolicy.apply(filterContext);
            }
            for (Map.Entry entry : filterContext.getPrefilteredIdPAttributes().entrySet()) {
                assert (entry != null);
                String key = (String)entry.getKey();
                assert (key != null);
                Collection<IdPAttributeValue> filteredAttributeValues = this.getFilteredValues(key, filterContext);
                HashMap<String, IdPAttribute> allFilteredAttributes = new HashMap<String, IdPAttribute>(filterContext.getFilteredIdPAttributes());
                if (null != filteredAttributeValues && !filteredAttributeValues.isEmpty()) {
                    IdPAttribute filteredAttribute;
                    try {
                        filteredAttribute = ((IdPAttribute)entry.getValue()).clone();
                    }
                    catch (CloneNotSupportedException e) {
                        throw new AttributeFilterException((Exception)e);
                    }
                    ArrayList values = new ArrayList(filteredAttribute.getValues());
                    values.retainAll(filteredAttributeValues);
                    filteredAttribute.setValues(values);
                    allFilteredAttributes.put(filteredAttribute.getId(), filteredAttribute);
                }
                filterContext.setFilteredIdPAttributes(allFilteredAttributes.values());
            }
        }
        finally {
            if (timerStarted) {
                this.stopTimer(filterContext);
            }
        }
    }

    @Nonnull
    private String notProvidedOr(@Nullable String input) {
        return input == null ? "<Not Supplied>" : input;
    }

    @Nonnull
    private String present(@Nullable Object input) {
        return input != null ? "present" : "not present";
    }

    private void logContext(@Nonnull AttributeFilterContext filterContext) {
        Collection requesters;
        this.log.debug("{} Principal {}, IssuerID {}, RecipientID {}, RecipientGroupId {}", new Object[]{this.logPrefix, this.notProvidedOr(filterContext.getPrincipal()), this.notProvidedOr(filterContext.getAttributeIssuerID()), this.notProvidedOr(filterContext.getAttributeRecipientID()), this.notProvidedOr(filterContext.getAttributeRecipientGroupID())});
        this.log.debug("{} Direction {}", (Object)this.logPrefix, (Object)filterContext.getDirection());
        this.log.debug("{} Issuer MetadataContext {}, Requester MetadataContext {}, Proxied MetadataContext {}", new Object[]{this.logPrefix, this.present(filterContext.getIssuerMetadataContext()), this.present(filterContext.getRequesterMetadataContext()), this.present(filterContext.getProxiedRequesterMetadataContext())});
        ProxiedRequesterContext proxiedContext = filterContext.getProxiedRequesterContext();
        Collection collection = requesters = proxiedContext != null ? proxiedContext.getRequesters() : CollectionSupport.emptyList();
        if (!requesters.isEmpty()) {
            this.log.debug("{} Proxy requesters {}", (Object)this.logPrefix, requesters);
        }
    }

    @Nullable
    protected Collection<IdPAttributeValue> getFilteredValues(@Nonnull @NotEmpty String attributeId, @Nonnull AttributeFilterContext filterContext) {
        Constraint.isNotNull((Object)attributeId, (String)"attributeId cannot be null");
        Constraint.isNotNull((Object)filterContext, (String)"filterContext cannot be null");
        AttributeFilterWorkContext filterWorkContext = (AttributeFilterWorkContext)filterContext.getSubcontext(AttributeFilterWorkContext.class);
        Collection filteredAttributeValues = (Collection)((AttributeFilterWorkContext)Constraint.isNotNull((Object)filterWorkContext, (String)"AttributeFilterWorkContext cannot be null")).getPermittedIdPAttributeValues().get(attributeId);
        if (filteredAttributeValues == null || filteredAttributeValues.isEmpty()) {
            this.log.debug("Attribute filtering engine '{}': no policy permitted release of attribute {} values", (Object)this.getId(), (Object)attributeId);
            return null;
        }
        assert (filterWorkContext != null);
        if (filterWorkContext.getDeniedAttributeValues().containsKey(attributeId)) {
            filteredAttributeValues.removeAll((Collection)filterWorkContext.getDeniedAttributeValues().get(attributeId));
        }
        if (filteredAttributeValues.isEmpty()) {
            this.log.debug("Attribute filtering engine '{}': deny policies filtered out all values for attribute '{}'", (Object)this.getId(), (Object)attributeId);
        } else {
            this.log.debug("Attribute filtering engine '{}': {} values for attribute '{}' remained after filtering", new Object[]{this.getId(), filteredAttributeValues.size(), attributeId});
        }
        return filteredAttributeValues;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.logPrefix = null;
    }

    @Nonnull
    protected String getLogPrefix() {
        String result = this.logPrefix;
        if (null == result) {
            this.logPrefix = result = new StringBuffer("Attribute filtering engine '").append(this.getId()).append("' ").toString();
        }
        assert (result != null);
        return result;
    }

    private boolean startTimer(@Nonnull AttributeFilterContext filterContext) {
        MetricContext timerCtx = this.metricContextLookupStrategy.apply(filterContext);
        if (timerCtx != null) {
            timerCtx.start(this.ensureId());
            return true;
        }
        return false;
    }

    private void stopTimer(@Nonnull AttributeFilterContext filterContext) {
        MetricContext timerCtx = this.metricContextLookupStrategy.apply(filterContext);
        if (timerCtx != null) {
            timerCtx.stop(this.ensureId());
        }
    }
}

