/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

public final class ResolverDataConnectorDependency {
    @Nonnull
    @NotEmpty
    private final String dependencyPluginId;
    private boolean allAttributes;
    @Nonnull
    @NotEmpty
    private Set<String> attributeNames;

    public ResolverDataConnectorDependency(@Nonnull @ParameterName(name="pluginId") @NotEmpty String pluginId) {
        this.dependencyPluginId = Constraint.isNotEmpty((String)StringSupport.trimOrNull((String)pluginId), (String)"Plugin ID cannot be null or empty");
        this.allAttributes = false;
        this.attributeNames = CollectionSupport.emptySet();
    }

    @Nonnull
    public String getDependencyPluginId() {
        return this.dependencyPluginId;
    }

    public boolean isAllAttributes() {
        return this.allAttributes;
    }

    public void setAllAttributes(boolean all) {
        this.allAttributes = all;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Collection<String> getAttributeNames() {
        return this.attributeNames;
    }

    public void setAttributeNames(@Nonnull @NotEmpty Collection<String> names) {
        this.attributeNames = CollectionSupport.copyToSet((Collection)StringSupport.normalizeStringCollection(names));
    }

    public int hashCode() {
        int[] input = new int[]{this.getAttributeNames().hashCode(), this.getDependencyPluginId().hashCode(), this.isAllAttributes() ? 1 : 0};
        return Arrays.hashCode(input);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResolverDataConnectorDependency other = (ResolverDataConnectorDependency)obj;
        return Objects.equals(this.getDependencyPluginId(), other.getDependencyPluginId()) && Objects.equals(this.getAttributeNames(), other.getAttributeNames()) && this.isAllAttributes() == other.isAllAttributes();
    }
}

