/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.installer.plugin.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.module.IdPModule;
import net.shibboleth.profile.module.Module;
import net.shibboleth.profile.module.ModuleContext;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class RollbackPluginInstall
implements AutoCloseable {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RollbackPluginInstall.class);
    @Nonnull
    @Live
    private List<IdPModule> modulesEnabled = new ArrayList<IdPModule>();
    @Nonnull
    @Live
    private List<IdPModule> modulesDisabled = new ArrayList<IdPModule>();
    @Nonnull
    @Live
    private List<Path> filesCopied = new ArrayList<Path>();
    @Nonnull
    @Live
    private List<Pair<Path, Path>> filesRenamedAway = new ArrayList<Pair<Path, Path>>();
    @Nonnull
    private final ModuleContext moduleContext;
    @Nonnull
    private final Map<Module.ModuleResource, Module.ResourceResult> moduleChanges;

    public RollbackPluginInstall(@Nonnull @Live ModuleContext context, @Nonnull Map<Module.ModuleResource, Module.ResourceResult> changes) {
        this.moduleContext = (ModuleContext)Constraint.isNotNull((Object)context, (String)"Module context should be non null");
        this.moduleChanges = (Map)Constraint.isNotNull(changes, (String)"Module changes should be non null");
    }

    @Nonnull
    @Live
    public List<IdPModule> getModulesEnabled() {
        return this.modulesEnabled;
    }

    @Nonnull
    @Live
    public List<IdPModule> getModulesDisabled() {
        return this.modulesDisabled;
    }

    @Nonnull
    @Live
    public List<Path> getFilesCopied() {
        return this.filesCopied;
    }

    @Nonnull
    @Live
    public List<Pair<Path, Path>> getFilesRenamedAway() {
        return this.filesRenamedAway;
    }

    private boolean rollbackEnabledModules() {
        if (this.modulesEnabled.isEmpty()) {
            return false;
        }
        for (int i = this.modulesEnabled.size() - 1; i >= 0; --i) {
            IdPModule module = this.modulesEnabled.get(i);
            try {
                this.log.trace("Deleting {}", (Object)module.getId());
                this.captureChanges(module.disable(this.moduleContext, false));
                continue;
            }
            catch (Throwable t) {
                this.log.error("Could not disable {}: ", (Object)module.getId(), (Object)t);
            }
        }
        return true;
    }

    private boolean rollbackDisabledModules() {
        if (this.modulesDisabled.isEmpty()) {
            return false;
        }
        for (int i = this.modulesDisabled.size() - 1; i >= 0; --i) {
            IdPModule module = this.modulesDisabled.get(i);
            try {
                this.log.trace("Deleting {}", (Object)module.getId());
                this.captureChanges(module.enable(this.moduleContext));
                continue;
            }
            catch (Throwable t) {
                this.log.error("Could not disable {}, continuing ", (Object)module.getId(), (Object)t);
            }
        }
        return true;
    }

    private boolean rollbackCopies() {
        if (this.filesCopied.isEmpty()) {
            return false;
        }
        for (int i = this.filesCopied.size() - 1; i >= 0; --i) {
            Path path = this.filesCopied.get(i);
            try {
                this.log.trace("Deleting {}", (Object)path);
                Files.delete(path);
                continue;
            }
            catch (Throwable t) {
                this.log.error("Could not delete {}, continuing ", (Object)path, (Object)t);
                path.toFile().deleteOnExit();
            }
        }
        return true;
    }

    private boolean rollbackRenamed() {
        if (this.filesRenamedAway.isEmpty()) {
            return false;
        }
        for (int i = this.filesRenamedAway.size() - 1; i >= 0; --i) {
            Pair<Path, Path> filePair = this.filesRenamedAway.get(i);
            Path from = (Path)filePair.getFirst();
            Path to = (Path)filePair.getSecond();
            assert (from != null && to != null);
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(to.toFile()));
                 BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(from.toFile()));){
                this.log.trace("Copying {} to {}", filePair.getSecond());
                ((InputStream)in).transferTo(out);
                continue;
            }
            catch (Throwable t) {
                this.log.error("Could not copy {} to {}, continuing ", new Object[]{filePair.getSecond(), filePair.getFirst(), t});
            }
        }
        return true;
    }

    private void captureChanges(@Nonnull Map<Module.ModuleResource, Module.ResourceResult> changes) {
        for (Map.Entry<Module.ModuleResource, Module.ResourceResult> entry : changes.entrySet()) {
            this.moduleChanges.put(entry.getKey(), entry.getValue());
        }
    }

    protected void rollback() {
        boolean workPerformed = this.rollbackEnabledModules();
        workPerformed |= this.rollbackCopies();
        workPerformed |= this.rollbackRenamed();
        if (!(workPerformed |= this.rollbackDisabledModules())) {
            this.log.debug("Rollback/Uninstall.  No work done");
        } else {
            this.log.info("Rollback Complete");
        }
    }

    public void completed() {
        this.modulesEnabled = CollectionSupport.emptyList();
        this.modulesDisabled = CollectionSupport.emptyList();
        this.filesCopied = CollectionSupport.emptyList();
        this.filesRenamedAway = CollectionSupport.emptyList();
    }

    @Override
    public void close() {
        this.rollback();
    }
}

