/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.installer.plugin.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.Version;
import net.shibboleth.idp.cli.AbstractIdPHomeAwareCommandLine;
import net.shibboleth.idp.cli.AbstractIdPHomeAwareCommandLineArguments;
import net.shibboleth.idp.installer.InstallerSupport;
import net.shibboleth.idp.installer.plugin.impl.PluginInstaller;
import net.shibboleth.idp.installer.plugin.impl.PluginInstallerArguments;
import net.shibboleth.idp.installer.plugin.impl.PluginState;
import net.shibboleth.idp.plugin.IdPPlugin;
import net.shibboleth.idp.plugin.impl.PluginInfo;
import net.shibboleth.profile.installablecomponent.InstallableComponentInfo;
import net.shibboleth.profile.installablecomponent.InstallableComponentSupport;
import net.shibboleth.profile.installablecomponent.InstallableComponentVersion;
import net.shibboleth.profile.plugin.Plugin;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.tools.ant.BuildException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public final class PluginInstallerCLI
extends AbstractIdPHomeAwareCommandLine<PluginInstallerArguments> {
    private Logger log;
    public static final int RC_MODULE = 3;
    @Nullable
    private PluginInstaller installer;
    private List<URL> updateURLs;
    @Nullable
    private InstallableComponentVersion determinedIdpVersion;

    private PluginInstallerCLI() {
    }

    @Nonnull
    protected Logger getLogger() {
        Logger theLog = this.log;
        if (theLog == null) {
            theLog = this.log = LoggerFactory.getLogger(PluginInstallerCLI.class);
        }
        return theLog;
    }

    @Nonnull
    protected Class<PluginInstallerArguments> getArgumentClass() {
        return PluginInstallerArguments.class;
    }

    @Nonnull
    protected String getVersion() {
        String result = Version.getVersion();
        assert (result != null);
        return result;
    }

    @Nonnull
    protected List<Resource> getAdditionalSpringResources() {
        return CollectionSupport.singletonList((Object)new ClassPathResource("net/shibboleth/idp/conf/http-client.xml"));
    }

    @Nonnull
    private List<URL> ensureUpdateURLs() {
        List result = this.updateURLs;
        if (result == null) {
            this.updateURLs = result = CollectionSupport.emptyList();
        }
        return result;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int doRun(@Nonnull PluginInstallerArguments args) {
        if (args.getHttpClientName() == null) {
            args.setHttpClientName("shibboleth.InternalHttpClient");
        }
        if ((ret = super.doRun((AbstractIdPHomeAwareCommandLineArguments)args)) != 0) {
            return ret;
        }
        Constraint.isTrue((boolean)(this.getHttpClient() != null), (String)"no HttpClient supplied");
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        if (args.getUpdateURL() != null) {
            try {
                this.updateURLs = CollectionSupport.singletonList((Object)new URL(args.getUpdateURL()));
            }
            catch (MalformedURLException e) {
                this.getLogger().error("Could not convert update URL {}", (Object)args.getUpdateURL(), (Object)e);
                return 1;
            }
        }
        doList = false;
        try {
            inst = new PluginInstaller((HttpClient)Constraint.isNotNull((Object)this.getHttpClient(), (String)"HJttpClient cannot be non null (by construction"));
            try {
                this.constructPluginInstaller(inst, args);
                if (!PluginInstallerCLI.$assertionsDisabled && inst != this.installer) {
                    throw new AssertionError();
                }
                pluginId = args.getPluginId();
                switch (1.$SwitchMap$net$shibboleth$idp$installer$plugin$impl$PluginInstallerArguments$OperationType[args.getOperation().ordinal()]) {
                    case 1: {
                        if (args.isListAvailable()) {
                            var6_12 = this.doListAvailable();
                            return var6_12;
                        }
                        ret = this.doList(args.isFullList(), args.getPluginId());
                        ** break;
lbl32:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        if (pluginId != null) {
                            inst.setPluginId(pluginId);
                        }
                        inst.installPlugin(args.getInputDirectory(), args.getInputFileName(), args.isNoCheck() == false);
                        doList = true;
                        ** break;
lbl39:
                        // 1 sources

                        break;
                    }
                    case 3: {
                        if (pluginId != null) {
                            inst.setPluginId(pluginId);
                        }
                        if (args.isInstallId()) {
                            if (!PluginInstallerCLI.$assertionsDisabled && pluginId == null) {
                                throw new AssertionError();
                            }
                            var6_13 = this.autoPluginFromId(pluginId, args.isNoCheck() == false);
                            return var6_13;
                        }
                        inst.installPlugin(args.getInputURL(), args.getInputFileName(), args.isNoCheck() == false);
                        doList = true;
                        ** break;
lbl51:
                        // 1 sources

                        break;
                    }
                    case 4: {
                        if (!PluginInstallerCLI.$assertionsDisabled && pluginId == null) {
                            throw new AssertionError();
                        }
                        doList = this.doUpdate(pluginId, args.getUpdateVersion(), args.isNoCheck() == false);
                        ** break;
lbl57:
                        // 1 sources

                        break;
                    }
                    case 5: {
                        if (!PluginInstallerCLI.$assertionsDisabled && pluginId == null) {
                            throw new AssertionError();
                        }
                        inst.setPluginId(pluginId);
                        inst.uninstall();
                        doList = true;
                        ** break;
lbl65:
                        // 1 sources

                        break;
                    }
                    case 6: {
                        if (!PluginInstallerCLI.$assertionsDisabled && pluginId == null) {
                            throw new AssertionError();
                        }
                        this.outputLicense(pluginId);
                        ** break;
lbl71:
                        // 1 sources

                        break;
                    }
                    case 7: {
                        if (!PluginInstallerCLI.$assertionsDisabled && pluginId == null) {
                            throw new AssertionError();
                        }
                        inst.setPluginId(pluginId);
                        this.doContentList(pluginId);
                        ** break;
lbl78:
                        // 1 sources

                        break;
                    }
                    default: {
                        this.getLogger().error("Invalid operation");
                        var6_14 = 1;
                        return var6_14;
                    }
                }
            }
            finally {
                inst.close();
            }
        }
        catch (BeansException e) {
            this.getLogger().error("Plugin Install failed", (Throwable)e);
            return 1;
        }
        catch (ComponentInitializationException | BuildException e) {
            this.getLogger().error("Plugin Install failed:", e);
            return 2;
        }
        if (doList == false) return ret;
        try {
            inst = new PluginInstaller((HttpClient)Constraint.isNotNull((Object)this.getHttpClient(), (String)"HJttpClient cannot be non null (by construction"));
            try {
                this.constructPluginInstaller(inst, args);
                ret = this.doList(false, null);
                return ret;
            }
            finally {
                inst.close();
            }
        }
        catch (ComponentInitializationException e) {
            this.getLogger().error("Post Install list failed:", (Throwable)e);
            return 2;
        }
    }

    private void constructPluginInstaller(PluginInstaller inst, PluginInstallerArguments args) throws ComponentInitializationException {
        Path idpHome = Path.of(this.getApplicationContext().getEnvironment().getProperty("idp.home"), new String[0]);
        assert (idpHome != null);
        inst.setIdpHome(idpHome);
        if (!args.isUnattended()) {
            inst.setAcceptKey(new InstallerSupport.InstallerQuery("Accept this key"));
        }
        inst.setTrustore(args.getTruststore());
        HttpClient client = this.getHttpClient();
        assert (client != null);
        inst.setModuleContextSecurityParams(this.getHttpClientSecurityParameters());
        inst.setUpdateOverrideURLs(this.ensureUpdateURLs());
        inst.setRebuildWar(args.isRebuild());
        inst.initialize();
        this.installer = inst;
    }

    private void outOrLog(String message) {
        if (System.out != null) {
            System.out.println(message);
        } else {
            this.getLogger().info("{}", (Object)message);
        }
    }

    private void printDetails(IdPPlugin plugin) {
        this.getLogger().debug("Interrogating {}", (Object)plugin.getPluginId());
        PluginState state = new PluginState(plugin, this.ensureUpdateURLs());
        HttpClient client = this.getHttpClient();
        if (client != null) {
            state.setHttpClient(client);
            state.setHttpClientSecurityParameters(this.getHttpClientSecurityParameters());
        }
        try {
            state.initialize();
        }
        catch (ComponentInitializationException e) {
            this.getLogger().error("Could not interrogate plugin {}", (Object)plugin.getPluginId(), (Object)e);
            return;
        }
        Map versionMap = state.getPluginInfo().getAvailableVersions();
        ArrayList versionList = new ArrayList(versionMap.keySet());
        versionList.sort(null);
        this.outOrLog("\tPlugin Versions ");
        for (InstallableComponentVersion version : versionList) {
            assert (version != null);
            String downLoadDetails = state.getPluginInfo().getUpdateBaseName(version) == null || state.getPluginInfo().getUpdateURL(version) == null ? " - No download available" : "";
            InstallableComponentInfo.VersionInfo info = (InstallableComponentInfo.VersionInfo)versionMap.get(version);
            this.outOrLog(String.format("\t%s:\tMin=%s\tMax=%s\tSupport level: %s%s", version, info.getMinSupported(), info.getMaxSupported(), info.getSupportLevel(), downLoadDetails));
        }
    }

    private void outputLicense(@Nonnull String pluginId) {
        assert (this.installer != null);
        IdPPlugin plugin = this.installer.getInstalledPlugin(pluginId);
        if (plugin == null) {
            this.getLogger().error("Plugin {} not installed", (Object)pluginId);
            return;
        }
        String location = plugin.getLicenseFileLocation();
        if (location == null) {
            this.getLogger().info("Plugin {} has no license", (Object)pluginId);
            return;
        }
        try (InputStream is = plugin.getClass().getResourceAsStream(location);){
            if (is == null) {
                this.getLogger().error("Plugin {} license could not be found at {}", (Object)pluginId, (Object)location);
                return;
            }
            this.outOrLog(String.format("License for %s", plugin));
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                String line = reader.readLine();
                while (line != null) {
                    this.outOrLog(line);
                    line = reader.readLine();
                }
            }
        }
        catch (IOException e) {
            this.getLogger().error("Failed to output license", (Throwable)e);
        }
    }

    private int doList(boolean fullList, @Nullable String pluginId) {
        boolean list = false;
        PluginInstaller inst = this.installer;
        assert (inst != null);
        int result = 0;
        List<IdPPlugin> plugins = inst.getInstalledPlugins();
        Set<String> modules = inst.getLoadedModules();
        for (IdPPlugin plugin : plugins) {
            if (pluginId != null && !pluginId.equals(plugin.getPluginId())) continue;
            list = true;
            this.outOrLog(String.format("Plugin: %-22s\tCurrent Version: %d.%d.%d", plugin.getPluginId(), plugin.getMajorVersion(), plugin.getMinorVersion(), plugin.getPatchVersion()));
            for (String module : plugin.getRequiredModules()) {
                if (modules.contains(module)) continue;
                this.getLogger().error("Plugin {} requires non-enabled module {}", (Object)plugin.getPluginId(), (Object)module);
                result = 3;
            }
            if (!fullList) continue;
            this.printDetails(plugin);
        }
        if (!list) {
            if (pluginId == null) {
                this.outOrLog("No plugins installed");
            } else {
                this.outOrLog("Plugin " + pluginId + " not installed");
            }
        }
        return result;
    }

    private void doContentList(@Nonnull String pluginId) {
        PluginInstaller inst = this.installer;
        assert (inst != null);
        IdPPlugin thePlugin = inst.getInstalledPlugin(pluginId);
        String fromContentsVersion = inst.getVersionFromContents();
        List<Path> contents = inst.getInstalledContents();
        if (thePlugin == null) {
            this.getLogger().warn("Plugin was not installed {}", (Object)pluginId);
            if (fromContentsVersion != null) {
                this.getLogger().error("Plugin {} not installed, but contents found", (Object)pluginId);
                this.getLogger().debug("{}", contents);
            }
            return;
        }
        if (fromContentsVersion == null) {
            this.getLogger().error("Plugin {} found, but no contents listed", (Object)pluginId);
            return;
        }
        String installedVersion = new InstallableComponentVersion((Plugin)thePlugin).toString();
        if (!fromContentsVersion.equals(installedVersion)) {
            this.getLogger().error("Installed version of Plugin {} ({}) does not match contents ({})", new Object[]{pluginId, installedVersion, fromContentsVersion});
        }
        if (contents.isEmpty()) {
            this.getLogger().info("No contents");
        } else {
            for (Path path : contents) {
                this.outOrLog(String.format("%s", path.toString()));
            }
        }
    }

    @Nonnull
    private InstallableComponentVersion getIdPVersion() {
        InstallableComponentVersion ver = this.determinedIdpVersion;
        if (ver == null) {
            String idpVersionString = Version.getVersion();
            if (idpVersionString != null) {
                this.determinedIdpVersion = ver = new InstallableComponentVersion(idpVersionString);
            } else {
                this.getLogger().error("Could not locate IdP Version, assuming 5.0.0");
                this.determinedIdpVersion = ver = new InstallableComponentVersion(5, 0, 0);
            }
        }
        return ver;
    }

    @Nullable
    public InstallableComponentVersion getBestVersion(@Nonnull InstallableComponentVersion pluginVersion, @Nonnull InstallableComponentInfo pluginInfo) {
        return InstallableComponentSupport.getBestVersion((InstallableComponentVersion)this.getIdPVersion(), (InstallableComponentVersion)pluginVersion, (InstallableComponentInfo)pluginInfo);
    }

    private int doListAvailable() {
        HttpClient client = this.getHttpClient();
        assert (client != null);
        Properties props = this.loadAllPluginInfo();
        if (props == null) {
            return 2;
        }
        HashMap<String, PluginInfo> plugins = new HashMap<String, PluginInfo>();
        Enumeration<Object> en = props.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (!key.endsWith(".versions")) continue;
            String pluginId = key.substring(0, key.length() - 9);
            assert (pluginId != null);
            PluginInfo info = new PluginInfo(pluginId, props);
            if (!info.isInfoComplete()) continue;
            plugins.put(pluginId, info);
        }
        for (Map.Entry entry : plugins.entrySet()) {
            InstallableComponentVersion nullVersion = new InstallableComponentVersion(0, 0, 0);
            String key = (String)entry.getKey();
            InstallableComponentInfo value = (InstallableComponentInfo)entry.getValue();
            assert (key != null && value != null);
            assert (this.installer != null);
            IdPPlugin existingPlugin = this.installer.getInstalledPlugin(key);
            if (existingPlugin == null) {
                InstallableComponentVersion version = this.getBestVersion(nullVersion, value);
                if (version == null) {
                    this.getLogger().debug("No Version of Plugin {} is available for install with IdP", entry.getKey(), (Object)this.getIdPVersion());
                    continue;
                }
                this.outOrLog(String.format("Plugin %s: version %s available for install", entry.getKey(), version));
                continue;
            }
            InstallableComponentVersion existingVersion = new InstallableComponentVersion((Plugin)existingPlugin);
            InstallableComponentVersion version = this.getBestVersion(existingVersion, value);
            if (version == null) {
                this.outOrLog(String.format("Plugin %s: Installed version %s: No update available", entry.getKey(), existingVersion));
                continue;
            }
            this.outOrLog(String.format("Plugin %s: Installed version %s: Update to %s available", entry.getKey(), existingVersion, version));
        }
        return 0;
    }

    private int autoPluginFromId(@Nonnull String pluginId, boolean checkVersion) {
        PluginInstaller inst = this.installer;
        assert (inst != null);
        IdPPlugin existing = inst.getInstalledPlugin(pluginId);
        if (existing != null) {
            this.getLogger().error("Plugin {} is already installed", (Object)pluginId);
            return 1;
        }
        Properties props = this.loadAllPluginInfo();
        if (props == null) {
            this.getLogger().error("Auto-install not possible");
            return 1;
        }
        PluginInfo info = new PluginInfo(pluginId, props);
        if (!info.isInfoComplete()) {
            this.getLogger().error("Plugin {}: Information not found", (Object)pluginId);
            return 1;
        }
        InstallableComponentVersion versionToInstall = this.getBestVersion(new InstallableComponentVersion(0, 0, 0), (InstallableComponentInfo)info);
        if (versionToInstall == null) {
            this.getLogger().error("Plugin {}: No plugin version available to install on IdP {}", (Object)pluginId, (Object)this.getIdPVersion());
            return 1;
        }
        URL updateURL = info.getUpdateURL(versionToInstall);
        assert (updateURL != null);
        inst.installPlugin(updateURL, info.getUpdateBaseName(versionToInstall) + ".tar.gz", checkVersion);
        return 0;
    }

    private Properties loadAllPluginInfo() {
        HttpClient client = this.getHttpClient();
        assert (client != null);
        if (this.ensureUpdateURLs().isEmpty()) {
            try {
                return InstallableComponentSupport.loadInfo((List)CollectionSupport.listOf((Object)new URL("https://shibboleth.net/downloads/identity-provider/plugins/plugins.properties"), (Object)new URL("http://plugins.shibboleth.net/plugins.properties")), (HttpClient)client, (HttpClientSecurityParameters)this.getHttpClientSecurityParameters());
            }
            catch (MalformedURLException e) {
                this.getLogger().error("Could not contruct URL list");
                return new Properties();
            }
        }
        return InstallableComponentSupport.loadInfo(this.ensureUpdateURLs(), (HttpClient)client, (HttpClientSecurityParameters)this.getHttpClientSecurityParameters());
    }

    private boolean doUpdate(@Nonnull String pluginId, @Nullable InstallableComponentVersion pluginVersion, boolean checkVersion) {
        InstallableComponentVersion installVersion;
        PluginInstaller inst = this.installer;
        assert (inst != null);
        IdPPlugin plugin = inst.getInstalledPlugin(pluginId);
        if (plugin == null) {
            this.getLogger().error("Plugin {} was not installed", (Object)pluginId);
            return false;
        }
        this.getLogger().debug("Interrogating {} ", (Object)plugin.getPluginId());
        PluginState state = new PluginState(plugin, this.ensureUpdateURLs());
        HttpClient client = this.getHttpClient();
        if (client != null) {
            state.setHttpClient(client);
            state.setHttpClientSecurityParameters(this.getHttpClientSecurityParameters());
        }
        try {
            state.initialize();
        }
        catch (ComponentInitializationException e) {
            this.getLogger().error("Could not interrogate plugin {}", (Object)plugin.getPluginId(), (Object)e);
            return false;
        }
        if (pluginVersion == null) {
            installVersion = this.getBestVersion(new InstallableComponentVersion((Plugin)plugin), state.getPluginInfo());
            if (installVersion == null) {
                this.getLogger().info("No suitable update version for plugin {} available for IdP {}", (Object)pluginId, (Object)this.getIdPVersion());
                return false;
            }
        } else {
            installVersion = pluginVersion;
            Map versions = state.getPluginInfo().getAvailableVersions();
            if (!versions.containsKey(installVersion)) {
                this.getLogger().error("Specified version {} of plugin {} could not be found. Available versions: {}", new Object[]{installVersion, pluginId, versions.keySet()});
                return false;
            }
        }
        URL updateURL = state.getPluginInfo().getUpdateURL(installVersion);
        assert (updateURL != null);
        inst.installPlugin(updateURL, state.getPluginInfo().getUpdateBaseName(installVersion) + ".tar.gz", checkVersion);
        return true;
    }

    public static int runMain(@Nonnull String[] args) {
        PluginInstallerCLI cli = new PluginInstallerCLI();
        return cli.run(args);
    }

    public static void main(@Nonnull String[] args) {
        System.exit(PluginInstallerCLI.runMain(args));
    }
}

