/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.installer.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.primitive.StringSupport;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.input.InputRequest;
import org.slf4j.Logger;

public class InstallerProperties {
    @Nonnull
    @NotEmpty
    public static final String PROPERTY_SOURCE_FILE = "idp.property.file";
    @Nonnull
    @NotEmpty
    public static final String IDP_PROPERTIES_MERGE = "idp.merge.properties";
    @Nonnull
    @NotEmpty
    public static final String LDAP_PROPERTIES_MERGE = "ldap.merge.properties";
    @Nonnull
    @NotEmpty
    public static final String LDAP_PASSWORD = "idp.LDAP.credential";
    @Nonnull
    @NotEmpty
    public static final String TARGET_DIR = "idp.target.dir";
    @Nonnull
    @NotEmpty
    public static final String ENTITY_ID = "idp.entityID";
    @Nonnull
    @NotEmpty
    public static final String NO_PROMPT = "idp.noprompt";
    @Nonnull
    @NotEmpty
    public static final String HOST_NAME = "idp.host.name";
    @Nonnull
    @NotEmpty
    public static final String SCOPE = "idp.scope";
    @Nonnull
    @NotEmpty
    public static final String KEY_STORE_PASSWORD = "idp.keystore.password";
    @Nonnull
    @NotEmpty
    public static final String SEALER_PASSWORD = "idp.sealer.password";
    @Nonnull
    @NotEmpty
    public static final String SEALER_ALIAS = "idp.sealer.alias";
    @Nonnull
    @NotEmpty
    public static final String SEALER_KEYSIZE = "idp.sealer.keysize";
    @Nonnull
    @NotEmpty
    public static final String KEY_SIZE = "idp.keysize";
    @Nonnull
    @NotEmpty
    public static final String MODE_CREDENTIAL_KEYS = "idp.conf.credentials.filemode";
    @Nonnull
    @NotEmpty
    public static final String GROUP_CONF_CREDENTIALS = "idp.conf.credentials.group";
    @Nonnull
    @NotEmpty
    public static final String PERFORM_SET_MODE = "idp.conf.setmode";
    @Nonnull
    @NotEmpty
    public static final String NO_TIDY = "idp.no.tidy";
    @Nonnull
    @NotEmpty
    public static final String INITIAL_INSTALL_MODULES = "idp.initial.modules";
    public static final int DEFAULT_KEY_SIZE = 3072;
    @Nonnull
    public static final Set<String> CORE_MODULES = CollectionSupport.setOf((Object[])new String[]{"idp.Core", "idp.EditWebApp", "idp.CommandLine"});
    @Nonnull
    public static final Set<String> DEFAULT_MODULES = CollectionSupport.setOf((Object)"idp.authn.Password", (Object)"idp.admin.Hello");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InstallerProperties.class);
    @NonnullAfterInit
    private Properties installerProperties;
    @Nullable
    private Path targetDir;
    @Nonnull
    private final Path srcDir;
    private boolean noPrompt;
    @Nullable
    private String entityID;
    @Nullable
    private String hostname;
    @Nullable
    private String scope;
    @Nullable
    private String keyStorePassword;
    @Nullable
    private String sealerPassword;
    @Nullable
    private String sealerAlias;
    private int keySize;
    private boolean tidy = true;
    private boolean setGroupAndMode = true;
    @Nullable
    private String credentialsKeyFileMode;
    @Nonnull
    private final InputHandler inputHandler;

    public InstallerProperties(@Nonnull Path sourceDir) {
        this.srcDir = sourceDir;
        this.inputHandler = this.getInputHandler();
    }

    @Nonnull
    protected InputHandler getInputHandler() {
        return new DefaultInputHandler(){

            protected String getPrompt(InputRequest request) {
                return super.getPrompt(request) + " ? ";
            }
        };
    }

    protected void doInitialize() throws ComponentInitializationException {
        String value;
        String noTidy;
        this.installerProperties = new Properties(System.getProperties());
        if (!Files.exists(this.srcDir, new LinkOption[0])) {
            this.log.error("Source dir {} did not exist", (Object)this.srcDir.toAbsolutePath());
            throw new ComponentInitializationException(this.srcDir.toString() + " must exist");
        }
        this.log.debug("Source dir {}", (Object)this.srcDir);
        Path propertyFile = this.getMergeFile(PROPERTY_SOURCE_FILE);
        if (propertyFile != null) {
            File idpPropertyFile = propertyFile.toFile();
            try (FileInputStream stream = new FileInputStream(idpPropertyFile);){
                this.installerProperties.load(stream);
            }
            catch (IOException e) {
                this.log.error("Could not load {}: {}", (Object)propertyFile.toAbsolutePath(), (Object)e.getMessage());
                throw new ComponentInitializationException((Exception)e);
            }
            if (!this.isNoTidy()) {
                idpPropertyFile.deleteOnExit();
            }
        }
        this.tidy = (noTidy = this.installerProperties.getProperty(NO_TIDY)) == null;
        String setModeString = this.installerProperties.getProperty(PERFORM_SET_MODE);
        if (setModeString != null) {
            this.setGroupAndMode = Boolean.valueOf(setModeString);
        }
        this.noPrompt = (value = this.installerProperties.getProperty(NO_PROMPT)) != null;
        value = this.installerProperties.getProperty(KEY_SIZE);
        this.keySize = value == null ? 3072 : Integer.parseInt(value);
    }

    @Nonnull
    protected String getValue(String propertyName, String prompt, NonnullSupplier<String> defaultSupplier) throws BuildException {
        String value = this.installerProperties.getProperty(propertyName);
        if (value != null) {
            return value;
        }
        if (this.noPrompt) {
            throw new BuildException("No value for " + propertyName + " specified");
        }
        InputRequest request = new InputRequest(prompt);
        String defaultValue = (String)defaultSupplier.get();
        request.setDefaultValue(defaultValue);
        this.inputHandler.handleInput(request);
        value = request.getInput();
        if (value == null || "".contentEquals(value)) {
            return defaultValue;
        }
        return value;
    }

    @Nonnull
    protected String getPassword(String propertyName, String prompt) throws BuildException {
        String value = this.installerProperties.getProperty(propertyName);
        if (value != null) {
            return value;
        }
        try {
            byte[] key = new byte[32];
            SecureRandom.getInstance("SHA1PRNG").nextBytes(key);
            String s = Base64Support.encode((byte[])key, (boolean)false).substring(0, 32);
            assert (s != null);
            return s;
        }
        catch (NoSuchAlgorithmException | EncodingException e) {
            this.log.error("Password Generation failed", e);
            throw new BuildException("Password Generation failed", e);
        }
    }

    @Nonnull
    public Path getTargetDir() throws BuildException {
        if (this.targetDir != null) {
            return this.targetDir;
        }
        Path td = this.targetDir = Path.of(this.getValue(TARGET_DIR, "Installation Directory:", (NonnullSupplier<String>)((NonnullSupplier)() -> "/opt/shibboleth-idp")), new String[0]);
        assert (td != null);
        return td;
    }

    @Nonnull
    public Path getSourceDir() {
        return this.srcDir;
    }

    @Nonnull
    public String getEntityID() {
        String result = this.entityID;
        if (result == null) {
            this.entityID = result = this.getValue(ENTITY_ID, "SAML EntityID:", (NonnullSupplier<String>)((NonnullSupplier)() -> "https://" + this.getHostName() + "/idp/shibboleth"));
        }
        return result;
    }

    public boolean isNoTidy() {
        return !this.tidy;
    }

    private boolean hasHostName(InetAddress addr) {
        return !addr.getHostAddress().equals(addr.getCanonicalHostName());
    }

    @Nonnull
    private String bestHostName() {
        InetAddress bestSoFar = null;
        try {
            for (NetworkInterface netInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                for (InetAddress address : Collections.list(netInterface.getInetAddresses())) {
                    if (bestSoFar == null) {
                        bestSoFar = address;
                        continue;
                    }
                    if (address == null || address.isLoopbackAddress()) continue;
                    if (address.isLinkLocalAddress()) {
                        if (!bestSoFar.isLoopbackAddress()) continue;
                        bestSoFar = address;
                        continue;
                    }
                    if (address.isSiteLocalAddress()) {
                        if (!bestSoFar.isLoopbackAddress() && !bestSoFar.isLinkLocalAddress() && (!bestSoFar.isSiteLocalAddress() || this.hasHostName(bestSoFar))) continue;
                        bestSoFar = address;
                        continue;
                    }
                    if (!bestSoFar.isLoopbackAddress() && !bestSoFar.isLinkLocalAddress() && !bestSoFar.isSiteLocalAddress() && this.hasHostName(bestSoFar)) continue;
                    bestSoFar = address;
                }
            }
        }
        catch (SocketException e) {
            this.log.error("Could not get host information", (Throwable)e);
        }
        if (bestSoFar == null) {
            return "localhost.localdomain";
        }
        String result = bestSoFar.getCanonicalHostName();
        assert (result != null);
        return result;
    }

    @Nonnull
    public String getHostName() {
        String result = this.hostname;
        if (result == null) {
            result = this.hostname = this.getValue(HOST_NAME, "Host Name:", (NonnullSupplier<String>)((NonnullSupplier)() -> this.bestHostName()));
        }
        return result;
    }

    @Nonnull
    public String getCredentialsKeyFileMode() {
        String result = this.credentialsKeyFileMode;
        if (result != null) {
            return result;
        }
        result = this.credentialsKeyFileMode = this.installerProperties.getProperty(MODE_CREDENTIAL_KEYS, "600");
        assert (result != null);
        return result;
    }

    @Nullable
    public String getCredentialsGroup() {
        return this.installerProperties.getProperty(GROUP_CONF_CREDENTIALS);
    }

    public boolean isSetGroupAndMode() {
        return this.setGroupAndMode;
    }

    @Nonnull
    protected String defaultScope() {
        String host = this.getHostName();
        int index = host.indexOf(46);
        if (index > 1) {
            String result = host.substring(index + 1);
            assert (result != null);
            return result;
        }
        return "localdomain";
    }

    @Nonnull
    public String getScope() {
        String result = this.scope;
        if (result == null) {
            result = this.scope = this.getValue(SCOPE, "Attribute Scope:", (NonnullSupplier<String>)((NonnullSupplier)() -> this.defaultScope()));
        }
        return result;
    }

    @Nullable
    public String getLDAPPassword() throws BuildException {
        return this.installerProperties.getProperty(LDAP_PASSWORD);
    }

    @Nonnull
    public String getSubjectAltName() {
        return "https://" + this.getHostName() + "/idp/shibboleth";
    }

    @Nonnull
    public String getKeyStorePassword() {
        String result = this.keyStorePassword;
        if (this.keyStorePassword == null) {
            result = this.keyStorePassword = this.getPassword(KEY_STORE_PASSWORD, "Backchannel PKCS12 Password:");
        }
        assert (result != null);
        return result;
    }

    @Nonnull
    public String getSealerPassword() {
        String result = this.sealerPassword;
        if (result == null) {
            result = this.sealerPassword = this.getPassword(SEALER_PASSWORD, "Cookie Encryption Key Password:");
        }
        return result;
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public Set<String> getModulesToEnable() {
        String prop = StringSupport.trimOrNull((String)this.installerProperties.getProperty(INITIAL_INSTALL_MODULES));
        if (prop == null) {
            return DEFAULT_MODULES;
        }
        boolean additive = prop.startsWith("+");
        if (additive) {
            prop = prop.substring(1);
        }
        Object[] modules = prop.split(",");
        assert (modules != null);
        if (!additive) {
            Set result = CollectionSupport.copyToSet((Collection)CollectionSupport.arrayAsList((Object[])modules));
            return result;
        }
        HashSet<Object> result = new HashSet<Object>(modules.length + DEFAULT_MODULES.size());
        result.addAll(DEFAULT_MODULES);
        result.addAll(Arrays.asList(modules));
        return CollectionSupport.copyToSet(result);
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public Set<String> getCoreModules() {
        return CORE_MODULES;
    }

    @Nullable
    Integer getSealerKeySize() throws BuildException {
        Integer result;
        String val = this.installerProperties.getProperty(SEALER_KEYSIZE);
        if (val == null) {
            return null;
        }
        try {
            result = Integer.valueOf(val);
        }
        catch (NumberFormatException e) {
            this.log.error("Provided value for property {} ({}') was not an integer", (Object)SEALER_ALIAS, (Object)val);
            throw new BuildException((Throwable)e);
        }
        return result;
    }

    @Nonnull
    public String getSealerAlias() {
        String result = this.sealerAlias;
        if (result == null) {
            result = this.sealerAlias = this.installerProperties.getProperty(SEALER_ALIAS);
        }
        if (result == null) {
            this.sealerAlias = "secret";
            result = "secret";
        }
        return result;
    }

    public int getKeySize() {
        return this.keySize;
    }

    @Nullable
    protected Path getMergeFile(String propName) throws BuildException {
        String propValue = this.installerProperties.getProperty(propName);
        if (propValue == null) {
            return null;
        }
        Path path = Path.of(propValue, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            this.log.debug("Property '{}' had value '{}' Path exists ", (Object)propName, (Object)propValue);
        } else {
            if (!Files.exists(path = this.srcDir.resolve(path), new LinkOption[0])) {
                this.log.debug("Property '{}' had value '{}' neither '{}' nor '{}' exist", new Object[]{propName, propValue, path});
                this.log.error("Path '{}' supplied for '{}' does not exist", (Object)propValue, (Object)propName);
                throw new BuildException("Property file not found");
            }
            this.log.debug("Property '{}' had value '{}' Path {} exists ", new Object[]{propName, propValue, path});
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            this.log.error("Path '{}' supplied by property '{}' was not a file", (Object)path, (Object)propName);
            throw new BuildException("No a file");
        }
        return path;
    }

    @Nullable
    public Path getIdPMergeProperties() throws BuildException {
        return this.getMergeFile(IDP_PROPERTIES_MERGE);
    }

    @Nullable
    public Path getLDAPMergeProperties() throws BuildException {
        return this.getMergeFile(LDAP_PROPERTIES_MERGE);
    }
}

