/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.installer.impl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import net.shibboleth.idp.installer.InstallerSupport;
import net.shibboleth.idp.installer.impl.InstallerProperties;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Copy;
import org.slf4j.Logger;

public final class CopyDistribution {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CopyDistribution.class);
    @Nonnull
    private final InstallerProperties installerProps;

    public CopyDistribution(@Nonnull InstallerProperties props) {
        this.installerProps = props;
    }

    public void execute() throws BuildException {
        this.deleteOld();
        this.copyDist();
        this.copyBinDoc();
    }

    private void delete(Path what, String excludes) {
        if (!Files.exists(what, new LinkOption[0])) {
            this.log.debug("{} doesn't exist, nothing to delete", (Object)what);
        } else {
            if (!Files.isDirectory(what, new LinkOption[0])) {
                this.log.error("Corrupt install: {} is not a directory", (Object)what);
                throw new BuildException("Corrupt install - not a directory");
            }
            this.log.debug("Deleting {} ", (Object)what);
            InstallerSupport.deleteTree(what, excludes);
        }
    }

    protected void deleteOld() {
        this.delete(this.installerProps.getTargetDir().resolve("bin").resolve("lib"), null);
        this.delete(this.installerProps.getTargetDir().resolve("dist"), "plugin-webapp/** plugin-contents/**");
        this.delete(this.installerProps.getTargetDir().resolve("doc"), null);
        Path system = this.installerProps.getTargetDir().resolve("system");
        assert (system != null);
        if (Files.exists(system, new LinkOption[0])) {
            assert (system != null);
            InstallerSupport.setReadOnly(system, false);
            this.delete(system, null);
        }
    }

    private void distCopy(@Nonnull Path srcDist, @Nonnull Path dist, @Nonnull String to, boolean overwrite) throws BuildException {
        Path toPath = dist.resolve(to);
        Path fromPath = srcDist.resolve(to);
        this.log.debug("Copying distribution from {} to {}", (Object)fromPath, (Object)toPath);
        assert (fromPath != null && toPath != null);
        Copy copy = InstallerSupport.getCopyTask(fromPath, toPath);
        copy.setOverwrite(overwrite);
        copy.execute();
    }

    private void distCopy(@Nonnull Path srcDist, @Nonnull Path dist, @Nonnull String to) throws BuildException {
        this.distCopy(srcDist, dist, to, false);
    }

    protected void copyDist() {
        Path dist = this.installerProps.getTargetDir().resolve("dist");
        assert (dist != null);
        InstallerSupport.createDirectory(dist);
        File donottouch = dist.resolve("DONOTTOUCH").toFile();
        try (FileWriter w = new FileWriter(donottouch);){
            w.write("\t\tWARNING\n\nContent of this folder is controlled by the install programs\nIf you add, delete or modify any file inside this directory\nor its subdirectories you will find that things stop working\nat some future date.\n");
        }
        catch (IOException e) {
            this.log.error("Could not write {}, continuing", (Object)donottouch, (Object)e);
        }
        Path src = this.installerProps.getSourceDir();
        if (!Files.exists(src, new LinkOption[0])) {
            this.log.error("Source distribution {} not found.", (Object)src);
            throw new BuildException("Source distribution not found");
        }
        this.distCopy(src, dist, "webapp");
    }

    protected void copyBinDoc() {
        Path fromPath = this.installerProps.getSourceDir().resolve("bin").resolve("lib");
        Path toPath = this.installerProps.getTargetDir().resolve("dist").resolve("binlib");
        assert (fromPath != null && toPath != null);
        this.log.debug("Copying distribution from {} to {}", (Object)fromPath, (Object)toPath);
        Copy copy = InstallerSupport.getCopyTask(fromPath, toPath);
        copy.setOverwrite(false);
        copy.execute();
    }
}

