/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid;

import com.google.common.base.Strings;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.NameIDPolicy;

public class AbstractSAML2NameIDGenerator
extends org.opensaml.saml.saml2.profile.AbstractSAML2NameIDGenerator {
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, AuthnRequest> requestLookupStrategy = new MessageLookup(AuthnRequest.class).compose((Function)new InboundMessageContextLookup());

    public AbstractSAML2NameIDGenerator() {
        this.relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    }

    public void setRequestLookupStrategy(@Nonnull Function<ProfileRequestContext, AuthnRequest> strategy) {
        this.checkSetterPreconditions();
        this.requestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuthnRequest lookup strategy cannot be null");
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.checkSetterPreconditions();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    @Nullable
    protected String getEffectiveSPNameQualifier(@Nonnull ProfileRequestContext profileRequestContext) {
        BrowserSSOProfileConfiguration sso;
        String qual;
        ProfileConfiguration profileConfiguration;
        String qual2;
        NameIDPolicy policy;
        AuthnRequest request = this.requestLookupStrategy.apply(profileRequestContext);
        if (request != null && (policy = request.getNameIDPolicy()) != null && !Strings.isNullOrEmpty((String)(qual2 = policy.getSPNameQualifier()))) {
            return qual2;
        }
        RelyingPartyContext rpContext = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (rpContext != null && (profileConfiguration = rpContext.getProfileConfig()) instanceof BrowserSSOProfileConfiguration && (qual = (sso = (BrowserSSOProfileConfiguration)profileConfiguration).getSPNameQualifier(profileRequestContext)) != null) {
            return qual;
        }
        return super.getEffectiveSPNameQualifier(profileRequestContext);
    }
}

