/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.impl;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.attribute.resolver.DataConnector;
import net.shibboleth.idp.attribute.resolver.impl.AttributeResolverImpl;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.service.ReloadableServiceGaugeSet;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import org.slf4j.Logger;

public class AttributeResolverServiceGaugeSet
extends ReloadableServiceGaugeSet<AttributeResolver>
implements MetricSet,
MetricFilter {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeResolverServiceGaugeSet.class);

    public AttributeResolverServiceGaugeSet(@Nonnull @ParameterName(name="metricName") @NotEmpty String metricName) {
        super(metricName);
        this.getMetricMap().put(MetricRegistry.name((String)metricName, (String[])new String[]{"success"}), new Gauge<Map<String, Instant>>(){

            public Map<String, Instant> getValue() {
                HashMap<String, Instant> mapBuilder = new HashMap<String, Instant>();
                try (ServiceableComponent component = AttributeResolverServiceGaugeSet.this.getService().getServiceableComponent();){
                    Object resolver = component.getComponent();
                    if (resolver instanceof AttributeResolverImpl) {
                        Collection<DataConnector> connectors = ((AttributeResolverImpl)((Object)resolver)).getDataConnectors().values();
                        for (DataConnector connector : connectors) {
                            if (connector.getLastSuccess() == null) continue;
                            mapBuilder.put(connector.getId(), connector.getLastSuccess());
                        }
                    } else if (resolver instanceof AttributeResolver) {
                        AttributeResolverServiceGaugeSet.this.log.debug("{}: Cannot get Data Connector success  information from unsupported class type {}", (Object)AttributeResolverServiceGaugeSet.this.getLogPrefix(), resolver.getClass());
                    } else {
                        AttributeResolverServiceGaugeSet.this.log.warn("{}: Injected Service was not for an AttributeResolver ({})", (Object)AttributeResolverServiceGaugeSet.this.getLogPrefix(), resolver.getClass());
                    }
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
                return Map.copyOf(mapBuilder);
            }
        });
        this.getMetricMap().put(MetricRegistry.name((String)metricName, (String[])new String[]{"failure"}), new Gauge<Map<String, Instant>>(){

            public Map<String, Instant> getValue() {
                HashMap<String, Instant> mapBuilder = new HashMap<String, Instant>();
                try (ServiceableComponent component = AttributeResolverServiceGaugeSet.this.getService().getServiceableComponent();){
                    Object resolver = component.getComponent();
                    if (resolver instanceof AttributeResolverImpl) {
                        Collection<DataConnector> connectors = ((AttributeResolverImpl)((Object)resolver)).getDataConnectors().values();
                        for (DataConnector connector : connectors) {
                            if (connector.getLastFail() == null) continue;
                            mapBuilder.put(connector.getId(), connector.getLastFail());
                        }
                    } else if (resolver instanceof AttributeResolver) {
                        AttributeResolverServiceGaugeSet.this.log.debug("{}: Cannot get Data Connector failure  information from unsupported class type {}", (Object)AttributeResolverServiceGaugeSet.this.getLogPrefix(), resolver.getClass());
                    } else {
                        AttributeResolverServiceGaugeSet.this.log.warn("{}: Injected Service was not for an AttributeResolver ({})", (Object)AttributeResolverServiceGaugeSet.this.getLogPrefix(), resolver.getClass());
                    }
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
                return Map.copyOf(mapBuilder);
            }
        });
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        try (ServiceableComponent component = this.getService().getServiceableComponent();){
            if (component != null) {
                if (component.getComponent() instanceof AttributeResolver) {
                    return;
                }
                this.log.error("{}: Injected service was not for an AttributeResolver ({})", (Object)this.getLogPrefix(), component.getClass());
                throw new ComponentInitializationException("Injected service was not for an AttributeResolver");
            }
        }
        catch (ServiceException e) {
            this.log.debug("{} : Injected service has not initialized sucessfully yet. Skipping type test", (Object)this.getLogPrefix(), (Object)e);
        }
    }
}

