/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.storage.impl;

import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.DataConnector;
import net.shibboleth.idp.attribute.resolver.NoResultAnErrorResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.dc.ValidationException;
import net.shibboleth.idp.attribute.resolver.dc.Validator;
import net.shibboleth.idp.attribute.resolver.dc.impl.AbstractSearchDataConnector;
import net.shibboleth.idp.attribute.resolver.dc.storage.StorageMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.storage.StorageServiceSearch;
import net.shibboleth.idp.attribute.resolver.dc.storage.impl.SimpleStorageMappingStrategy;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageService;

public class StorageServiceDataConnector
extends AbstractSearchDataConnector<StorageServiceSearch, StorageMappingStrategy> {
    @NonnullAfterInit
    private StorageService storageService;
    @Nullable
    private String generatedAttributeID;
    private boolean noResultAnError;

    public StorageServiceDataConnector() {
        this.setValidator(new Validator(){

            public void validate(@Nonnull DataConnector dataConnector) throws ValidationException {
            }

            public void setThrowValidateError(boolean what) {
            }

            public boolean isThrowValidateError() {
                return false;
            }
        });
    }

    public void setStorageService(@Nonnull StorageService service) {
        this.checkSetterPreconditions();
        this.storageService = (StorageService)Constraint.isNotNull((Object)service, (String)"StorageService cannot be null");
    }

    public void setNoResultAnError(boolean flag) {
        this.checkSetterPreconditions();
        this.noResultAnError = flag;
    }

    @Nullable
    public String getGeneratedAttributeID() {
        return this.generatedAttributeID;
    }

    public void setGeneratedAttributeID(@Nullable String id) {
        this.checkSetterPreconditions();
        this.generatedAttributeID = StringSupport.trimOrNull((String)id);
    }

    @Override
    public void doInitialize() throws ComponentInitializationException {
        try {
            if (this.storageService == null) {
                throw new ComponentInitializationException(this.getLogPrefix() + " StorageService cannot be null");
            }
            if (this.getMappingStrategy() == null) {
                if (this.generatedAttributeID == null) {
                    throw new ComponentInitializationException(this.getLogPrefix() + " No mapping strategy or generated attribute ID set");
                }
                assert (this.generatedAttributeID != null);
                this.setMappingStrategy(new SimpleStorageMappingStrategy(this.generatedAttributeID));
            }
            super.doInitialize();
        }
        catch (Exception e) {
            this.setLastFail(Instant.now());
            throw e;
        }
    }

    @Override
    @Nullable
    protected Map<String, IdPAttribute> retrieveAttributes(@Nonnull StorageServiceSearch executable) throws ResolutionException {
        try {
            assert (this.storageService != null);
            StorageRecord record = executable.execute(this.storageService);
            if (record == null) {
                if (this.noResultAnError) {
                    throw new NoResultAnErrorResolutionException(this.getLogPrefix() + " No record returned");
                }
                return CollectionSupport.emptyMap();
            }
            return ((StorageMappingStrategy)this.getMappingStrategy()).map((Object)record);
        }
        catch (IOException e) {
            throw new ResolutionException(this.getLogPrefix() + " StorageService read failed", (Exception)e);
        }
    }
}

