/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.rdbms.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.DataConnector;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.dc.ValidationException;
import net.shibboleth.idp.attribute.resolver.dc.Validator;
import net.shibboleth.idp.attribute.resolver.dc.impl.AbstractSearchDataConnector;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.ExecutableStatement;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.ResultMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.StringResultMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.impl.DataSourceValidator;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class RDBMSDataConnector
extends AbstractSearchDataConnector<ExecutableStatement, ResultMappingStrategy> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RDBMSDataConnector.class);
    @NonnullAfterInit
    private DataSource dataSource;
    private boolean defaultValidator = true;
    private boolean defaultMappingStrategy = true;

    @NonnullAfterInit
    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(@Nonnull DataSource source) {
        this.checkSetterPreconditions();
        this.dataSource = (DataSource)Constraint.isNotNull((Object)source, (String)"JDBC data source can not be null");
    }

    @Override
    public void setValidator(@Nonnull Validator validator) {
        super.setValidator(validator);
        this.defaultValidator = false;
    }

    @Override
    public void setMappingStrategy(@Nonnull ResultMappingStrategy strategy) {
        super.setMappingStrategy(strategy);
        this.defaultMappingStrategy = false;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        try {
            if (this.dataSource == null) {
                throw new ComponentInitializationException(this.getLogPrefix() + " no data source was configured");
            }
            if (this.defaultValidator) {
                DataSourceValidator validator = new DataSourceValidator();
                super.setValidator(validator);
            }
            if (this.defaultMappingStrategy) {
                super.setMappingStrategy(new StringResultMappingStrategy());
            }
            super.doInitialize();
            boolean throwValidateError = this.getValidator().isThrowValidateError();
            try {
                this.getValidator().setThrowValidateError(true);
                this.getValidator().validate((DataConnector)this);
            }
            catch (ValidationException e) {
                this.setLastFail(Instant.now());
                this.log.error("{} Invalid connector configuration", (Object)this.getLogPrefix(), (Object)e);
                if (this.isFailFastInitialize()) {
                    throw new ComponentInitializationException(this.getLogPrefix() + " Invalid connector configuration", (Exception)((Object)e));
                }
            }
            finally {
                this.getValidator().setThrowValidateError(throwValidateError);
            }
        }
        catch (Exception e) {
            this.setLastFail(Instant.now());
            throw e;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    @Unmodifiable
    @NotLive
    protected Map<String, IdPAttribute> retrieveAttributes(@Nullable ExecutableStatement statement) throws ResolutionException {
        if (statement == null) {
            throw new ResolutionException("Executable statement cannot be null");
        }
        try (Connection connection = this.dataSource.getConnection();){
            Map map;
            block16: {
                assert (connection != null);
                ResultSet queryResult = statement.execute(connection);
                try {
                    this.log.trace("Data connector '{}': search returned {}", (Object)this.getId(), (Object)queryResult);
                    map = ((ResultMappingStrategy)this.getMappingStrategy()).map((Object)queryResult);
                    if (queryResult == null) break block16;
                }
                catch (Throwable throwable) {
                    if (queryResult != null) {
                        try {
                            queryResult.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                queryResult.close();
            }
            return map;
        }
        catch (SQLException e) {
            throw new ResolutionException(this.getLogPrefix() + " Unable to execute SQL query", (Exception)e);
        }
    }
}

