/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.rdbms.impl;

import java.sql.Connection;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import net.shibboleth.idp.attribute.resolver.DataConnector;
import net.shibboleth.idp.attribute.resolver.dc.ValidationException;
import net.shibboleth.idp.attribute.resolver.dc.Validator;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.impl.RDBMSDataConnector;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class DataSourceValidator
implements Validator {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DataSourceValidator.class);
    private boolean throwOnValidateError;

    public void setThrowValidateError(boolean value) {
        this.throwOnValidateError = value;
    }

    public boolean isThrowValidateError() {
        return this.throwOnValidateError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void validate(@Nonnull DataConnector dataConnector) throws ValidationException {
        block21: {
            Connection connection;
            if (!(dataConnector instanceof RDBMSDataConnector)) {
                throw new ValidationException("DataConnector must be of type RDBMSDataConnector");
            }
            DataSource dataSource = ((RDBMSDataConnector)dataConnector).getDataSource();
            if (dataSource == null) {
                this.log.error("No datasource installed");
                if (this.isThrowValidateError()) {
                    throw new ValidationException("Datasource is not set");
                }
            } else {
                block20: {
                    assert (dataSource != null);
                    connection = null;
                    connection = dataSource.getConnection();
                    if (connection != null) break block20;
                    this.log.error("Unable to retrieve connections from configured data source");
                    if (!this.isThrowValidateError()) break block20;
                    throw new ValidationException("Unable to retrieve connections from configured data source");
                }
                try {
                    if (connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                    break block21;
                }
                catch (SQLException e) {
                    this.log.error("Error closing database connection; SQL State: {}, SQL Code: {}", new Object[]{e.getSQLState(), e.getErrorCode(), e});
                }
            }
            break block21;
            catch (SQLException e) {
                block22: {
                    try {
                        if (e.getSQLState() != null) {
                            this.log.error("Datasource validation failed with SQL state: {}, SQL Code: {}", new Object[]{e.getSQLState(), e.getErrorCode(), e});
                        } else {
                            this.log.error("Datasource validation failed", (Throwable)e);
                        }
                        if (!this.isThrowValidateError()) break block22;
                        throw new ValidationException("Invalid connector configuration", (Exception)e);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (connection != null && !connection.isClosed()) {
                                connection.close();
                            }
                        }
                        catch (SQLException e2) {
                            this.log.error("Error closing database connection; SQL State: {}, SQL Code: {}", new Object[]{e2.getSQLState(), e2.getErrorCode(), e2});
                        }
                        throw throwable;
                    }
                }
                try {
                    if (connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                }
                catch (SQLException e3) {
                    this.log.error("Error closing database connection; SQL State: {}, SQL Code: {}", new Object[]{e3.getSQLState(), e3.getErrorCode(), e3});
                }
            }
        }
    }
}

