/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.ldap.impl;

import java.security.GeneralSecurityException;
import java.time.Instant;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.DataConnector;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.dc.ValidationException;
import net.shibboleth.idp.attribute.resolver.dc.Validator;
import net.shibboleth.idp.attribute.resolver.dc.impl.AbstractSearchDataConnector;
import net.shibboleth.idp.attribute.resolver.dc.ldap.ExecutableSearchFilter;
import net.shibboleth.idp.attribute.resolver.dc.ldap.SearchResultMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.ldap.StringAttributeValueMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.ConnectionFactoryValidator;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapException;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchResponse;
import org.ldaptive.ssl.SSLContextInitializer;
import org.ldaptive.ssl.SslConfig;
import org.ldaptive.ssl.X509SSLContextInitializer;
import org.slf4j.Logger;

public class LDAPDataConnector
extends AbstractSearchDataConnector<ExecutableSearchFilter, SearchResultMappingStrategy> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(LDAPDataConnector.class);
    @NonnullAfterInit
    private ConnectionFactory connectionFactory;
    @NonnullAfterInit
    private SearchOperation searchOperation;
    private boolean defaultValidator = true;
    private boolean defaultMappingStrategy = true;

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(@Nonnull ConnectionFactory factory) {
        this.checkSetterPreconditions();
        this.connectionFactory = (ConnectionFactory)Constraint.isNotNull((Object)factory, (String)"LDAP connection factory can not be null");
    }

    public SearchOperation getSearchOperation() {
        return this.searchOperation;
    }

    public void setSearchOperation(@Nonnull SearchOperation operation) {
        this.checkSetterPreconditions();
        this.searchOperation = (SearchOperation)Constraint.isNotNull((Object)operation, (String)"LDAP search operation can not be null");
    }

    @Override
    public void setValidator(@Nonnull Validator validator) {
        super.setValidator(validator);
        this.defaultValidator = false;
    }

    @Override
    public void setMappingStrategy(@Nonnull SearchResultMappingStrategy strategy) {
        super.setMappingStrategy(strategy);
        this.defaultMappingStrategy = false;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        try {
            if (this.connectionFactory == null) {
                throw new ComponentInitializationException(this.getLogPrefix() + " No connection factory was configured");
            }
            if (this.searchOperation == null) {
                throw new ComponentInitializationException(this.getLogPrefix() + " No search executor was configured");
            }
            if (this.defaultValidator) {
                ConnectionFactoryValidator validator = new ConnectionFactoryValidator();
                super.setValidator(validator);
            }
            if (this.defaultMappingStrategy) {
                super.setMappingStrategy(new StringAttributeValueMappingStrategy());
            }
            super.doInitialize();
            boolean throwValidateError = this.getValidator().isThrowValidateError();
            try {
                this.getValidator().setThrowValidateError(true);
                this.getValidator().validate((DataConnector)this);
            }
            catch (ValidationException e) {
                this.log.error("{} Invalid connector configuration", (Object)this.getLogPrefix(), (Object)e);
                this.setLastFail(Instant.now());
                if (this.isFailFastInitialize()) {
                    throw new ComponentInitializationException(this.getLogPrefix() + " Invalid connector configuration", (Exception)((Object)e));
                }
            }
            finally {
                this.getValidator().setThrowValidateError(throwValidateError);
            }
            this.policeForJVMTrust();
        }
        catch (Exception e) {
            this.setLastFail(Instant.now());
            throw e;
        }
    }

    private void policeForJVMTrust() throws ComponentInitializationException {
        try {
            SslConfig sslConfig;
            ConnectionConfig connConfig = this.connectionFactory.getConnectionConfig();
            if ((connConfig.getUseStartTLS() || connConfig.getLdapUrl().toLowerCase().contains("ldaps://")) && (sslConfig = connConfig.getSslConfig()) != null) {
                SSLContextInitializer cxtInit;
                SSLContextInitializer sSLContextInitializer = cxtInit = sslConfig.getCredentialConfig() != null ? sslConfig.getCredentialConfig().createSSLContextInitializer() : null;
                if (cxtInit instanceof X509SSLContextInitializer && ((X509SSLContextInitializer)cxtInit).getTrustCertificates() == null) {
                    throw new ComponentInitializationException(this.getLogPrefix() + ": Use of default JVM trust store not supported");
                }
            }
        }
        catch (GeneralSecurityException e) {
            this.log.debug("{} Failed to inspect TLS implementation", (Object)this.getLogPrefix(), (Object)e);
        }
    }

    @Override
    @Nullable
    @Unmodifiable
    @NotLive
    protected Map<String, IdPAttribute> retrieveAttributes(@Nullable ExecutableSearchFilter filter) throws ResolutionException {
        if (filter == null) {
            throw new ResolutionException(this.getLogPrefix() + " Search filter cannot be null");
        }
        try {
            assert (this.searchOperation != null && this.connectionFactory != null);
            SearchResponse result = filter.execute(this.searchOperation, this.connectionFactory);
            this.log.trace("{} Search returned {}", (Object)this.getLogPrefix(), (Object)result);
            return ((SearchResultMappingStrategy)this.getMappingStrategy()).map((Object)result);
        }
        catch (LdapException e) {
            throw new ResolutionException(this.getLogPrefix() + " Unable to execute LDAP search", (Exception)((Object)e));
        }
    }
}

