/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.impl;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.AbstractDataConnector;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import org.slf4j.Logger;

@ThreadSafe
public class StaticDataConnector
extends AbstractDataConnector {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StaticDataConnector.class);
    @NonnullAfterInit
    private Map<String, IdPAttribute> attributes;

    @NonnullAfterInit
    @Unmodifiable
    @NotLive
    public Map<String, IdPAttribute> getAttributes() {
        return this.attributes;
    }

    public void setValues(@Nonnull Collection<IdPAttribute> newValues) {
        this.checkSetterPreconditions();
        Constraint.isNotNull(newValues, (String)"Values must not be null");
        this.attributes = (Map)((NonnullSupplier)newValues.stream().collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableMap(IdPAttribute::getId, i -> i, CollectionSupport.warningMergeFunction((String)("StaticDataConnector " + this.getId()), (boolean)true))))).get();
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    protected Map<String, IdPAttribute> doDataConnectorResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        this.log.trace("{} Resolved attributes: {}", (Object)this.getLogPrefix(), this.attributes);
        assert (this.attributes != null);
        return this.attributes;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.attributes) {
            throw new ComponentInitializationException(this.getLogPrefix() + " No values set up.");
        }
    }
}

