/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.AbstractDataConnector;
import net.shibboleth.idp.attribute.resolver.PluginDependencySupport;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ad.impl.ScriptedIdPAttributeImpl;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.idp.attribute.resolver.scripted.ResolverScriptContextExtender;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.scripting.AbstractScriptEvaluator;
import net.shibboleth.shared.scripting.EvaluableScript;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ScriptedDataConnector
extends AbstractDataConnector {
    @Nonnull
    public static final String RESULTS_STRING = "connectorResults";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedDataConnector.class);
    @NonnullAfterInit
    private EvaluableScript script;
    @NonnullAfterInit
    private DataConnectorScriptEvaluator scriptEvaluator;
    @Nonnull
    private Collection<ResolverScriptContextExtender> contextExtenders = CollectionSupport.emptyList();
    @Nullable
    private Object customObject;

    @Nullable
    public Object getCustomObject() {
        return this.customObject;
    }

    public void setCustomObject(Object object) {
        this.checkSetterPreconditions();
        this.customObject = object;
    }

    @NonnullAfterInit
    public EvaluableScript getScript() {
        return this.script;
    }

    public void setScript(@Nonnull EvaluableScript definitionScript) {
        this.checkSetterPreconditions();
        this.script = (EvaluableScript)Constraint.isNotNull((Object)definitionScript, (String)"Attribute definition script cannot be null");
    }

    public void setScriptContextExtenders(@Nullable Collection<ResolverScriptContextExtender> extenders) {
        this.checkSetterPreconditions();
        this.contextExtenders = extenders != null ? CollectionSupport.copyToList(extenders) : CollectionSupport.emptyList();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.script) {
            throw new ComponentInitializationException(this.getLogPrefix() + ": No script supplied");
        }
        assert (this.script != null);
        this.scriptEvaluator = new DataConnectorScriptEvaluator(this.script);
        this.scriptEvaluator.setCustomObject(this.customObject);
        this.scriptEvaluator.setContextExtenders(this.contextExtenders);
        this.scriptEvaluator.setLogPrefix(this.getLogPrefix());
    }

    @Nullable
    protected Map<String, IdPAttribute> doDataConnectorResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        Constraint.isNotNull((Object)resolutionContext, (String)"AttributeResolutionContext cannot be null");
        Constraint.isNotNull((Object)workContext, (String)"AttributeResolverWorkContext cannot be null");
        return this.scriptEvaluator.execute(resolutionContext, workContext);
    }

    private class DataConnectorScriptEvaluator
    extends AbstractScriptEvaluator {
        public DataConnectorScriptEvaluator(EvaluableScript theScript) {
            super(theScript);
        }

        @Nullable
        @Unmodifiable
        @NotLive
        protected Map<String, IdPAttribute> execute(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
            try {
                return (Map)this.evaluate(new Object[]{resolutionContext, workContext});
            }
            catch (RuntimeException e) {
                throw new ResolutionException(this.getLogPrefix() + "Script did not run successfully", (Exception)e);
            }
        }

        protected void prepareContext(@Nonnull ScriptContext scriptContext, Object ... input) {
            assert (input != null);
            ScriptedDataConnector.this.log.debug("{} Adding to-be-populated attribute set '{}' to script context", (Object)this.getLogPrefix(), (Object)ScriptedDataConnector.RESULTS_STRING);
            scriptContext.setAttribute(ScriptedDataConnector.RESULTS_STRING, new HashSet(), 100);
            ScriptedDataConnector.this.log.debug("{} Adding current attribute resolution contexts to script context", (Object)this.getLogPrefix());
            scriptContext.setAttribute("resolutionContext", input[0], 100);
            AttributeResolutionContext input0 = (AttributeResolutionContext)input[0];
            AttributeResolverWorkContext input1 = (AttributeResolverWorkContext)input[1];
            assert (input0 != null && input1 != null);
            ProfileRequestContext prc = (ProfileRequestContext)input0.getProfileRequestContextLookupStrategy().apply(input0);
            if (null == prc) {
                ScriptedDataConnector.this.log.error("{} ProfileRequestContext could not be located", (Object)this.getLogPrefix());
            }
            scriptContext.setAttribute("profileContext", prc, 100);
            Map dependencyAttributes = PluginDependencySupport.getAllAttributeValues((AttributeResolverWorkContext)input1, (Collection)ScriptedDataConnector.this.getAttributeDependencies(), (Collection)ScriptedDataConnector.this.getDataConnectorDependencies());
            for (Map.Entry dependencyAttribute : dependencyAttributes.entrySet()) {
                String key = (String)dependencyAttribute.getKey();
                assert (key != null);
                ScriptedDataConnector.this.log.trace("{} Adding dependent attribute '{}' with the following values to the script context: {}", new Object[]{this.getLogPrefix(), key, dependencyAttribute.getValue()});
                IdPAttribute pseudoAttribute = new IdPAttribute(key);
                pseudoAttribute.setValues((List)dependencyAttribute.getValue());
                scriptContext.setAttribute((String)dependencyAttribute.getKey(), new ScriptedIdPAttributeImpl(pseudoAttribute, this.getLogPrefix()), 100);
            }
        }

        @Nullable
        protected Object finalizeContext(@Nonnull ScriptContext scriptContext, @Nullable Object scriptResult) throws ScriptException {
            Object res = scriptContext.getAttribute(ScriptedDataConnector.RESULTS_STRING);
            if (null == res) {
                ScriptedDataConnector.this.log.error("{} Could not locate output variable '{}' from script", (Object)this.getLogPrefix(), (Object)ScriptedDataConnector.RESULTS_STRING);
                throw new ScriptException("Could not locate output from script");
            }
            if (!(res instanceof Collection)) {
                ScriptedDataConnector.this.log.error("{} Output '{}' was of type '{}', expected '{}'", new Object[]{this.getLogPrefix(), res.getClass().getName(), Collection.class.getName()});
                throw new ScriptException("Output was of the wrong type");
            }
            Collection outputCollection = (Collection)res;
            HashMap<String, IdPAttribute> outputMap = new HashMap<String, IdPAttribute>(outputCollection.size());
            for (Object o : outputCollection) {
                if (o instanceof IdPAttribute) {
                    IdPAttribute attribute = (IdPAttribute)o;
                    this.checkValues(attribute);
                    outputMap.put(attribute.getId(), attribute);
                    continue;
                }
                ScriptedDataConnector.this.log.warn("{} Output collection contained an object of type '{}', ignored", (Object)this.getLogPrefix(), (Object)o.getClass().getName());
            }
            return outputMap;
        }

        private void checkValues(IdPAttribute attribute) {
            ScriptedDataConnector.this.log.debug("{} Attribute '{}' has {} value(s).", new Object[]{this.getLogPrefix(), attribute.getId(), attribute.getValues().size()});
            List inputValues = attribute.getValues();
            ArrayList<IdPAttributeValue> outputValues = new ArrayList<IdPAttributeValue>(inputValues.size());
            for (Object o : inputValues) {
                if (o instanceof IdPAttributeValue) {
                    outputValues.add((IdPAttributeValue)o);
                    continue;
                }
                ScriptedDataConnector.this.log.error("{} Attribute '{} has attribute value of type {}.  This will be ignored", new Object[]{this.getLogPrefix(), attribute.getId(), o.getClass().getName()});
            }
            attribute.setValues(outputValues);
        }
    }
}

