/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.http.impl;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.google.common.xml.XmlEscapers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.dc.http.impl.AbstractHTTPSearchBuilder;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.velocity.Template;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;
import org.slf4j.Logger;

public class TemplatedBodyBuilder
extends AbstractHTTPSearchBuilder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(TemplatedBodyBuilder.class);
    @NonnullAfterInit
    private Template urlTemplate;
    @NonnullAfterInit
    private Template bodyTemplate;
    @NonnullAfterInit
    private Template cacheKeyTemplate;
    @NonnullAfterInit
    private String urlTemplateText;
    @NonnullAfterInit
    private String bodyTemplateText;
    @NonnullAfterInit
    private String cacheKeyTemplateText;
    @NonnullAfterInit
    private VelocityEngine engine;
    @Nonnull
    @NotEmpty
    private String method = "POST";
    @Nonnull
    @NotEmpty
    private String mimeType = "text/plain";
    @Nullable
    private String charset;
    @NonnullAfterInit
    private ContentType contentType;
    @Nonnull
    private final Escaper paramEscaper = UrlEscapers.urlFormParameterEscaper();
    @Nonnull
    private final Escaper fragmentEscaper = UrlEscapers.urlFragmentEscaper();
    @Nonnull
    private final Escaper pathEscaper = UrlEscapers.urlPathSegmentEscaper();
    @Nonnull
    private final Escaper xmlAttributeEscaper = XmlEscapers.xmlAttributeEscaper();
    @Nonnull
    private final Escaper xmlContentEscaper = XmlEscapers.xmlContentEscaper();
    @Nullable
    private Object customObject;

    @NonnullAfterInit
    public Template getURLTemplate() {
        return this.urlTemplate;
    }

    @NonnullAfterInit
    public Template getBodyTemplate() {
        return this.bodyTemplate;
    }

    @Nullable
    public Template getCacheKeyTemplate() {
        return this.cacheKeyTemplate;
    }

    @NonnullAfterInit
    public String getURLTemplateText() {
        return this.urlTemplateText;
    }

    public void setURLTemplateText(@Nullable String text) {
        this.checkSetterPreconditions();
        this.urlTemplateText = StringSupport.trimOrNull((String)text);
    }

    @NonnullAfterInit
    public String getBodyTemplateText() {
        return this.bodyTemplateText;
    }

    public void setBodyTemplateText(@Nullable String text) {
        this.checkSetterPreconditions();
        this.bodyTemplateText = StringSupport.trimOrNull((String)text);
    }

    @Nullable
    public String getCacheKeyTemplateText() {
        return this.cacheKeyTemplateText;
    }

    public void setCacheKeyTemplateText(@Nullable String text) {
        this.checkSetterPreconditions();
        this.cacheKeyTemplateText = StringSupport.trimOrNull((String)text);
    }

    @NonnullAfterInit
    public VelocityEngine getVelocityEngine() {
        return this.engine;
    }

    public void setVelocityEngine(@Nonnull VelocityEngine velocityEngine) {
        this.checkSetterPreconditions();
        this.engine = (VelocityEngine)Constraint.isNotNull((Object)velocityEngine, (String)"Velocity engine cannot be null");
    }

    public void setMethod(@Nonnull @NotEmpty String m) {
        this.checkSetterPreconditions();
        this.method = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)m), (String)"HTTP method cannot be null or empty");
        Constraint.isTrue(("POST".equals(this.method) || "PUT".equals(this.method) ? 1 : 0) != 0, (String)"HTTP method must be POST or PUT");
    }

    public void setMIMEType(@Nonnull @NotEmpty String type) {
        this.checkSetterPreconditions();
        this.mimeType = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)type), (String)"MIME type cannot be null or empty");
    }

    public void setCharacterSet(@Nullable String c) {
        this.checkSetterPreconditions();
        this.charset = StringSupport.trimOrNull((String)c);
    }

    public void setCustomObject(@Nullable Object object) {
        this.checkSetterPreconditions();
        this.customObject = object;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        VelocityEngine localEngine = this.engine;
        String localUrlTemplateText = this.urlTemplateText;
        String localBodyTemplateText = this.bodyTemplateText;
        if (null == localEngine) {
            throw new ComponentInitializationException("Velocity engine cannot be null");
        }
        if (null == localUrlTemplateText) {
            throw new ComponentInitializationException("URL template text cannot be null");
        }
        if (null == localBodyTemplateText) {
            throw new ComponentInitializationException("Body template text cannot be null");
        }
        this.urlTemplate = Template.fromTemplate((VelocityEngine)localEngine, (String)localUrlTemplateText);
        this.bodyTemplate = Template.fromTemplate((VelocityEngine)localEngine, (String)localBodyTemplateText);
        if (null != this.cacheKeyTemplateText) {
            this.cacheKeyTemplate = Template.fromTemplate((VelocityEngine)localEngine, (String)this.cacheKeyTemplateText);
        }
        this.contentType = ContentType.create((String)this.mimeType, (String)this.charset);
    }

    @Nonnull
    @NotEmpty
    protected String merge(@Nonnull Template template, @Nonnull VelocityContext context) {
        return template.merge((Context)context);
    }

    @Override
    @Nonnull
    protected ClassicHttpRequest getHttpRequest(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue>> dependencyAttributes) throws ResolutionException {
        HttpPost request;
        String body;
        String url;
        this.checkComponentActive();
        VelocityContext context = new VelocityContext();
        this.log.trace("Creating request using attribute resolution context {}", (Object)resolutionContext);
        context.put("resolutionContext", (Object)resolutionContext);
        context.put("httpClientSecurityParameters", (Object)this.getHttpClientSecurityParameters());
        context.put("paramEscaper", (Object)this.paramEscaper);
        context.put("fragmentEscaper", (Object)this.fragmentEscaper);
        context.put("pathEscaper", (Object)this.pathEscaper);
        context.put("xmlAttributeEscaper", (Object)this.xmlAttributeEscaper);
        context.put("xmlContentEscaper", (Object)this.xmlContentEscaper);
        context.put("custom", this.customObject);
        if (dependencyAttributes != null && !dependencyAttributes.isEmpty()) {
            for (Map.Entry<String, List<IdPAttributeValue>> entry : dependencyAttributes.entrySet()) {
                ArrayList<Object> values = new ArrayList<Object>(entry.getValue().size());
                for (IdPAttributeValue value : entry.getValue()) {
                    values.add(value.getNativeValue());
                }
                this.log.trace("Adding dependency {} to context with {} value(s)", (Object)entry.getKey(), (Object)values.size());
                context.put(entry.getKey(), values);
            }
        }
        try {
            assert (this.urlTemplate != null);
            url = this.merge(this.urlTemplate, context);
            assert (this.bodyTemplate != null);
            body = this.merge(this.bodyTemplate, context);
        }
        catch (VelocityException e) {
            this.log.error("Error running template engine: {}", (Object)e.getMessage());
            throw new ResolutionException("Error running template engine", (Exception)((Object)e));
        }
        try {
            if ("POST".equals(this.method)) {
                request = new HttpPost(url);
            } else if ("PUT".equals(this.method)) {
                request = new HttpPut(url);
            } else {
                throw new ResolutionException("Unsupported HTTP method");
            }
            request.setEntity((HttpEntity)new StringEntity(body, this.contentType));
        }
        catch (IllegalArgumentException e) {
            throw new ResolutionException((Exception)e);
        }
        return request;
    }

    @Override
    @Nullable
    @NotEmpty
    protected String getResultCacheKey(@Nonnull ClassicHttpRequest request, @Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue>> dependencyAttributes) {
        Template ckt = this.cacheKeyTemplate;
        if (ckt == null) {
            return null;
        }
        VelocityContext context = new VelocityContext();
        this.log.trace("Creating cache key using attribute resolution context {}", (Object)resolutionContext);
        context.put("resolutionContext", (Object)resolutionContext);
        context.put("httpClientSecurityParameters", (Object)this.getHttpClientSecurityParameters());
        if (dependencyAttributes != null && !dependencyAttributes.isEmpty()) {
            for (Map.Entry<String, List<IdPAttributeValue>> entry : dependencyAttributes.entrySet()) {
                ArrayList<Object> values = new ArrayList<Object>(entry.getValue().size());
                for (IdPAttributeValue value : entry.getValue()) {
                    values.add(value.getNativeValue());
                }
                this.log.trace("Adding dependency {} to context with {} value(s)", (Object)entry.getKey(), (Object)values.size());
                context.put(entry.getKey(), values);
            }
        }
        return this.merge(ckt, context);
    }
}

