/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.AbstractAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

@ThreadSafe
public class StaticAttributeDefinition
extends AbstractAttributeDefinition {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StaticAttributeDefinition.class);
    @NonnullAfterInit
    private IdPAttribute value;

    public void setValue(@Nullable IdPAttribute newAttribute) {
        this.checkSetterPreconditions();
        this.value = newAttribute;
    }

    @NonnullAfterInit
    public IdPAttribute getValue() {
        return this.value;
    }

    @Nonnull
    protected IdPAttribute doAttributeDefinitionResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        this.checkComponentActive();
        this.log.debug("{} resolving static attribute {}", (Object)this.getLogPrefix(), (Object)this.value);
        assert (this.value != null);
        return this.value;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.value) {
            throw new ComponentInitializationException(this.getLogPrefix() + " no attribute value set");
        }
    }
}

