/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.UnsupportedAttributeTypeException;
import net.shibboleth.idp.attribute.resolver.AbstractAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.PluginDependencySupport;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

@ThreadSafe
public class RegexSplitAttributeDefinition
extends AbstractAttributeDefinition {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RegexSplitAttributeDefinition.class);
    @NonnullAfterInit
    private Pattern regexp;

    @NonnullAfterInit
    public Pattern getRegularExpression() {
        return this.regexp;
    }

    public void setRegularExpression(@Nonnull Pattern expression) {
        this.checkSetterPreconditions();
        this.regexp = (Pattern)Constraint.isNotNull((Object)expression, (String)"Regular expression cannot be null");
    }

    @Nullable
    protected IdPAttribute doAttributeDefinitionResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        Constraint.isNotNull((Object)workContext, (String)"AttributeResolverWorkContext cannot be null");
        this.checkComponentActive();
        ArrayList<IdPAttributeValue> resultantValues = new ArrayList<IdPAttributeValue>();
        IdPAttribute resultantAttribute = new IdPAttribute(this.ensureId());
        List dependencyValues = PluginDependencySupport.getMergedAttributeValues((AttributeResolverWorkContext)workContext, (Collection)this.getAttributeDependencies(), (Collection)this.getDataConnectorDependencies(), (String)this.ensureId());
        for (IdPAttributeValue dependencyValue : dependencyValues) {
            String inputValue;
            if (dependencyValue instanceof EmptyAttributeValue) {
                EmptyAttributeValue emptyVal = (EmptyAttributeValue)dependencyValue;
                if (EmptyAttributeValue.EmptyType.NULL_VALUE == emptyVal.getValue()) {
                    this.log.debug("{} ignored empty value of type {}", (Object)this.getLogPrefix(), (Object)emptyVal.getDisplayValue());
                    continue;
                }
                inputValue = "";
            } else {
                if (!(dependencyValue instanceof StringAttributeValue)) {
                    throw new ResolutionException((Exception)new UnsupportedAttributeTypeException(this.getLogPrefix() + "This attribute definition only operates on attribute values of type " + StringAttributeValue.class.getName() + "; was given " + dependencyValue.getClass().getName()));
                }
                inputValue = ((StringAttributeValue)dependencyValue).getValue();
            }
            this.log.debug("{} Applying regexp '{}' to input value '{}'", new Object[]{this.getLogPrefix(), this.regexp.pattern(), inputValue});
            Matcher matcher = this.regexp.matcher(inputValue);
            if (matcher.matches()) {
                this.log.debug("{} Computed the value '{}' by apply regexp '{}' to input value '{}'", new Object[]{this.getLogPrefix(), matcher.group(1), this.regexp.pattern(), inputValue});
                resultantValues.add(StringAttributeValue.valueOf((String)matcher.group(1)));
                continue;
            }
            this.log.debug("{} Regexp '{}' did not match anything in input value '{}'", new Object[]{this.getLogPrefix(), this.regexp.pattern(), inputValue});
        }
        if (!resultantValues.isEmpty()) {
            resultantAttribute.setValues(resultantValues);
        }
        return resultantAttribute;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.regexp) {
            throw new ComponentInitializationException("Attribute definition '" + this.getId() + "': no regular expression was configured");
        }
        if (this.getDataConnectorDependencies().isEmpty() && this.getAttributeDependencies().isEmpty()) {
            throw new ComponentInitializationException("Attribute definition '" + this.getId() + "': no dependencies were configured");
        }
    }
}

