/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.ad.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.AbstractAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.StringSupport;

public class PrincipalNameAttributeDefinition
extends AbstractAttributeDefinition {
    @Nullable
    protected IdPAttribute doAttributeDefinitionResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        String principalName = StringSupport.trimOrNull((String)resolutionContext.getPrincipal());
        if (null == principalName) {
            throw new ResolutionException(this.getLogPrefix() + " provided principal name was empty");
        }
        IdPAttribute attribute = new IdPAttribute(this.ensureId());
        attribute.setValues(CollectionSupport.singletonList((Object)new StringAttributeValue(principalName)));
        return attribute;
    }
}

