/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.interceptor.impl;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.idp.profile.interceptor.AbstractProfileInterceptorAction;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorFlowDescriptor;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class PopulateProfileInterceptorContext
extends AbstractProfileInterceptorAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateProfileInterceptorContext.class);
    @Nonnull
    private Collection<ProfileInterceptorFlowDescriptor> availableFlows = CollectionSupport.emptyList();
    @NonnullAfterInit
    private Function<ProfileRequestContext, Collection<String>> activeFlowsLookupStrategy;
    @Nullable
    private String loggingLabel;

    public void setAvailableFlows(@Nonnull Collection<ProfileInterceptorFlowDescriptor> flows) {
        this.checkSetterPreconditions();
        this.availableFlows = CollectionSupport.copyToList((Collection)((Collection)Constraint.isNotNull(flows, (String)"Flow collection cannot be null")));
    }

    public void setActiveFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.checkSetterPreconditions();
        this.activeFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Flow lookup strategy cannot be null");
    }

    public void setLoggingLabel(@Nullable @NotEmpty String label) {
        this.checkSetterPreconditions();
        this.loggingLabel = StringSupport.trimOrNull((String)label);
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.activeFlowsLookupStrategy == null) {
            throw new ComponentInitializationException("Flow lookup strategy cannot be null");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        interceptorContext.getAvailableFlows().clear();
        interceptorContext.setAttemptedFlow(null);
        Collection<String> activeFlows = this.activeFlowsLookupStrategy.apply(profileRequestContext);
        if (activeFlows != null && !activeFlows.isEmpty()) {
            for (String id : activeFlows) {
                String flowId = "intercept/" + id;
                Optional<ProfileInterceptorFlowDescriptor> flow = this.availableFlows.stream().filter(fd -> fd.ensureId().equals(flowId)).findFirst();
                if (flow.isPresent()) {
                    this.log.debug("{} Installing {} flow {} into interceptor context", new Object[]{this.getLogPrefix(), this.loggingLabel, flowId});
                    interceptorContext.getAvailableFlows().put(flow.orElseThrow().ensureId(), flow.orElseThrow());
                    continue;
                }
                this.log.error("{} Configured {} interceptor flow {} not available for use", new Object[]{this.getLogPrefix(), this.loggingLabel, flowId});
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
                return;
            }
        } else {
            this.log.debug("{} No {} interceptor flows active for this request", (Object)this.getLogPrefix(), (Object)this.loggingLabel);
        }
    }
}

