/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.spring.metadata;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.idp.saml.metadata.impl.MetadataProviderContainer;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.custom.AbstractCustomBeanDefinitionParser;
import net.shibboleth.shared.spring.util.SpringSupport;
import net.shibboleth.shared.xml.AttributeSupport;
import net.shibboleth.shared.xml.DOMTypeSupport;
import net.shibboleth.shared.xml.ElementSupport;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterChain;
import org.slf4j.Logger;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractMetadataProviderParser
extends AbstractCustomBeanDefinitionParser {
    @Nonnull
    @NotEmpty
    public static final String SECURITY_NAMESPACE = "urn:mace:shibboleth:2.0:security";
    @Nonnull
    @NotEmpty
    public static final String METADATA_NAMESPACE = "urn:mace:shibboleth:2.0:metadata";
    @Nonnull
    public static final QName METADATA_FILTER_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:metadata", "MetadataFilter");
    @Nonnull
    public static final QName CHAINING_PROVIDER_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:metadata", "ChainingMetadataProvider");
    @Nonnull
    public static final QName TRUST_ENGINE_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:security", "TrustEngine");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractMetadataProviderParser.class);

    private boolean isPresentNotChaining(@Nonnull Element element, @Nonnull String attribute) {
        if (!element.hasAttributeNS(null, attribute)) {
            return false;
        }
        if (this.isChaining(element)) {
            this.log.warn("{} is not valid for {}", (Object)attribute, (Object)CHAINING_PROVIDER_ELEMENT_NAME.getLocalPart());
            return false;
        }
        return true;
    }

    private boolean isChaining(@Nonnull Element element) {
        return CHAINING_PROVIDER_ELEMENT_NAME.equals(DOMTypeSupport.getXSIType((Element)element));
    }

    private boolean isTopMost(@Nonnull Element element) {
        Node parent = element.getParentNode();
        return parent.getNodeType() == 9;
    }

    @Nonnull
    protected abstract Class<? extends MetadataResolver> getNativeBeanClass(@Nonnull Element var1);

    protected final Class<?> getBeanClass(@Nonnull Element element) {
        if (this.isTopMost(element)) {
            return MetadataProviderContainer.class;
        }
        return this.getNativeBeanClass(element);
    }

    protected final void doParse(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        if (this.isTopMost(element)) {
            builder.setInitMethodName("initialize");
            builder.setDestroyMethodName("destroy");
            builder.setLazyInit(true);
            BeanDefinitionBuilder childBeanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(this.getNativeBeanClass(element));
            this.doNativeParse(element, parserContext, childBeanDefinitionBuilder);
            builder.addPropertyValue("embeddedResolver", (Object)childBeanDefinitionBuilder.getBeanDefinition());
            if (element.hasAttributeNS(null, "sortKey")) {
                builder.addPropertyValue("sortKey", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "sortKey")));
            }
        } else {
            if (element.hasAttributeNS(null, "sortKey")) {
                this.log.warn("{} sortKey is only valid on 'top level' MetadataProviders", (Object)parserContext.getReaderContext().getResource().getDescription());
            }
            this.doNativeParse(element, parserContext, builder);
        }
    }

    protected void doNativeParse(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
        builder.setLazyInit(true);
        String resolverId = StringSupport.trimOrNull((String)element.getAttributeNS(null, "id"));
        builder.addPropertyValue("id", (Object)resolverId);
        QName resolverType = DOMTypeSupport.getXSIType((Element)element);
        if (resolverType != null) {
            builder.addPropertyValue("type", (Object)resolverType.getLocalPart());
        }
        if (!this.isChaining(element)) {
            if (element.hasAttributeNS(null, "metricsBaseName")) {
                builder.addPropertyValue("metricsBaseName", (Object)element.getAttributeNS(null, "metricsBaseName"));
            } else if (resolverType != null && resolverId != null) {
                builder.addPropertyValue("metricsBaseName", (Object)("net.shibboleth.idp.metadata." + resolverType.getLocalPart() + "." + resolverId));
            }
        }
        if (this.isPresentNotChaining(element, "failFastInitialization")) {
            builder.addPropertyValue("failFastInitialization", (Object)SpringSupport.getStringValueAsBoolean((String)element.getAttributeNS(null, "failFastInitialization")));
        }
        if (this.isPresentNotChaining(element, "requireValidMetadata")) {
            builder.addPropertyValue("requireValidMetadata", (Object)SpringSupport.getStringValueAsBoolean((String)element.getAttributeNS(null, "requireValidMetadata")));
        }
        if (element.hasAttributeNS(null, "activationConditionRef")) {
            builder.addPropertyReference("activationCondition", AttributeSupport.ensureAttributeValue((Element)element, null, (String)"activationConditionRef"));
        }
        this.processPredicateOptions(element, parserContext, builder);
        List filters = ElementSupport.getChildElements((Node)element, (QName)METADATA_FILTER_ELEMENT_NAME);
        if (null != filters && !filters.isEmpty()) {
            if (!this.isChaining(element)) {
                if (filters.size() == 1) {
                    builder.addPropertyValue("metadataFilter", (Object)SpringSupport.parseCustomElement((Element)((Element)filters.get(0)), (ParserContext)parserContext, (BeanDefinitionBuilder)builder, (boolean)false));
                } else if (filters.size() > 1) {
                    BeanDefinitionBuilder chainBuilder = BeanDefinitionBuilder.genericBeanDefinition(MetadataFilterChain.class);
                    chainBuilder.addPropertyValue("filters", (Object)SpringSupport.parseCustomElements((Collection)filters, (ParserContext)parserContext, (BeanDefinitionBuilder)chainBuilder));
                    builder.addPropertyValue("metadataFilter", (Object)chainBuilder.getBeanDefinition());
                }
            } else {
                this.log.warn("MetadataFilter is not valid for {}", (Object)CHAINING_PROVIDER_ELEMENT_NAME.getLocalPart());
            }
        }
    }

    private void processPredicateOptions(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        if (this.isPresentNotChaining(element, "satisfyAnyPredicates")) {
            builder.addPropertyValue("satisfyAnyPredicates", (Object)SpringSupport.getStringValueAsBoolean((String)element.getAttributeNS(null, "satisfyAnyPredicates")));
        }
        if (this.isPresentNotChaining(element, "useDefaultPredicateRegistry")) {
            builder.addPropertyValue("useDefaultPredicateRegistry", (Object)SpringSupport.getStringValueAsBoolean((String)element.getAttributeNS(null, "useDefaultPredicateRegistry")));
        }
        if (this.isPresentNotChaining(element, "criterionPredicateRegistryRef")) {
            builder.addPropertyReference("criterionPredicateRegistry", AttributeSupport.ensureAttributeValue((Element)element, null, (String)"criterionPredicateRegistryRef"));
        }
    }
}

