/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.ldap.impl;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.dc.ldap.StringAttributeValueMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.ldap.TemplatedExecutableSearchFilterBuilder;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.ConnectionFactoryValidator;
import net.shibboleth.idp.attribute.resolver.dc.ldap.impl.LDAPDataConnector;
import net.shibboleth.idp.attribute.resolver.spring.dc.AbstractDataConnectorParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.CacheConfigParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.ldap.impl.CredentialConfigFactoryBean;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.util.SpringSupport;
import net.shibboleth.shared.xml.AttributeSupport;
import net.shibboleth.shared.xml.ElementSupport;
import org.ldaptive.ActivePassiveConnectionStrategy;
import org.ldaptive.BindConnectionInitializer;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.ConnectionStrategy;
import org.ldaptive.Credential;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.FilterTemplate;
import org.ldaptive.PooledConnectionFactory;
import org.ldaptive.RandomConnectionStrategy;
import org.ldaptive.RoundRobinConnectionStrategy;
import org.ldaptive.SearchConnectionValidator;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchScope;
import org.ldaptive.handler.CaseChangeEntryHandler;
import org.ldaptive.handler.DnAttributeEntryHandler;
import org.ldaptive.handler.LdapEntryHandler;
import org.ldaptive.handler.SearchResultHandler;
import org.ldaptive.pool.IdlePruneStrategy;
import org.ldaptive.referral.FollowSearchReferralHandler;
import org.ldaptive.referral.FollowSearchResultReferenceHandler;
import org.ldaptive.sasl.Mechanism;
import org.ldaptive.sasl.SaslConfig;
import org.ldaptive.ssl.AllowAnyHostnameVerifier;
import org.ldaptive.ssl.CertificateHostnameVerifier;
import org.ldaptive.ssl.SslConfig;
import org.opensaml.spring.credential.BasicX509CredentialFactoryBean;
import org.slf4j.Logger;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LDAPDataConnectorParser
extends AbstractDataConnectorParser {
    @Nonnull
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "LDAPDirectory");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(LDAPDataConnectorParser.class);

    @Nullable
    protected Class<LDAPDataConnector> getBeanClass(@Nonnull Element element) {
        return LDAPDataConnector.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        this.log.debug("{} Parsing XML configuration {}", (Object)this.getLogPrefix(), (Object)config);
        if (config.hasAttributeNS(null, "failFastInitialize")) {
            builder.addPropertyValue("failFastInitialize", (Object)StringSupport.trimOrNull((String)config.getAttributeNS(null, "failFastInitialize")));
        } else {
            builder.addPropertyValue("failFastInitialize", (Object)FAIL_FAST_DEFAULT);
        }
        V2Parser v2Parser = new V2Parser(this.getDefinitionId(), config, this.getLogPrefix());
        String searchBuilderID = v2Parser.getBeanSearchBuilderID();
        if (searchBuilderID != null) {
            builder.addPropertyReference("executableSearchBuilder", searchBuilderID);
        } else {
            BeanDefinition def = v2Parser.createTemplateBuilder();
            if (def != null) {
                builder.addPropertyValue("executableSearchBuilder", (Object)def);
            }
        }
        String connectionFactoryID = v2Parser.getBeanConnectionFactoryID();
        if (connectionFactoryID != null) {
            builder.addPropertyReference("connectionFactory", connectionFactoryID);
        } else {
            BeanDefinitionBuilder connectionFactory = BeanDefinitionBuilder.genericBeanDefinition(DefaultConnectionFactory.class);
            connectionFactory.addConstructorArgValue((Object)v2Parser.createConnectionConfig(parserContext));
            BeanDefinition pooledConnectionFactory = v2Parser.createPooledConnectionFactory(parserContext);
            if (pooledConnectionFactory != null) {
                builder.addPropertyValue("connectionFactory", (Object)pooledConnectionFactory);
            } else {
                builder.addPropertyValue("connectionFactory", (Object)connectionFactory.getBeanDefinition());
            }
        }
        String searchOperationID = v2Parser.getBeanSearchOperationID();
        if (searchOperationID != null) {
            builder.addPropertyReference("searchOperation", searchOperationID);
        } else {
            BeanDefinition searchOperation = v2Parser.createSearchOperation();
            builder.addPropertyValue("searchOperation", (Object)searchOperation);
        }
        String mappingStrategyID = AttributeSupport.getAttributeValue((Element)config, (QName)new QName("mappingStrategyRef"));
        if (mappingStrategyID != null) {
            builder.addPropertyReference("mappingStrategy", mappingStrategyID);
        } else {
            BeanDefinition def = v2Parser.createMappingStrategy();
            if (def != null) {
                builder.addPropertyValue("mappingStrategy", (Object)def);
            }
        }
        String validatorID = AttributeSupport.getAttributeValue((Element)config, (QName)new QName("validatorRef"));
        if (validatorID != null) {
            builder.addPropertyReference("validator", validatorID);
        } else {
            builder.addPropertyValue("validator", (Object)v2Parser.createValidator());
        }
        String resultCacheBeanID = CacheConfigParser.getBeanResultCacheID(config);
        if (null != resultCacheBeanID) {
            builder.addPropertyReference("resultsCache", resultCacheBeanID);
        } else {
            builder.addPropertyValue("resultsCache", (Object)v2Parser.createCache(parserContext));
        }
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
    }

    protected static class V2Parser {
        @Nonnull
        private static final Logger LOG = LoggerFactory.getLogger(V2Parser.class);
        @Nonnull
        @NotEmpty
        private final String connectorId;
        @Nonnull
        private final Element configElement;
        @Nonnull
        @NotEmpty
        private final String logPrefix;

        public V2Parser(@Nonnull String id, @Nonnull Element config, @Nonnull String prefix) {
            this.connectorId = Constraint.isNotEmpty((String)id, (String)"Data connector ID cannot be null or empty");
            this.configElement = (Element)Constraint.isNotNull((Object)config, (String)"LDAPDirectory element cannot be null");
            this.logPrefix = Constraint.isNotEmpty((String)prefix, (String)"Log prefix cannot be null or empty");
        }

        @Nonnull
        public BeanDefinition createConnectionConfig(@Nonnull ParserContext parserContext) {
            String url = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("ldapURL"));
            String useStartTLS = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("useStartTLS"));
            String startTLSTimeout = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("startTLSTimeout"));
            String principal = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("principal"));
            String principalCredential = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("principalCredential"));
            String connectTimeout = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("connectTimeout"));
            String responseTimeout = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("responseTimeout"));
            String autoReconnect = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("autoReconnect"));
            String reconnectTimeout = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("reconnectTimeout"));
            BeanDefinitionBuilder connectionConfig = BeanDefinitionBuilder.genericBeanDefinition(ConnectionConfig.class);
            connectionConfig.addPropertyValue("ldapUrl", (Object)url);
            if (useStartTLS != null) {
                connectionConfig.addPropertyValue("useStartTLS", (Object)useStartTLS);
            }
            if (startTLSTimeout != null) {
                connectionConfig.addPropertyValue("startTLSTimeout", (Object)startTLSTimeout);
            } else {
                connectionConfig.addPropertyValue("startTLSTimeout", (Object)Duration.ofSeconds(3L));
            }
            if (connectTimeout != null) {
                connectionConfig.addPropertyValue("connectTimeout", (Object)connectTimeout);
            } else {
                connectionConfig.addPropertyValue("connectTimeout", (Object)Duration.ofSeconds(3L));
            }
            if (responseTimeout != null) {
                connectionConfig.addPropertyValue("responseTimeout", (Object)responseTimeout);
            } else {
                connectionConfig.addPropertyValue("responseTimeout", (Object)Duration.ofSeconds(3L));
            }
            if (autoReconnect != null) {
                connectionConfig.addPropertyValue("autoReconnect", (Object)autoReconnect);
            }
            if (reconnectTimeout != null) {
                connectionConfig.addPropertyValue("reconnectTimeout", (Object)reconnectTimeout);
            } else {
                connectionConfig.addPropertyValue("reconnectTimeout", (Object)Duration.ofSeconds(10L));
            }
            BeanDefinitionBuilder sslConfig = BeanDefinitionBuilder.genericBeanDefinition(SslConfig.class);
            String disableHostnameVerification = this.configElement.getAttributeNS(null, "disableHostnameVerification");
            if (disableHostnameVerification != null) {
                BeanDefinitionBuilder verifier = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildHostnameVerifier");
                verifier.addConstructorArgValue((Object)disableHostnameVerification);
                verifier.addConstructorArgValue((Object)this.getLogPrefix());
                sslConfig.addPropertyValue("hostnameVerifier", (Object)verifier.getBeanDefinition());
            }
            sslConfig.addPropertyValue("credentialConfig", (Object)this.createCredentialConfig(parserContext));
            connectionConfig.addPropertyValue("sslConfig", (Object)sslConfig.getBeanDefinition());
            BeanDefinitionBuilder connectionInitializer = BeanDefinitionBuilder.genericBeanDefinition(BindConnectionInitializer.class);
            if (principal != null) {
                connectionInitializer.addPropertyValue("bindDn", (Object)principal);
            }
            if (principalCredential != null) {
                BeanDefinitionBuilder credential = BeanDefinitionBuilder.genericBeanDefinition(Credential.class);
                credential.addConstructorArgValue((Object)principalCredential);
                connectionInitializer.addPropertyValue("bindCredential", (Object)credential.getBeanDefinition());
            }
            BeanDefinition saslConfig = this.createSaslConfig();
            connectionInitializer.addPropertyValue("bindSaslConfig", (Object)saslConfig);
            if (principal != null || principalCredential != null || saslConfig != null) {
                connectionConfig.addPropertyValue("connectionInitializers", (Object)connectionInitializer.getBeanDefinition());
            }
            String connectionStrategy = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("connectionStrategy"));
            BeanDefinitionBuilder connectionStrategyBuilder = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildConnectionStrategy");
            connectionStrategyBuilder.addConstructorArgValue((Object)connectionStrategy);
            connectionConfig.addPropertyValue("connectionStrategy", (Object)connectionStrategyBuilder.getBeanDefinition());
            return connectionConfig.getBeanDefinition();
        }

        @Nonnull
        protected BeanDefinition createCredentialConfig(@Nonnull ParserContext parserContext) {
            BeanDefinitionBuilder result = BeanDefinitionBuilder.genericBeanDefinition(CredentialConfigFactoryBean.class);
            List trustElements = ElementSupport.getChildElementsByTagNameNS((Node)this.configElement, (String)"urn:mace:shibboleth:2.0:resolver", (String)"StartTLSTrustCredential");
            String trustResource = StringSupport.trimOrNull((String)AttributeSupport.getAttributeValue((Element)this.configElement, null, (String)"trustFile"));
            if (trustResource != null) {
                if (!trustElements.isEmpty()) {
                    LOG.warn("{} StartTLSTrustCredential and trustFile= are incompatible.  trustFile used.", (Object)this.getLogPrefix());
                }
                BeanDefinitionBuilder credential = BeanDefinitionBuilder.genericBeanDefinition(BasicX509CredentialFactoryBean.class);
                credential.addPropertyValue("certificateResource", (Object)trustResource);
                result.addPropertyValue("trustCredential", (Object)credential.getBeanDefinition());
            } else if (!trustElements.isEmpty()) {
                if (trustElements.size() > 1) {
                    LOG.warn("{} Too many StartTLSTrustCredential elements in {}; only the first has been consulted", (Object)this.getLogPrefix(), (Object)parserContext.getReaderContext().getResource().getDescription());
                }
                Element trustElement = (Element)trustElements.get(0);
                assert (trustElement != null);
                result.addPropertyValue("trustCredential", (Object)SpringSupport.parseCustomElement((Element)trustElement, (ParserContext)parserContext, (BeanDefinitionBuilder)result, (boolean)false));
            }
            List authElements = ElementSupport.getChildElementsByTagNameNS((Node)this.configElement, (String)"urn:mace:shibboleth:2.0:resolver", (String)"StartTLSAuthenticationCredential");
            String authKey = StringSupport.trimOrNull((String)AttributeSupport.getAttributeValue((Element)this.configElement, null, (String)"authKey"));
            String authCert = StringSupport.trimOrNull((String)AttributeSupport.getAttributeValue((Element)this.configElement, null, (String)"authCert"));
            if (authKey != null || authCert != null) {
                if (!authElements.isEmpty()) {
                    LOG.warn("{} StartTLSAuthenticationCredential and authKey/authCert= are incompatible.  authCert/authKey used.", (Object)this.getLogPrefix());
                }
                BeanDefinitionBuilder authCred = BeanDefinitionBuilder.genericBeanDefinition(BasicX509CredentialFactoryBean.class);
                authCred.addPropertyValue("certificateResource", (Object)authCert);
                authCred.addPropertyValue("privateKeyResource", (Object)authKey);
                authCred.addPropertyValue("privateKeyPassword", (Object)AttributeSupport.getAttributeValue((Element)this.configElement, null, (String)"authKeyPassword"));
                result.addPropertyValue("authCredential", (Object)authCred.getBeanDefinition());
            } else if (!authElements.isEmpty()) {
                if (authElements.size() > 1) {
                    LOG.warn("{} Too many StartTLSAuthenticationCredential elements in {}; only the first has been consulted", (Object)this.getLogPrefix(), (Object)parserContext.getReaderContext().getResource().getDescription());
                }
                Element authElement = (Element)authElements.get(0);
                assert (authElement != null);
                result.addPropertyValue("authCredential", (Object)SpringSupport.parseCustomElement((Element)authElement, (ParserContext)parserContext, (BeanDefinitionBuilder)result, (boolean)false));
            }
            return result.getBeanDefinition();
        }

        @Nullable
        private String getFilterText() {
            String filter;
            List filterElements = ElementSupport.getChildElementsByTagNameNS((Node)this.configElement, (String)"urn:mace:shibboleth:2.0:resolver", (String)"FilterTemplate");
            if (!filterElements.isEmpty()) {
                if (filterElements.size() > 1) {
                    LOG.warn("{} only one <FilterTemplate> can be specified; only the first has been consulted", (Object)this.getLogPrefix());
                }
                filter = StringSupport.trimOrNull((String)((Element)filterElements.get(0)).getTextContent().trim());
            } else {
                filter = null;
            }
            return filter;
        }

        @Nullable
        public String getBeanSearchBuilderID() {
            return AttributeSupport.getAttributeValue((Element)this.configElement, null, (String)"executableSearchBuilderRef");
        }

        @Nullable
        public String getBeanConnectionFactoryID() {
            return AttributeSupport.getAttributeValue((Element)this.configElement, null, (String)"connectionFactoryRef");
        }

        @Nullable
        public String getBeanSearchOperationID() {
            return AttributeSupport.getAttributeValue((Element)this.configElement, null, (String)"searchOperationRef");
        }

        @Nonnull
        public BeanDefinition createTemplateBuilder() {
            BeanDefinitionBuilder templateBuilder = BeanDefinitionBuilder.genericBeanDefinition(TemplatedExecutableSearchFilterBuilder.class);
            templateBuilder.setInitMethodName("initialize");
            String velocityEngineRef = StringSupport.trimOrNull((String)this.configElement.getAttribute("templateEngine"));
            if (null == velocityEngineRef) {
                velocityEngineRef = "shibboleth.VelocityEngine";
            }
            templateBuilder.addPropertyReference("velocityEngine", velocityEngineRef);
            templateBuilder.addPropertyValue("templateText", (Object)this.getFilterText());
            return templateBuilder.getBeanDefinition();
        }

        @Nonnull
        public BeanDefinition createSearchOperation() {
            List binaryAttrsElements;
            String baseDn = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("baseDN"));
            String searchScope = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("searchScope"));
            String derefAliases = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("derefAliases"));
            String followReferrals = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("followReferrals"));
            String searchTimeLimit = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("searchTimeLimit"));
            String maxResultSize = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("maxResultSize"));
            String lowercaseAttributeNames = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("lowercaseAttributeNames"));
            BeanDefinitionBuilder searchRequest = BeanDefinitionBuilder.genericBeanDefinition(SearchRequest.class);
            if (baseDn != null) {
                searchRequest.addPropertyValue("baseDn", (Object)baseDn);
            }
            if (searchScope != null) {
                searchRequest.addPropertyValue("searchScope", (Object)searchScope);
            }
            if (derefAliases != null) {
                searchRequest.addPropertyValue("derefAliases", (Object)derefAliases);
            }
            BeanDefinitionBuilder searchOperation = BeanDefinitionBuilder.genericBeanDefinition(SearchOperation.class);
            if (followReferrals != null) {
                BeanDefinitionBuilder handler = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildReferralHandlers");
                handler.addConstructorArgValue((Object)followReferrals);
                searchOperation.addPropertyValue("searchResultHandlers", (Object)handler.getBeanDefinition());
            }
            if (searchTimeLimit != null) {
                searchRequest.addPropertyValue("timeLimit", (Object)searchTimeLimit);
            } else {
                searchRequest.addPropertyValue("timeLimit", (Object)Duration.ofSeconds(3L));
            }
            if (maxResultSize != null) {
                searchRequest.addPropertyValue("sizeLimit", (Object)maxResultSize);
            } else {
                searchRequest.addPropertyValue("sizeLimit", (Object)1);
            }
            BeanDefinitionBuilder handlers = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildSearchEntryHandlers");
            handlers.addConstructorArgValue((Object)lowercaseAttributeNames);
            searchOperation.addPropertyValue("entryHandlers", (Object)handlers.getBeanDefinition());
            List returnAttrsElements = ElementSupport.getChildElementsByTagNameNS((Node)this.configElement, (String)"urn:mace:shibboleth:2.0:resolver", (String)"ReturnAttributes");
            if (!returnAttrsElements.isEmpty()) {
                if (returnAttrsElements.size() > 1) {
                    LOG.warn("{} Only one <ReturnAttributes> element can be specified; only the first has been consulted.", (Object)this.getLogPrefix());
                }
                Element returnAttrsElement = (Element)returnAttrsElements.get(0);
                assert (returnAttrsElement != null);
                BeanDefinitionBuilder returnAttrs = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildStringList");
                returnAttrs.addConstructorArgValue((Object)ElementSupport.getElementContentAsString((Element)returnAttrsElement));
                searchRequest.addPropertyValue("returnAttributes", (Object)returnAttrs.getBeanDefinition());
            }
            if (!(binaryAttrsElements = ElementSupport.getChildElementsByTagNameNS((Node)this.configElement, (String)"urn:mace:shibboleth:2.0:resolver", (String)"BinaryAttributes")).isEmpty()) {
                if (binaryAttrsElements.size() > 1) {
                    LOG.warn("{} Only one <BinaryAttributes> element can be specified; only the first has been consulted.", (Object)this.getLogPrefix());
                }
                Element binaryAttrsElement = (Element)binaryAttrsElements.get(0);
                assert (binaryAttrsElement != null);
                BeanDefinitionBuilder binaryAttrs = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildStringList");
                binaryAttrs.addConstructorArgValue((Object)ElementSupport.getElementContentAsString((Element)binaryAttrsElement));
                searchRequest.addPropertyValue("binaryAttributes", (Object)binaryAttrs.getBeanDefinition());
            }
            searchOperation.addPropertyValue("request", (Object)searchRequest.getBeanDefinition());
            return searchOperation.getBeanDefinition();
        }

        @Nullable
        Element getConnectionPoolElement() {
            List poolConfigElements = ElementSupport.getChildElementsByTagNameNS((Node)this.configElement, (String)"urn:mace:shibboleth:2.0:resolver", (String)"ConnectionPool");
            if (poolConfigElements.isEmpty()) {
                return null;
            }
            if (poolConfigElements.size() > 1) {
                LOG.warn("{} Only one <ConnectionPool> should be specified; only the first has been consulted.", (Object)this.getLogPrefix());
            }
            return (Element)poolConfigElements.get(0);
        }

        @Nullable
        public BeanDefinition createPooledConnectionFactory(@Nonnull ParserContext parserContext) {
            Element poolConfigElement = this.getConnectionPoolElement();
            if (null == poolConfigElement) {
                return null;
            }
            String blockWaitTime = AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("blockWaitTime"));
            String expirationTime = AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("expirationTime"));
            BeanDefinitionBuilder connectionFactory = BeanDefinitionBuilder.genericBeanDefinition(PooledConnectionFactory.class);
            connectionFactory.addPropertyValue("name", (Object)("resolver-pool-" + this.connectorId));
            connectionFactory.addPropertyValue("connectionConfig", (Object)this.createConnectionConfig(parserContext));
            if (blockWaitTime != null) {
                connectionFactory.addPropertyValue("blockWaitTime", (Object)blockWaitTime);
            }
            if (expirationTime != null) {
                String prunePeriod = AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("prunePeriod"));
                BeanDefinitionBuilder strategy = BeanDefinitionBuilder.genericBeanDefinition(IdlePruneStrategy.class);
                if (prunePeriod != null) {
                    strategy.addConstructorArgValue((Object)prunePeriod);
                }
                strategy.addConstructorArgValue((Object)expirationTime);
                connectionFactory.addPropertyValue("pruneStrategy", (Object)strategy.getBeanDefinition());
            }
            String minPoolSize = AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("minPoolSize"));
            String maxPoolSize = AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("maxPoolSize"));
            String validatePeriodically = AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("validatePeriodically"));
            String validateOnCheckOut = AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("validateOnCheckOut"));
            if (minPoolSize == null) {
                connectionFactory.addPropertyValue("minPoolSize", (Object)0);
            } else {
                connectionFactory.addPropertyValue("minPoolSize", (Object)minPoolSize);
            }
            if (maxPoolSize == null) {
                connectionFactory.addPropertyValue("maxPoolSize", (Object)3);
            } else {
                connectionFactory.addPropertyValue("maxPoolSize", (Object)maxPoolSize);
            }
            if (validatePeriodically != null) {
                connectionFactory.addPropertyValue("validatePeriodically", (Object)validatePeriodically);
            }
            if (validateOnCheckOut != null) {
                connectionFactory.addPropertyValue("validateOnCheckOut", (Object)validateOnCheckOut);
            }
            BeanDefinitionBuilder validator = BeanDefinitionBuilder.rootBeanDefinition(V2Parser.class, (String)"buildSearchValidator");
            validator.addConstructorArgValue((Object)AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("validateDN")));
            validator.addConstructorArgValue((Object)AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("validateFilter")));
            validator.addConstructorArgValue((Object)AttributeSupport.getAttributeValue((Element)poolConfigElement, (QName)new QName("validateTimerPeriod")));
            connectionFactory.addPropertyValue("validator", (Object)validator.getBeanDefinition());
            if (this.configElement.hasAttributeNS(null, "failFastInitialize")) {
                connectionFactory.addPropertyValue("failFastInitialize", (Object)StringSupport.trimOrNull((String)this.configElement.getAttributeNS(null, "failFastInitialize")));
            } else {
                connectionFactory.addPropertyValue("failFastInitialize", (Object)AbstractDataConnectorParser.FAIL_FAST_DEFAULT);
            }
            connectionFactory.setInitMethodName("initialize");
            connectionFactory.setDestroyMethodName("close");
            return connectionFactory.getBeanDefinition();
        }

        @Nullable
        protected BeanDefinition createSaslConfig() {
            List saslConfigElements = ElementSupport.getChildElementsByTagNameNS((Node)this.configElement, (String)"urn:mace:shibboleth:2.0:resolver", (String)"SASLConfig");
            if (saslConfigElements.isEmpty()) {
                return null;
            }
            if (saslConfigElements.size() > 1) {
                LOG.warn("{} Only one <SASLConfig> element can be specified; only the first has been consulted.", (Object)this.getLogPrefix());
            }
            Element saslConfigElement = (Element)saslConfigElements.get(0);
            assert (saslConfigElement != null);
            String mechanism = AttributeSupport.getAttributeValue((Element)saslConfigElement, (QName)new QName("mechanism"));
            String authorizationId = AttributeSupport.getAttributeValue((Element)saslConfigElement, (QName)new QName("authorizationId"));
            String realm = AttributeSupport.getAttributeValue((Element)saslConfigElement, (QName)new QName("realm"));
            List saslProperties = ElementSupport.getChildElementsByTagNameNS((Node)saslConfigElement, (String)"urn:mace:shibboleth:2.0:resolver", (String)"SASLProperty");
            BeanDefinitionBuilder saslConfig = BeanDefinitionBuilder.genericBeanDefinition(SaslConfig.class);
            saslConfig.addPropertyValue("mechanism", (Object)mechanism);
            if (authorizationId != null) {
                saslConfig.addPropertyValue("authorizationId", (Object)authorizationId);
            }
            if (realm != null) {
                saslConfig.addPropertyValue("realm", (Object)realm);
            }
            if (!saslProperties.isEmpty()) {
                HashMap<String, String> additionalProps = new HashMap<String, String>();
                for (Element property : saslProperties) {
                    int i;
                    String[] values;
                    String[] splitValues;
                    assert (property != null);
                    String name = AttributeSupport.getAttributeValue((Element)property, null, (String)"name");
                    String value = AttributeSupport.getAttributeValue((Element)property, null, (String)"value");
                    if ("javax.security.sasl.qop".equals(name) && value != null) {
                        splitValues = value.split(",");
                        values = new String[splitValues.length];
                        for (i = 0; i < splitValues.length; ++i) {
                            values[i] = "auth".equalsIgnoreCase(splitValues[i].trim()) ? "AUTH" : ("auth-int".equalsIgnoreCase(splitValues[i].trim()) ? "AUTH_INT" : ("auth-conf".equalsIgnoreCase(splitValues[i].trim()) ? "AUTH_CONF" : splitValues[i].trim()));
                        }
                        saslConfig.addPropertyValue("qualityOfProtection", (Object)values);
                        continue;
                    }
                    if ("javax.security.sasl.strength".equals(name) && value != null) {
                        splitValues = value.split(",");
                        values = new String[splitValues.length];
                        for (i = 0; i < splitValues.length; ++i) {
                            values[i] = splitValues[i].trim();
                        }
                        saslConfig.addPropertyValue("securityStrength", (Object)values);
                        continue;
                    }
                    if ("javax.security.sasl.server.authentication".equals(name)) {
                        saslConfig.addPropertyValue("mutualAuthentication", (Object)value);
                        continue;
                    }
                    additionalProps.put(name, value);
                }
                if (!additionalProps.isEmpty()) {
                    saslConfig.addPropertyValue("properties", additionalProps);
                }
            }
            return saslConfig.getBeanDefinition();
        }

        @Nullable
        public BeanDefinition createMappingStrategy() {
            String multipleResultsIsError;
            String noResultIsError;
            BeanDefinitionBuilder mapper = BeanDefinitionBuilder.genericBeanDefinition(StringAttributeValueMappingStrategy.class);
            List columns = ElementSupport.getChildElementsByTagNameNS((Node)this.configElement, (String)"urn:mace:shibboleth:2.0:resolver", (String)"Column");
            if (!columns.isEmpty()) {
                ManagedMap renamingMap = new ManagedMap();
                for (Element column : columns) {
                    assert (column != null);
                    String columnName = AttributeSupport.getAttributeValue((Element)column, null, (String)"columnName");
                    String attributeId = AttributeSupport.getAttributeValue((Element)column, null, (String)"attributeID");
                    if (columnName == null || attributeId == null) continue;
                    renamingMap.put((Object)columnName, (Object)attributeId);
                }
                mapper.addPropertyValue("resultRenamingMap", (Object)renamingMap);
            }
            if ((noResultIsError = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("noResultIsError"))) != null) {
                mapper.addPropertyValue("noResultAnError", (Object)SpringSupport.getStringValueAsBoolean((String)noResultIsError));
            }
            if ((multipleResultsIsError = AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("multipleResultsIsError"))) != null) {
                mapper.addPropertyValue("multipleResultsAnError", (Object)multipleResultsIsError);
            }
            return mapper.getBeanDefinition();
        }

        @Nullable
        public BeanDefinition createValidator() {
            BeanDefinitionBuilder validator = BeanDefinitionBuilder.genericBeanDefinition(ConnectionFactoryValidator.class);
            validator.addPropertyValue("throwValidateError", (Object)false);
            return validator.getBeanDefinition();
        }

        @Nullable
        public BeanDefinition createCache(@Nonnull ParserContext parserContext) {
            CacheConfigParser parser = new CacheConfigParser(this.configElement);
            return parser.createCache();
        }

        @Nonnull
        String getLogPrefix() {
            return this.logPrefix;
        }

        @Nonnull
        public static List<String> buildStringList(@Nonnull String value) {
            return StringSupport.stringToList((String)value, (String)" \n\r\t,");
        }

        @Nullable
        public static SearchConnectionValidator buildSearchValidator(@Nullable String validateDN, @Nullable String validateFilter, @Nullable String validatePeriod) {
            SearchRequest searchRequest = new SearchRequest();
            searchRequest.setReturnAttributes(new String[]{"1.1"});
            searchRequest.setSearchScope(SearchScope.OBJECT);
            searchRequest.setSizeLimit(1);
            if (validateDN != null) {
                searchRequest.setBaseDn(validateDN);
            } else {
                searchRequest.setBaseDn("");
            }
            FilterTemplate searchFilter = new FilterTemplate();
            if (validateFilter != null) {
                searchFilter.setFilter(validateFilter);
            } else {
                searchFilter.setFilter("(objectClass=*)");
            }
            searchRequest.setFilter(searchFilter);
            SearchConnectionValidator validator = new SearchConnectionValidator();
            if (validatePeriod != null) {
                validator.setValidatePeriod(Duration.parse(validatePeriod));
            }
            validator.setSearchRequest(searchRequest);
            return validator;
        }

        @Nullable
        public static CertificateHostnameVerifier buildHostnameVerifier(@Nullable String disableHostnameVerification, @Nullable String logPrefix) {
            if (disableHostnameVerification != null && Boolean.valueOf(disableHostnameVerification).booleanValue()) {
                LoggerFactory.getLogger(LDAPDataConnectorParser.class).warn("{} TLS server certificate name checking is disabled!", (Object)logPrefix);
                return new AllowAnyHostnameVerifier();
            }
            return null;
        }

        @Nonnull
        public static List<LdapEntryHandler> buildSearchEntryHandlers(@Nullable String lowercaseAttributeNames) {
            ArrayList<LdapEntryHandler> handlers = new ArrayList<LdapEntryHandler>();
            handlers.add((LdapEntryHandler)new DnAttributeEntryHandler());
            if (Boolean.valueOf(lowercaseAttributeNames).booleanValue()) {
                CaseChangeEntryHandler entryHandler = new CaseChangeEntryHandler();
                entryHandler.setAttributeNameCaseChange(CaseChangeEntryHandler.CaseChange.LOWER);
                handlers.add((LdapEntryHandler)entryHandler);
            }
            return handlers;
        }

        @Nullable
        public static List<SearchResultHandler> buildReferralHandlers(@Nullable String followReferrals) {
            if (followReferrals != null && Boolean.valueOf(followReferrals).booleanValue()) {
                return CollectionSupport.listOf((Object)new FollowSearchReferralHandler(), (Object)new FollowSearchResultReferenceHandler());
            }
            return null;
        }

        @Nonnull
        public static SaslConfig buildSaslConfig(@Nonnull String mechanism) {
            SaslConfig config = new SaslConfig();
            config.setMechanism(Mechanism.valueOf((String)mechanism));
            return config;
        }

        @Nonnull
        public static ConnectionStrategy buildConnectionStrategy(@Nullable String connectionStrategy) {
            if (connectionStrategy == null) {
                return new ActivePassiveConnectionStrategy();
            }
            switch (connectionStrategy) {
                case "ROUND_ROBIN": {
                    return new RoundRobinConnectionStrategy();
                }
                case "RANDOM": {
                    return new RandomConnectionStrategy();
                }
                case "ACTIVE_PASSIVE": {
                    return new ActivePassiveConnectionStrategy();
                }
            }
            LOG.warn("Unexpected connectionStrategy {}", (Object)connectionStrategy);
            return new ActivePassiveConnectionStrategy();
        }
    }
}

