/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.http.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.dc.http.impl.HTTPDataConnector;
import net.shibboleth.idp.attribute.resolver.dc.http.impl.ScriptedResponseMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.http.impl.TemplatedBodyBuilder;
import net.shibboleth.idp.attribute.resolver.dc.http.impl.TemplatedURLBuilder;
import net.shibboleth.idp.attribute.resolver.spring.dc.AbstractDataConnectorParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.CacheConfigParser;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.util.SpringSupport;
import net.shibboleth.shared.xml.AttributeSupport;
import net.shibboleth.shared.xml.ElementSupport;
import net.shibboleth.spring.ScriptTypeBeanParser;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.spring.credential.BasicX509CredentialFactoryBean;
import org.opensaml.spring.httpclient.HttpClientSecurityParametersMergingFactoryBean;
import org.opensaml.spring.trust.StaticExplicitKeyFactoryBean;
import org.opensaml.spring.trust.StaticPKIXFactoryBean;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HTTPDataConnectorParser
extends AbstractDataConnectorParser {
    @Nonnull
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "HTTP");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPDataConnectorParser.class);

    @Nullable
    protected Class<HTTPDataConnector> getBeanClass(@Nonnull Element element) {
        return HTTPDataConnector.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        String resultCacheBeanID;
        super.doParse(config, parserContext, builder);
        this.log.debug("{} Parsing custom configuration {}", (Object)this.getLogPrefix(), (Object)config);
        if (config.hasAttributeNS(null, "failFastInitialize")) {
            builder.addPropertyValue("failFastInitialize", (Object)StringSupport.trimOrNull((String)config.getAttributeNS(null, "failFastInitialize")));
        } else {
            builder.addPropertyValue("failFastInitialize", (Object)FAIL_FAST_DEFAULT);
        }
        V2Parser v2Parser = new V2Parser(config, this.getLogPrefix());
        String httpClientID = v2Parser.getBeanHttpClientID();
        if (httpClientID != null) {
            builder.addPropertyReference("httpClient", httpClientID);
        }
        BeanDefinition httpClientSecurityParameters = HTTPDataConnectorParser.buildHttpClientSecurityParameters(v2Parser.buildHttpClientSecurityParams(config.getAttributeNS(null, "id")), StringSupport.trimOrNull((String)config.getAttributeNS(null, "httpClientSecurityParametersRef")), parserContext);
        builder.addPropertyValue("httpClientSecurityParameters", (Object)httpClientSecurityParameters);
        String searchBuilderID = v2Parser.getBeanSearchBuilderID();
        if (searchBuilderID != null) {
            builder.addPropertyReference("executableSearchBuilder", searchBuilderID);
        } else {
            BeanDefinition def = v2Parser.createBodyTemplateBuilder(httpClientSecurityParameters);
            if (def != null) {
                builder.addPropertyValue("executableSearchBuilder", (Object)def);
            } else {
                def = v2Parser.createURLTemplateBuilder(httpClientSecurityParameters);
                if (def != null) {
                    builder.addPropertyValue("executableSearchBuilder", (Object)def);
                }
            }
        }
        String mappingStrategyID = v2Parser.getBeanMappingStrategyID();
        if (mappingStrategyID != null) {
            builder.addPropertyReference("mappingStrategy", mappingStrategyID);
        } else {
            BeanDefinition def = v2Parser.createMappingStrategy(config.getAttributeNS(null, "id"));
            if (def != null) {
                builder.addPropertyValue("mappingStrategy", (Object)def);
            }
        }
        String validatorID = v2Parser.getBeanValidatorID();
        if (validatorID != null) {
            builder.addPropertyReference("validator", validatorID);
        }
        if (null != (resultCacheBeanID = CacheConfigParser.getBeanResultCacheID(config))) {
            builder.addPropertyReference("resultsCache", resultCacheBeanID);
        } else {
            builder.addPropertyValue("resultsCache", (Object)v2Parser.createCache(parserContext));
        }
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
    }

    @Nonnull
    protected static BeanDefinition buildHttpClientSecurityParameters(@Nullable BeanDefinition inlineParams, @Nullable String parametersRef, @Nonnull ParserContext parserContext) {
        BeanDefinitionBuilder factoryBuilder = BeanDefinitionBuilder.genericBeanDefinition(HttpClientSecurityParametersMergingFactoryBean.class);
        ManagedList factoryInputs = new ManagedList(2);
        if (inlineParams != null) {
            factoryInputs.add(inlineParams);
        }
        if (parametersRef != null) {
            factoryInputs.add(new RuntimeBeanReference(parametersRef));
        }
        factoryBuilder.addPropertyValue("parameters", (Object)factoryInputs);
        return factoryBuilder.getBeanDefinition();
    }

    protected static class V2Parser {
        @Nonnull
        private final Element configElement;
        @Nonnull
        private final Logger log = LoggerFactory.getLogger(V2Parser.class);
        @Nonnull
        @NotEmpty
        private final String logPrefix;

        public V2Parser(@Nonnull Element config, @Nonnull @NotEmpty String prefix) {
            Constraint.isNotNull((Object)config, (String)"HTTP DataConnector element cannot be null");
            this.configElement = config;
            this.logPrefix = prefix;
        }

        @Nullable
        public String getBeanHttpClientID() {
            return AttributeSupport.getAttributeValue((Element)this.configElement, (QName)new QName("httpClientRef"));
        }

        @Nullable
        public String getBeanSearchBuilderID() {
            return AttributeSupport.getAttributeValue((Element)this.configElement, null, (String)"executableSearchBuilderRef");
        }

        @Nullable
        public BeanDefinition createURLTemplateBuilder(@Nullable BeanDefinition httpClientSecurityParams) {
            String headerMapRef;
            List urlTemplates = ElementSupport.getChildElements((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver", "URLTemplate"));
            if (urlTemplates.size() == 0) {
                return null;
            }
            BeanDefinitionBuilder templateBuilder = BeanDefinitionBuilder.genericBeanDefinition(TemplatedURLBuilder.class);
            templateBuilder.setInitMethodName("initialize");
            templateBuilder.setDestroyMethodName("destroy");
            String velocityEngineRef = StringSupport.trimOrNull((String)this.configElement.getAttributeNS(null, "templateEngine"));
            if (null == velocityEngineRef) {
                velocityEngineRef = "shibboleth.VelocityEngine";
            }
            templateBuilder.addPropertyReference("velocityEngine", velocityEngineRef);
            if (httpClientSecurityParams != null) {
                templateBuilder.addPropertyValue("httpClientSecurityParameters", (Object)httpClientSecurityParams);
            }
            if (urlTemplates.size() > 1) {
                this.log.warn("{} A maximum of 1 <URLTemplate> should be specified; the first one has been used", (Object)this.getLogPrefix());
            }
            String url = null;
            if (!urlTemplates.isEmpty()) {
                url = ((Element)urlTemplates.get(0)).getTextContent();
            }
            templateBuilder.addPropertyValue("templateText", url);
            String customRef = StringSupport.trimOrNull((String)((Element)urlTemplates.get(0)).getAttributeNS(null, "customObjectRef"));
            if (null != customRef) {
                templateBuilder.addPropertyReference("customObject", customRef);
            }
            if ((headerMapRef = StringSupport.trimOrNull((String)this.configElement.getAttributeNS(null, "headerMapRef"))) != null) {
                templateBuilder.addPropertyReference("headers", headerMapRef);
            }
            return templateBuilder.getBeanDefinition();
        }

        @Nullable
        public BeanDefinition createBodyTemplateBuilder(@Nullable BeanDefinition httpClientSecurityParams) {
            String headerMapRef;
            List urlTemplates = ElementSupport.getChildElements((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver", "URLTemplate"));
            List bodyTemplates = ElementSupport.getChildElements((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver", "BodyTemplate"));
            if (urlTemplates.size() == 0 || bodyTemplates.size() == 0) {
                return null;
            }
            List cacheKeyTemplates = ElementSupport.getChildElements((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver", "CacheKeyTemplate"));
            BeanDefinitionBuilder templateBuilder = BeanDefinitionBuilder.genericBeanDefinition(TemplatedBodyBuilder.class);
            templateBuilder.setInitMethodName("initialize");
            templateBuilder.setDestroyMethodName("destroy");
            String velocityEngineRef = StringSupport.trimOrNull((String)this.configElement.getAttributeNS(null, "templateEngine"));
            if (null == velocityEngineRef) {
                velocityEngineRef = "shibboleth.VelocityEngine";
            }
            templateBuilder.addPropertyReference("velocityEngine", velocityEngineRef);
            if (httpClientSecurityParams != null) {
                templateBuilder.addPropertyValue("httpClientSecurityParameters", (Object)httpClientSecurityParams);
            }
            if (urlTemplates.size() > 1) {
                this.log.warn("{} A maximum of 1 <URLTemplate> should be specified; the first one has been used", (Object)this.getLogPrefix());
            }
            if (bodyTemplates.size() > 1) {
                this.log.warn("{} A maximum of 1 <BodyTemplate> should be specified; the first one has been used", (Object)this.getLogPrefix());
            }
            if (cacheKeyTemplates.size() > 1) {
                this.log.warn("{} A maximum of 1 <CacheKeyTemplate> should be specified; the first one has been used", (Object)this.getLogPrefix());
            }
            Element urlTemplate = (Element)urlTemplates.get(0);
            Element bodyTemplate = (Element)bodyTemplates.get(0);
            if (urlTemplate.hasAttributeNS(null, "customObjectRef")) {
                templateBuilder.addPropertyReference("customObject", AttributeSupport.ensureAttributeValue((Element)urlTemplate, null, (String)"customObjectRef"));
                if (bodyTemplate.hasAttributeNS(null, "customObjectRef")) {
                    this.log.warn("{} Ignored <BodyTemplate> customObjectRef in favor of <URLTemplate> customObjectRef", (Object)this.getLogPrefix());
                }
            } else if (bodyTemplate.hasAttributeNS(null, "customObjectRef")) {
                templateBuilder.addPropertyReference("customObject", AttributeSupport.ensureAttributeValue((Element)bodyTemplate, null, (String)"customObjectRef"));
            }
            templateBuilder.addPropertyValue("uRLTemplateText", (Object)urlTemplate.getTextContent());
            templateBuilder.addPropertyValue("bodyTemplateText", (Object)bodyTemplate.getTextContent());
            if (bodyTemplate.hasAttributeNS(null, "MIMEType")) {
                templateBuilder.addPropertyValue("mIMEType", (Object)bodyTemplate.getAttributeNS(null, "MIMEType"));
            }
            if (bodyTemplate.hasAttributeNS(null, "charset")) {
                templateBuilder.addPropertyValue("characterSet", (Object)bodyTemplate.getAttributeNS(null, "charset"));
            }
            if (!cacheKeyTemplates.isEmpty()) {
                templateBuilder.addPropertyValue("cacheKeyTemplateText", (Object)((Element)cacheKeyTemplates.get(0)).getTextContent());
            }
            if ((headerMapRef = StringSupport.trimOrNull((String)this.configElement.getAttributeNS(null, "headerMapRef"))) != null) {
                templateBuilder.addPropertyReference("headers", headerMapRef);
            }
            return templateBuilder.getBeanDefinition();
        }

        @Nullable
        public String getBeanMappingStrategyID() {
            return AttributeSupport.getAttributeValue((Element)this.configElement, null, (String)"mappingStrategyRef");
        }

        @Nullable
        public BeanDefinition createMappingStrategy(@Nullable String id) {
            Attr acceptTypesAttr;
            Attr acceptStatusesAttr;
            String maxLength;
            List mappings = ElementSupport.getChildElements((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver", "ResponseMapping"));
            if (mappings.size() > 1) {
                this.log.warn("{} A maximum of 1 <ResponseMapping> should be specified; the first one has been used", (Object)this.getLogPrefix());
            }
            if (mappings.isEmpty()) {
                this.log.error("{} No <ResponseMapping> provided", (Object)this.getLogPrefix());
                throw new BeanCreationException("No <ResponseMapping> provided");
            }
            Element map = (Element)mappings.get(0);
            assert (map != null);
            BeanDefinitionBuilder mapper = ScriptTypeBeanParser.parseScriptType(ScriptedResponseMappingStrategy.class, (Element)map);
            if (id != null) {
                mapper.addPropertyValue("logPrefix", (Object)(id + ":"));
            }
            if ((maxLength = StringSupport.trimOrNull((String)this.configElement.getAttributeNS(null, "maxLength"))) != null) {
                mapper.addPropertyValue("maxLength", (Object)maxLength);
            }
            if ((acceptStatusesAttr = this.configElement.getAttributeNodeNS(null, "acceptStatuses")) != null) {
                mapper.addPropertyValue("acceptStatuses", (Object)SpringSupport.getAttributeValueAsList((Attr)acceptStatusesAttr));
            }
            if ((acceptTypesAttr = this.configElement.getAttributeNodeNS(null, "acceptTypes")) != null) {
                mapper.addPropertyValue("acceptTypes", (Object)SpringSupport.getAttributeValueAsList((Attr)acceptTypesAttr));
            }
            return mapper.getBeanDefinition();
        }

        @Nullable
        public String getBeanValidatorID() {
            return AttributeSupport.getAttributeValue((Element)this.configElement, null, (String)"validatorRef");
        }

        @Nullable
        public BeanDefinition createCache(@Nonnull ParserContext parserContext) {
            CacheConfigParser parser = new CacheConfigParser(this.configElement);
            return parser.createCache();
        }

        @Nullable
        public BeanDefinition buildHttpClientSecurityParams(@Nullable String id) {
            String certificateAuthority;
            BeanDefinitionBuilder builder = null;
            String serverCertificate = StringSupport.trimOrNull((String)this.configElement.getAttributeNS(null, "serverCertificate"));
            if (serverCertificate != null) {
                this.log.debug("Auto-configuring connector {} with a server certificate to authenticate", (Object)id);
                builder = BeanDefinitionBuilder.genericBeanDefinition(HttpClientSecurityParameters.class);
                BeanDefinitionBuilder explicitTrust = BeanDefinitionBuilder.genericBeanDefinition(StaticExplicitKeyFactoryBean.class);
                explicitTrust.addPropertyValue("certificates", (Object)serverCertificate);
                builder.addPropertyValue("tLSTrustEngine", (Object)explicitTrust.getBeanDefinition());
            }
            if ((certificateAuthority = StringSupport.trimOrNull((String)this.configElement.getAttributeNS(null, "certificateAuthority"))) != null) {
                if (builder != null) {
                    this.log.warn("Ignoring certificateAuthority on connector {}, superseded by serverCertificate", (Object)id);
                } else {
                    this.log.debug("Auto-configuring connector {} with a certificate authority to authenticate", (Object)id);
                    builder = BeanDefinitionBuilder.genericBeanDefinition(HttpClientSecurityParameters.class);
                    BeanDefinitionBuilder pkixTrust = BeanDefinitionBuilder.genericBeanDefinition(StaticPKIXFactoryBean.class);
                    pkixTrust.addPropertyValue("checkNames", (Object)false);
                    pkixTrust.addPropertyValue("certificates", (Object)certificateAuthority);
                    builder.addPropertyValue("tLSTrustEngine", (Object)pkixTrust.getBeanDefinition());
                }
            }
            String clientPrivateKey = StringSupport.trimOrNull((String)this.configElement.getAttributeNS(null, "clientPrivateKey"));
            String clientCertificate = StringSupport.trimOrNull((String)this.configElement.getAttributeNS(null, "clientCertificate"));
            if (clientPrivateKey != null && clientCertificate != null) {
                this.log.debug("Auto-configuring connector {} with client TLS credential", (Object)id);
                if (builder == null) {
                    builder = BeanDefinitionBuilder.genericBeanDefinition(HttpClientSecurityParameters.class);
                }
                BeanDefinitionBuilder credentialBuilder = BeanDefinitionBuilder.genericBeanDefinition(BasicX509CredentialFactoryBean.class);
                credentialBuilder.addPropertyValue("privateKey", (Object)clientPrivateKey);
                credentialBuilder.addPropertyValue("certificates", (Object)clientCertificate);
                builder.addPropertyValue("clientTLSCredential", (Object)credentialBuilder.getBeanDefinition());
            }
            return builder != null ? builder.getBeanDefinition() : null;
        }

        @Nonnull
        @NotEmpty
        private String getLogPrefix() {
            return this.logPrefix;
        }
    }
}

