/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.spring;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import net.shibboleth.shared.spring.custom.AbstractCustomBeanDefinitionParser;
import net.shibboleth.shared.spring.util.SpringSupport;
import net.shibboleth.shared.xml.ElementSupport;
import org.slf4j.Logger;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseFilterParser
extends AbstractCustomBeanDefinitionParser {
    @Nonnull
    @NotEmpty
    public static final String NAMESPACE = "urn:mace:shibboleth:2.0:afp";
    @Nonnull
    public static final QName AFP_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:afp", "AttributeFilterPolicyGroup");
    @Nonnull
    public static final QName POLICY_REQUIREMENT_RULE = new QName("urn:mace:shibboleth:2.0:afp", "PolicyRequirementRule");
    @Nonnull
    public static final QName PERMIT_VALUE_RULE = new QName("urn:mace:shibboleth:2.0:afp", "PermitValueRule");
    @Nonnull
    public static final QName DENY_VALUE_RULE = new QName("urn:mace:shibboleth:2.0:afp", "DenyValueRule");
    @Nonnull
    @NotEmpty
    public static final String QUALIFIED_ID = "qualifiedId";
    @Nonnull
    private static IdentifierGenerationStrategy idGen = IdentifierGenerationStrategy.getInstance((IdentifierGenerationStrategy.ProviderType)IdentifierGenerationStrategy.ProviderType.RANDOM);
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(BaseFilterParser.class);

    @Nonnull
    @NotEmpty
    protected String getQualifiedId(@Nonnull Element configElement, @Nonnull String componentNamespace, @Nullable String localId) {
        Element afpgElement = configElement.getOwnerDocument().getDocumentElement();
        String policyGroupId = StringSupport.trimOrNull((String)afpgElement.getAttributeNS(null, "id"));
        StringBuilder qualifiedId = new StringBuilder();
        qualifiedId.append("/");
        qualifiedId.append(AFP_ELEMENT_NAME.getLocalPart());
        qualifiedId.append(":");
        qualifiedId.append(policyGroupId);
        if (!Strings.isNullOrEmpty((String)componentNamespace)) {
            qualifiedId.append("/");
            qualifiedId.append(componentNamespace);
            qualifiedId.append(":");
            if (Strings.isNullOrEmpty((String)localId)) {
                qualifiedId.append(idGen.generateIdentifier());
            } else {
                qualifiedId.append(localId);
            }
        }
        String result = qualifiedId.toString();
        assert (result != null);
        return result;
    }

    @Nonnull
    @NotEmpty
    protected String getAbsoluteReference(@Nonnull Element configElement, @Nonnull @NotEmpty String componentNamespace, @Nonnull @NotEmpty String reference) {
        if (reference.startsWith("/")) {
            return reference;
        }
        return this.getQualifiedId(configElement, componentNamespace, reference);
    }

    protected void doParse(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
        builder.setScope("prototype");
        String suppliedId = StringSupport.trimOrNull((String)element.getAttributeNS(null, "id"));
        String localName = element.getLocalName();
        assert (localName != null);
        String generatedId = this.getQualifiedId(element, localName, suppliedId);
        if (suppliedId == null) {
            LOG.trace("Element '{}' did not contain an 'id' attribute.  Generated id '{}' will be used", (Object)element.getLocalName(), (Object)generatedId);
        } else {
            LOG.debug("Element '{}' 'id' attribute '{}' is mapped to '{}'", new Object[]{element.getLocalName(), suppliedId, generatedId});
        }
        builder.getBeanDefinition().setAttribute(QUALIFIED_ID, (Object)generatedId);
    }

    @Nonnull
    @NotEmpty
    protected String resolveId(@Nonnull Element configElement, @Nonnull AbstractBeanDefinition beanDefinition, @Nonnull ParserContext parserContext) {
        String result = Constraint.isNotNull((Object)beanDefinition.getAttribute(QUALIFIED_ID), (String)"qualifiedId was absent").toString();
        assert (result != null);
        return result;
    }

    protected boolean isPolicyRule(@Nonnull Element element) {
        Element elem = element;
        do {
            if (ElementSupport.isElementNamed((Element)elem, (QName)POLICY_REQUIREMENT_RULE)) {
                return true;
            }
            if (!ElementSupport.isElementNamed((Element)elem, (QName)DENY_VALUE_RULE) && !ElementSupport.isElementNamed((Element)elem, (QName)PERMIT_VALUE_RULE)) continue;
            return false;
        } while ((elem = ElementSupport.getElementAncestor((Node)elem)) != null);
        LOG.warn("Element '{}' : could not find schema defined parent");
        return false;
    }

    @Nullable
    public static ManagedList<BeanDefinition> parseCustomElements(@Nullable Collection<Element> elements, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder parentBuilder) {
        if (elements == null) {
            return null;
        }
        Constraint.isNotNull((Object)parentBuilder, (String)"parentBuilder must not be null");
        ManagedList definitions = new ManagedList(elements.size());
        HashSet<String> beanNames = new HashSet<String>(elements.size());
        for (Element e : elements) {
            assert (e != null);
            BeanDefinition def = SpringSupport.parseCustomElement((Element)e, (ParserContext)parserContext, (BeanDefinitionBuilder)parentBuilder, (boolean)false);
            if (def == null) continue;
            definitions.add((Object)def);
            Object name = def.getAttribute(QUALIFIED_ID);
            if (name == null || beanNames.add(name.toString())) continue;
            LOG.warn("Duplicate filter element name {} found", name);
        }
        return definitions;
    }
}

