/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.module.impl;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import net.shibboleth.idp.module.IdPModule;
import net.shibboleth.profile.module.ModuleContext;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ApplicationObjectSupport;

public class ModuleGaugeSet
extends ApplicationObjectSupport
implements MetricSet,
MetricFilter {
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_METRIC_NAME = "net.shibboleth.idp.modules";
    @Nonnull
    private final Map<String, Metric> gauges = new HashMap<String, Metric>();

    public ModuleGaugeSet() {
        this.gauges.put(MetricRegistry.name((String)DEFAULT_METRIC_NAME, (String[])new String[]{"list"}), (Metric)new Gauge<Map<String, Boolean>>(){

            public Map<String, Boolean> getValue() {
                return ModuleGaugeSet.this.getModules();
            }
        });
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    private Map<String, Boolean> getModules() {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        Iterator<IdPModule> modules = ServiceLoader.load(IdPModule.class).iterator();
        ModuleContext mc = new ModuleContext(this.getIdpHome());
        while (modules.hasNext()) {
            IdPModule module = modules.next();
            result.put(module.getId(), module.isEnabled(mc));
        }
        return CollectionSupport.copyToMap(result);
    }

    @Nonnull
    private String getIdpHome() {
        ApplicationContext context = this.getApplicationContext();
        assert (context != null);
        return (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)context.getEnvironment().getProperty("idp.home")), (String)"idp.home is not available");
    }

    public Map<String, Metric> getMetrics() {
        return this.gauges;
    }

    protected boolean isContextRequired() {
        return true;
    }

    public boolean matches(String name, Metric metric) {
        return this.gauges.containsKey(name);
    }
}

